-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local DDR = {}

---@class DDR.Object
---@field key string
---@field value integer
local TObject = {}
TObject.__index = TObject
TObject.group = {}

local function TObject_from_obj(obj)
    return setmetatable(obj, TObject)
end

function TObject.new(dict)
    return TObject_from_obj(dict)
end

---@param obj DDR.Object
function TObject:init_from_obj(obj)
    self = obj
end

function TObject:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TObject.group)
end

TObject.from_obj = TObject_from_obj

TObject.proto_property = {}

TObject.default = {}

TObject.struct = {}

function TObject:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'uint32', false, errs, need_convert)

    end

    TObject:remove_error_props(errs, self)
    return self
end

function TObject:unpack(_)
    return self
end

DDR.Object = TObject

---@class DDR.GetTestParametersRsp
---@field TestParams DDR.Object
local TGetTestParametersRsp = {}
TGetTestParametersRsp.__index = TGetTestParametersRsp
TGetTestParametersRsp.group = {}

local function TGetTestParametersRsp_from_obj(obj)
    return setmetatable(obj, TGetTestParametersRsp)
end

function TGetTestParametersRsp.new(TestParams)
    return TGetTestParametersRsp_from_obj({TestParams = TestParams})
end
---@param obj DDR.GetTestParametersRsp
function TGetTestParametersRsp:init_from_obj(obj)
    self.TestParams = obj.TestParams
end

function TGetTestParametersRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetTestParametersRsp.group)
end

TGetTestParametersRsp.from_obj = TGetTestParametersRsp_from_obj

TGetTestParametersRsp.proto_property = {'TestParams'}

TGetTestParametersRsp.default = {DDR.Object.default}

TGetTestParametersRsp.struct = {{name = 'TestParams', is_array = false, struct = DDR.Object.struct}}

function TGetTestParametersRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    DDR.Object.new(self.TestParams):validate(prefix, errs, need_convert)

    TGetTestParametersRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetTestParametersRsp.proto_property, errs, need_convert)
    return self
end

function TGetTestParametersRsp:unpack(_)
    return self.TestParams
end

DDR.GetTestParametersRsp = TGetTestParametersRsp

---@class DDR.GetTestParametersReq
local TGetTestParametersReq = {}
TGetTestParametersReq.__index = TGetTestParametersReq
TGetTestParametersReq.group = {}

local function TGetTestParametersReq_from_obj(obj)
    return setmetatable(obj, TGetTestParametersReq)
end

function TGetTestParametersReq.new()
    return TGetTestParametersReq_from_obj({})
end
---@param obj DDR.GetTestParametersReq
function TGetTestParametersReq:init_from_obj(obj)

end

function TGetTestParametersReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetTestParametersReq.group)
end

TGetTestParametersReq.from_obj = TGetTestParametersReq_from_obj

TGetTestParametersReq.proto_property = {}

TGetTestParametersReq.default = {}

TGetTestParametersReq.struct = {}

function TGetTestParametersReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetTestParametersReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetTestParametersReq.proto_property, errs, need_convert)
    return self
end

function TGetTestParametersReq:unpack(_)
end

DDR.GetTestParametersReq = TGetTestParametersReq

---@class DDR.SetTestParametersRsp
local TSetTestParametersRsp = {}
TSetTestParametersRsp.__index = TSetTestParametersRsp
TSetTestParametersRsp.group = {}

local function TSetTestParametersRsp_from_obj(obj)
    return setmetatable(obj, TSetTestParametersRsp)
end

function TSetTestParametersRsp.new()
    return TSetTestParametersRsp_from_obj({})
end
---@param obj DDR.SetTestParametersRsp
function TSetTestParametersRsp:init_from_obj(obj)

end

function TSetTestParametersRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetTestParametersRsp.group)
end

TSetTestParametersRsp.from_obj = TSetTestParametersRsp_from_obj

TSetTestParametersRsp.proto_property = {}

TSetTestParametersRsp.default = {}

TSetTestParametersRsp.struct = {}

function TSetTestParametersRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetTestParametersRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetTestParametersRsp.proto_property, errs, need_convert)
    return self
end

function TSetTestParametersRsp:unpack(_)
end

DDR.SetTestParametersRsp = TSetTestParametersRsp

---@class DDR.SetTestParametersReq
---@field TestParams DDR.Object
local TSetTestParametersReq = {}
TSetTestParametersReq.__index = TSetTestParametersReq
TSetTestParametersReq.group = {}

local function TSetTestParametersReq_from_obj(obj)
    return setmetatable(obj, TSetTestParametersReq)
end

function TSetTestParametersReq.new(TestParams)
    return TSetTestParametersReq_from_obj({TestParams = TestParams})
end
---@param obj DDR.SetTestParametersReq
function TSetTestParametersReq:init_from_obj(obj)
    self.TestParams = obj.TestParams
end

function TSetTestParametersReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetTestParametersReq.group)
end

TSetTestParametersReq.from_obj = TSetTestParametersReq_from_obj

TSetTestParametersReq.proto_property = {'TestParams'}

TSetTestParametersReq.default = {DDR.Object.default}

TSetTestParametersReq.struct = {{name = 'TestParams', is_array = false, struct = DDR.Object.struct}}

function TSetTestParametersReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    DDR.Object.new(self.TestParams):validate(prefix, errs, need_convert)

    TSetTestParametersReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetTestParametersReq.proto_property, errs, need_convert)
    return self
end

function TSetTestParametersReq:unpack(_)
    return self.TestParams
end

DDR.SetTestParametersReq = TSetTestParametersReq

DDR.interface = mdb.register_interface('bmc.kepler.Managers.SOC.DDR', {}, {
    SetTestParameters = {'a{ss}a{su}', '', TSetTestParametersReq, TSetTestParametersRsp},
    GetTestParameters = {'a{ss}', 'a{su}', TGetTestParametersReq, TGetTestParametersRsp}
}, {})

return DDR
