-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Board = {}

Board.interface = mdb.register_interface('bmc.kepler.Systems.Board', {
    Slot = {'y', nil, true, nil},
    Number = {'y', nil, true, nil},
    Position = {'s', nil, true, nil},
    Name = {'s', nil, true, nil},
    ProductName = {'s', nil, true, nil},
    SilkText = {'s', nil, true, nil},
    Manufacturer = {'s', nil, true, nil},
    Description = {'s', nil, true, nil},
    BoardID = {'q', nil, true, nil},
    PartNumber = {'s', nil, true, nil},
    PcbVersion = {'s', nil, true, nil},
    LogicVersion = {'s', nil, true, nil},
    SRVersion = {'s', nil, true, nil},
    MCUVersion = {'s', nil, true, nil},
    PSIPVersion = {'s', nil, true, nil},
    LogicUnit = {'u', nil, true, nil},
    PowerWatts = {'u', {['emitsChangedSignal'] = 'false'}, true, nil},
    RunningStatus = {'y', nil, true, nil},
    FruID = {'y', nil, true, nil},
    NodeId = {'s', nil, true, nil},
    DeviceName = {'s', nil, true, nil},
    BoardType = {'s', nil, true, nil},
    RefComponent = {'s', nil, true, nil},
    RefFru = {'s', nil, true, nil},
    SerialNumber = {'s', nil, true, nil},
    CpldStatus = {'y', nil, true, nil},
    MultiLogicUnit = {'a{su}', nil, true, nil},
    MultiLogicVersion = {'a{ss}', nil, true, nil}
}, {}, {})

return Board
