-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Bios = {}

---@class Bios.ExportFirmwareRsp
---@field TaskId integer
local TExportFirmwareRsp = {}
TExportFirmwareRsp.__index = TExportFirmwareRsp
TExportFirmwareRsp.group = {}

local function TExportFirmwareRsp_from_obj(obj)
    return setmetatable(obj, TExportFirmwareRsp)
end

function TExportFirmwareRsp.new(TaskId)
    return TExportFirmwareRsp_from_obj({TaskId = TaskId})
end
---@param obj Bios.ExportFirmwareRsp
function TExportFirmwareRsp:init_from_obj(obj)
    self.TaskId = obj.TaskId
end

function TExportFirmwareRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportFirmwareRsp.group)
end

TExportFirmwareRsp.from_obj = TExportFirmwareRsp_from_obj

TExportFirmwareRsp.proto_property = {'TaskId'}

TExportFirmwareRsp.default = {0}

TExportFirmwareRsp.struct = {{name = 'TaskId', is_array = false, struct = nil}}

function TExportFirmwareRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TaskId', self.TaskId, 'uint32', false, errs, need_convert)

    TExportFirmwareRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportFirmwareRsp.proto_property, errs, need_convert)
    return self
end

function TExportFirmwareRsp:unpack(_)
    return self.TaskId
end

Bios.ExportFirmwareRsp = TExportFirmwareRsp

---@class Bios.ExportFirmwareReq
---@field OutputFilePath string
local TExportFirmwareReq = {}
TExportFirmwareReq.__index = TExportFirmwareReq
TExportFirmwareReq.group = {}

local function TExportFirmwareReq_from_obj(obj)
    return setmetatable(obj, TExportFirmwareReq)
end

function TExportFirmwareReq.new(OutputFilePath)
    return TExportFirmwareReq_from_obj({OutputFilePath = OutputFilePath})
end
---@param obj Bios.ExportFirmwareReq
function TExportFirmwareReq:init_from_obj(obj)
    self.OutputFilePath = obj.OutputFilePath
end

function TExportFirmwareReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportFirmwareReq.group)
end

TExportFirmwareReq.from_obj = TExportFirmwareReq_from_obj

TExportFirmwareReq.proto_property = {'OutputFilePath'}

TExportFirmwareReq.default = {''}

TExportFirmwareReq.struct = {{name = 'OutputFilePath', is_array = false, struct = nil}}

function TExportFirmwareReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'OutputFilePath', self.OutputFilePath, 'string', false, errs, need_convert)

    TExportFirmwareReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportFirmwareReq.proto_property, errs, need_convert)
    return self
end

function TExportFirmwareReq:unpack(_)
    return self.OutputFilePath
end

Bios.ExportFirmwareReq = TExportFirmwareReq

---@class Bios.RemoveCachedSettingsRsp
---@field Result integer
local TRemoveCachedSettingsRsp = {}
TRemoveCachedSettingsRsp.__index = TRemoveCachedSettingsRsp
TRemoveCachedSettingsRsp.group = {}

local function TRemoveCachedSettingsRsp_from_obj(obj)
    return setmetatable(obj, TRemoveCachedSettingsRsp)
end

function TRemoveCachedSettingsRsp.new(Result)
    return TRemoveCachedSettingsRsp_from_obj({Result = Result})
end
---@param obj Bios.RemoveCachedSettingsRsp
function TRemoveCachedSettingsRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TRemoveCachedSettingsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRemoveCachedSettingsRsp.group)
end

TRemoveCachedSettingsRsp.from_obj = TRemoveCachedSettingsRsp_from_obj

TRemoveCachedSettingsRsp.proto_property = {'Result'}

TRemoveCachedSettingsRsp.default = {0}

TRemoveCachedSettingsRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TRemoveCachedSettingsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TRemoveCachedSettingsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRemoveCachedSettingsRsp.proto_property, errs, need_convert)
    return self
end

function TRemoveCachedSettingsRsp:unpack(_)
    return self.Result
end

Bios.RemoveCachedSettingsRsp = TRemoveCachedSettingsRsp

---@class Bios.RemoveCachedSettingsReq
local TRemoveCachedSettingsReq = {}
TRemoveCachedSettingsReq.__index = TRemoveCachedSettingsReq
TRemoveCachedSettingsReq.group = {}

local function TRemoveCachedSettingsReq_from_obj(obj)
    return setmetatable(obj, TRemoveCachedSettingsReq)
end

function TRemoveCachedSettingsReq.new()
    return TRemoveCachedSettingsReq_from_obj({})
end
---@param obj Bios.RemoveCachedSettingsReq
function TRemoveCachedSettingsReq:init_from_obj(obj)

end

function TRemoveCachedSettingsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TRemoveCachedSettingsReq.group)
end

TRemoveCachedSettingsReq.from_obj = TRemoveCachedSettingsReq_from_obj

TRemoveCachedSettingsReq.proto_property = {}

TRemoveCachedSettingsReq.default = {}

TRemoveCachedSettingsReq.struct = {}

function TRemoveCachedSettingsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TRemoveCachedSettingsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TRemoveCachedSettingsReq.proto_property, errs, need_convert)
    return self
end

function TRemoveCachedSettingsReq:unpack(_)
end

Bios.RemoveCachedSettingsReq = TRemoveCachedSettingsReq

---@class Bios.GetCurrentValueSettingRsp
---@field RespValue string
local TGetCurrentValueSettingRsp = {}
TGetCurrentValueSettingRsp.__index = TGetCurrentValueSettingRsp
TGetCurrentValueSettingRsp.group = {}

local function TGetCurrentValueSettingRsp_from_obj(obj)
    return setmetatable(obj, TGetCurrentValueSettingRsp)
end

function TGetCurrentValueSettingRsp.new(RespValue)
    return TGetCurrentValueSettingRsp_from_obj({RespValue = RespValue})
end
---@param obj Bios.GetCurrentValueSettingRsp
function TGetCurrentValueSettingRsp:init_from_obj(obj)
    self.RespValue = obj.RespValue
end

function TGetCurrentValueSettingRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCurrentValueSettingRsp.group)
end

TGetCurrentValueSettingRsp.from_obj = TGetCurrentValueSettingRsp_from_obj

TGetCurrentValueSettingRsp.proto_property = {'RespValue'}

TGetCurrentValueSettingRsp.default = {''}

TGetCurrentValueSettingRsp.struct = {{name = 'RespValue', is_array = false, struct = nil}}

function TGetCurrentValueSettingRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'RespValue', self.RespValue, 'string', false, errs, need_convert)

    TGetCurrentValueSettingRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCurrentValueSettingRsp.proto_property, errs, need_convert)
    return self
end

function TGetCurrentValueSettingRsp:unpack(_)
    return self.RespValue
end

Bios.GetCurrentValueSettingRsp = TGetCurrentValueSettingRsp

---@class Bios.GetCurrentValueSettingReq
---@field ReqKey string
local TGetCurrentValueSettingReq = {}
TGetCurrentValueSettingReq.__index = TGetCurrentValueSettingReq
TGetCurrentValueSettingReq.group = {}

local function TGetCurrentValueSettingReq_from_obj(obj)
    return setmetatable(obj, TGetCurrentValueSettingReq)
end

function TGetCurrentValueSettingReq.new(ReqKey)
    return TGetCurrentValueSettingReq_from_obj({ReqKey = ReqKey})
end
---@param obj Bios.GetCurrentValueSettingReq
function TGetCurrentValueSettingReq:init_from_obj(obj)
    self.ReqKey = obj.ReqKey
end

function TGetCurrentValueSettingReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetCurrentValueSettingReq.group)
end

TGetCurrentValueSettingReq.from_obj = TGetCurrentValueSettingReq_from_obj

TGetCurrentValueSettingReq.proto_property = {'ReqKey'}

TGetCurrentValueSettingReq.default = {''}

TGetCurrentValueSettingReq.struct = {{name = 'ReqKey', is_array = false, struct = nil}}

function TGetCurrentValueSettingReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ReqKey', self.ReqKey, 'string', false, errs, need_convert)

    TGetCurrentValueSettingReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetCurrentValueSettingReq.proto_property, errs, need_convert)
    return self
end

function TGetCurrentValueSettingReq:unpack(_)
    return self.ReqKey
end

Bios.GetCurrentValueSettingReq = TGetCurrentValueSettingReq

---@class Bios.ImportBiosSetupRsp
---@field Result integer
local TImportBiosSetupRsp = {}
TImportBiosSetupRsp.__index = TImportBiosSetupRsp
TImportBiosSetupRsp.group = {}

local function TImportBiosSetupRsp_from_obj(obj)
    return setmetatable(obj, TImportBiosSetupRsp)
end

function TImportBiosSetupRsp.new(Result)
    return TImportBiosSetupRsp_from_obj({Result = Result})
end
---@param obj Bios.ImportBiosSetupRsp
function TImportBiosSetupRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TImportBiosSetupRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportBiosSetupRsp.group)
end

TImportBiosSetupRsp.from_obj = TImportBiosSetupRsp_from_obj

TImportBiosSetupRsp.proto_property = {'Result'}

TImportBiosSetupRsp.default = {0}

TImportBiosSetupRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TImportBiosSetupRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TImportBiosSetupRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportBiosSetupRsp.proto_property, errs, need_convert)
    return self
end

function TImportBiosSetupRsp:unpack(_)
    return self.Result
end

Bios.ImportBiosSetupRsp = TImportBiosSetupRsp

---@class Bios.ImportBiosSetupReq
---@field FileType string
---@field Content string
local TImportBiosSetupReq = {}
TImportBiosSetupReq.__index = TImportBiosSetupReq
TImportBiosSetupReq.group = {}

local function TImportBiosSetupReq_from_obj(obj)
    return setmetatable(obj, TImportBiosSetupReq)
end

function TImportBiosSetupReq.new(FileType, Content)
    return TImportBiosSetupReq_from_obj({FileType = FileType, Content = Content})
end
---@param obj Bios.ImportBiosSetupReq
function TImportBiosSetupReq:init_from_obj(obj)
    self.FileType = obj.FileType
    self.Content = obj.Content
end

function TImportBiosSetupReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TImportBiosSetupReq.group)
end

TImportBiosSetupReq.from_obj = TImportBiosSetupReq_from_obj

TImportBiosSetupReq.proto_property = {'FileType', 'Content'}

TImportBiosSetupReq.default = {'', ''}

TImportBiosSetupReq.struct = {
    {name = 'FileType', is_array = false, struct = nil}, {name = 'Content', is_array = false, struct = nil}
}

function TImportBiosSetupReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FileType', self.FileType, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Content', self.Content, 'string', false, errs, need_convert)

    TImportBiosSetupReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TImportBiosSetupReq.proto_property, errs, need_convert)
    return self
end

function TImportBiosSetupReq:unpack(_)
    return self.FileType, self.Content
end

Bios.ImportBiosSetupReq = TImportBiosSetupReq

---@class Bios.ExportBiosSetupRsp
---@field Result string
local TExportBiosSetupRsp = {}
TExportBiosSetupRsp.__index = TExportBiosSetupRsp
TExportBiosSetupRsp.group = {}

local function TExportBiosSetupRsp_from_obj(obj)
    return setmetatable(obj, TExportBiosSetupRsp)
end

function TExportBiosSetupRsp.new(Result)
    return TExportBiosSetupRsp_from_obj({Result = Result})
end
---@param obj Bios.ExportBiosSetupRsp
function TExportBiosSetupRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TExportBiosSetupRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportBiosSetupRsp.group)
end

TExportBiosSetupRsp.from_obj = TExportBiosSetupRsp_from_obj

TExportBiosSetupRsp.proto_property = {'Result'}

TExportBiosSetupRsp.default = {''}

TExportBiosSetupRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TExportBiosSetupRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'string', false, errs, need_convert)

    TExportBiosSetupRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportBiosSetupRsp.proto_property, errs, need_convert)
    return self
end

function TExportBiosSetupRsp:unpack(_)
    return self.Result
end

Bios.ExportBiosSetupRsp = TExportBiosSetupRsp

---@class Bios.ExportBiosSetupReq
---@field FileType string
local TExportBiosSetupReq = {}
TExportBiosSetupReq.__index = TExportBiosSetupReq
TExportBiosSetupReq.group = {}

local function TExportBiosSetupReq_from_obj(obj)
    return setmetatable(obj, TExportBiosSetupReq)
end

function TExportBiosSetupReq.new(FileType)
    return TExportBiosSetupReq_from_obj({FileType = FileType})
end
---@param obj Bios.ExportBiosSetupReq
function TExportBiosSetupReq:init_from_obj(obj)
    self.FileType = obj.FileType
end

function TExportBiosSetupReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportBiosSetupReq.group)
end

TExportBiosSetupReq.from_obj = TExportBiosSetupReq_from_obj

TExportBiosSetupReq.proto_property = {'FileType'}

TExportBiosSetupReq.default = {''}

TExportBiosSetupReq.struct = {{name = 'FileType', is_array = false, struct = nil}}

function TExportBiosSetupReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FileType', self.FileType, 'string', false, errs, need_convert)

    TExportBiosSetupReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportBiosSetupReq.proto_property, errs, need_convert)
    return self
end

function TExportBiosSetupReq:unpack(_)
    return self.FileType
end

Bios.ExportBiosSetupReq = TExportBiosSetupReq

---@class Bios.SetBiosLogEnabledRsp
---@field Result integer
local TSetBiosLogEnabledRsp = {}
TSetBiosLogEnabledRsp.__index = TSetBiosLogEnabledRsp
TSetBiosLogEnabledRsp.group = {}

local function TSetBiosLogEnabledRsp_from_obj(obj)
    return setmetatable(obj, TSetBiosLogEnabledRsp)
end

function TSetBiosLogEnabledRsp.new(Result)
    return TSetBiosLogEnabledRsp_from_obj({Result = Result})
end
---@param obj Bios.SetBiosLogEnabledRsp
function TSetBiosLogEnabledRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TSetBiosLogEnabledRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBiosLogEnabledRsp.group)
end

TSetBiosLogEnabledRsp.from_obj = TSetBiosLogEnabledRsp_from_obj

TSetBiosLogEnabledRsp.proto_property = {'Result'}

TSetBiosLogEnabledRsp.default = {0}

TSetBiosLogEnabledRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetBiosLogEnabledRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TSetBiosLogEnabledRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBiosLogEnabledRsp.proto_property, errs, need_convert)
    return self
end

function TSetBiosLogEnabledRsp:unpack(_)
    return self.Result
end

Bios.SetBiosLogEnabledRsp = TSetBiosLogEnabledRsp

---@class Bios.SetBiosLogEnabledReq
---@field BiosLogPrintEnabled integer
local TSetBiosLogEnabledReq = {}
TSetBiosLogEnabledReq.__index = TSetBiosLogEnabledReq
TSetBiosLogEnabledReq.group = {}

local function TSetBiosLogEnabledReq_from_obj(obj)
    return setmetatable(obj, TSetBiosLogEnabledReq)
end

function TSetBiosLogEnabledReq.new(BiosLogPrintEnabled)
    return TSetBiosLogEnabledReq_from_obj({BiosLogPrintEnabled = BiosLogPrintEnabled})
end
---@param obj Bios.SetBiosLogEnabledReq
function TSetBiosLogEnabledReq:init_from_obj(obj)
    self.BiosLogPrintEnabled = obj.BiosLogPrintEnabled
end

function TSetBiosLogEnabledReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBiosLogEnabledReq.group)
end

TSetBiosLogEnabledReq.from_obj = TSetBiosLogEnabledReq_from_obj

TSetBiosLogEnabledReq.proto_property = {'BiosLogPrintEnabled'}

TSetBiosLogEnabledReq.default = {0}

TSetBiosLogEnabledReq.struct = {{name = 'BiosLogPrintEnabled', is_array = false, struct = nil}}

function TSetBiosLogEnabledReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BiosLogPrintEnabled', self.BiosLogPrintEnabled, 'uint8', false, errs, need_convert)

    TSetBiosLogEnabledReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBiosLogEnabledReq.proto_property, errs, need_convert)
    return self
end

function TSetBiosLogEnabledReq:unpack(_)
    return self.BiosLogPrintEnabled
end

Bios.SetBiosLogEnabledReq = TSetBiosLogEnabledReq

---@class Bios.ChangePasswordRsp
---@field Result integer
local TChangePasswordRsp = {}
TChangePasswordRsp.__index = TChangePasswordRsp
TChangePasswordRsp.group = {}

local function TChangePasswordRsp_from_obj(obj)
    return setmetatable(obj, TChangePasswordRsp)
end

function TChangePasswordRsp.new(Result)
    return TChangePasswordRsp_from_obj({Result = Result})
end
---@param obj Bios.ChangePasswordRsp
function TChangePasswordRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TChangePasswordRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChangePasswordRsp.group)
end

TChangePasswordRsp.from_obj = TChangePasswordRsp_from_obj

TChangePasswordRsp.proto_property = {'Result'}

TChangePasswordRsp.default = {0}

TChangePasswordRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TChangePasswordRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TChangePasswordRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChangePasswordRsp.proto_property, errs, need_convert)
    return self
end

function TChangePasswordRsp:unpack(_)
    return self.Result
end

Bios.ChangePasswordRsp = TChangePasswordRsp

---@class Bios.ChangePasswordReq
---@field PasswordType string
---@field OldPassword string
---@field NewPassword string
local TChangePasswordReq = {}
TChangePasswordReq.__index = TChangePasswordReq
TChangePasswordReq.group = {}

local function TChangePasswordReq_from_obj(obj)
    return setmetatable(obj, TChangePasswordReq)
end

function TChangePasswordReq.new(PasswordType, OldPassword, NewPassword)
    return TChangePasswordReq_from_obj({
        PasswordType = PasswordType,
        OldPassword = OldPassword,
        NewPassword = NewPassword
    })
end
---@param obj Bios.ChangePasswordReq
function TChangePasswordReq:init_from_obj(obj)
    self.PasswordType = obj.PasswordType
    self.OldPassword = obj.OldPassword
    self.NewPassword = obj.NewPassword
end

function TChangePasswordReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TChangePasswordReq.group)
end

TChangePasswordReq.from_obj = TChangePasswordReq_from_obj

TChangePasswordReq.proto_property = {'PasswordType', 'OldPassword', 'NewPassword'}

TChangePasswordReq.default = {'', '', ''}

TChangePasswordReq.struct = {
    {name = 'PasswordType', is_array = false, struct = nil}, {name = 'OldPassword', is_array = false, struct = nil},
    {name = 'NewPassword', is_array = false, struct = nil}
}

function TChangePasswordReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PasswordType', self.PasswordType, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'OldPassword', self.OldPassword, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'NewPassword', self.NewPassword, 'string', false, errs, need_convert)

    TChangePasswordReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TChangePasswordReq.proto_property, errs, need_convert)
    return self
end

function TChangePasswordReq:unpack(_)
    return self.PasswordType, self.OldPassword, self.NewPassword
end

Bios.ChangePasswordReq = TChangePasswordReq

---@class Bios.ResetSetupConfigRsp
---@field Result integer
local TResetSetupConfigRsp = {}
TResetSetupConfigRsp.__index = TResetSetupConfigRsp
TResetSetupConfigRsp.group = {}

local function TResetSetupConfigRsp_from_obj(obj)
    return setmetatable(obj, TResetSetupConfigRsp)
end

function TResetSetupConfigRsp.new(Result)
    return TResetSetupConfigRsp_from_obj({Result = Result})
end
---@param obj Bios.ResetSetupConfigRsp
function TResetSetupConfigRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TResetSetupConfigRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetSetupConfigRsp.group)
end

TResetSetupConfigRsp.from_obj = TResetSetupConfigRsp_from_obj

TResetSetupConfigRsp.proto_property = {'Result'}

TResetSetupConfigRsp.default = {0}

TResetSetupConfigRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TResetSetupConfigRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TResetSetupConfigRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetSetupConfigRsp.proto_property, errs, need_convert)
    return self
end

function TResetSetupConfigRsp:unpack(_)
    return self.Result
end

Bios.ResetSetupConfigRsp = TResetSetupConfigRsp

---@class Bios.ResetSetupConfigReq
local TResetSetupConfigReq = {}
TResetSetupConfigReq.__index = TResetSetupConfigReq
TResetSetupConfigReq.group = {}

local function TResetSetupConfigReq_from_obj(obj)
    return setmetatable(obj, TResetSetupConfigReq)
end

function TResetSetupConfigReq.new()
    return TResetSetupConfigReq_from_obj({})
end
---@param obj Bios.ResetSetupConfigReq
function TResetSetupConfigReq:init_from_obj(obj)

end

function TResetSetupConfigReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TResetSetupConfigReq.group)
end

TResetSetupConfigReq.from_obj = TResetSetupConfigReq_from_obj

TResetSetupConfigReq.proto_property = {}

TResetSetupConfigReq.default = {}

TResetSetupConfigReq.struct = {}

function TResetSetupConfigReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TResetSetupConfigReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TResetSetupConfigReq.proto_property, errs, need_convert)
    return self
end

function TResetSetupConfigReq:unpack(_)
end

Bios.ResetSetupConfigReq = TResetSetupConfigReq

---@class Bios.SetBiosConfigActiveModeRsp
local TSetBiosConfigActiveModeRsp = {}
TSetBiosConfigActiveModeRsp.__index = TSetBiosConfigActiveModeRsp
TSetBiosConfigActiveModeRsp.group = {}

local function TSetBiosConfigActiveModeRsp_from_obj(obj)
    return setmetatable(obj, TSetBiosConfigActiveModeRsp)
end

function TSetBiosConfigActiveModeRsp.new()
    return TSetBiosConfigActiveModeRsp_from_obj({})
end
---@param obj Bios.SetBiosConfigActiveModeRsp
function TSetBiosConfigActiveModeRsp:init_from_obj(obj)

end

function TSetBiosConfigActiveModeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBiosConfigActiveModeRsp.group)
end

TSetBiosConfigActiveModeRsp.from_obj = TSetBiosConfigActiveModeRsp_from_obj

TSetBiosConfigActiveModeRsp.proto_property = {}

TSetBiosConfigActiveModeRsp.default = {}

TSetBiosConfigActiveModeRsp.struct = {}

function TSetBiosConfigActiveModeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetBiosConfigActiveModeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBiosConfigActiveModeRsp.proto_property, errs, need_convert)
    return self
end

function TSetBiosConfigActiveModeRsp:unpack(_)
end

Bios.SetBiosConfigActiveModeRsp = TSetBiosConfigActiveModeRsp

---@class Bios.SetBiosConfigActiveModeReq
---@field Mode integer
local TSetBiosConfigActiveModeReq = {}
TSetBiosConfigActiveModeReq.__index = TSetBiosConfigActiveModeReq
TSetBiosConfigActiveModeReq.group = {}

local function TSetBiosConfigActiveModeReq_from_obj(obj)
    return setmetatable(obj, TSetBiosConfigActiveModeReq)
end

function TSetBiosConfigActiveModeReq.new(Mode)
    return TSetBiosConfigActiveModeReq_from_obj({Mode = Mode})
end
---@param obj Bios.SetBiosConfigActiveModeReq
function TSetBiosConfigActiveModeReq:init_from_obj(obj)
    self.Mode = obj.Mode
end

function TSetBiosConfigActiveModeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBiosConfigActiveModeReq.group)
end

TSetBiosConfigActiveModeReq.from_obj = TSetBiosConfigActiveModeReq_from_obj

TSetBiosConfigActiveModeReq.proto_property = {'Mode'}

TSetBiosConfigActiveModeReq.default = {0}

TSetBiosConfigActiveModeReq.struct = {{name = 'Mode', is_array = false, struct = nil}}

function TSetBiosConfigActiveModeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Mode', self.Mode, 'uint64', false, errs, need_convert)

    TSetBiosConfigActiveModeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBiosConfigActiveModeReq.proto_property, errs, need_convert)
    return self
end

function TSetBiosConfigActiveModeReq:unpack(_)
    return self.Mode
end

Bios.SetBiosConfigActiveModeReq = TSetBiosConfigActiveModeReq

---@class Bios.ClearCmosRsp
---@field Result integer
local TClearCmosRsp = {}
TClearCmosRsp.__index = TClearCmosRsp
TClearCmosRsp.group = {}

local function TClearCmosRsp_from_obj(obj)
    return setmetatable(obj, TClearCmosRsp)
end

function TClearCmosRsp.new(Result)
    return TClearCmosRsp_from_obj({Result = Result})
end
---@param obj Bios.ClearCmosRsp
function TClearCmosRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TClearCmosRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClearCmosRsp.group)
end

TClearCmosRsp.from_obj = TClearCmosRsp_from_obj

TClearCmosRsp.proto_property = {'Result'}

TClearCmosRsp.default = {0}

TClearCmosRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TClearCmosRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TClearCmosRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClearCmosRsp.proto_property, errs, need_convert)
    return self
end

function TClearCmosRsp:unpack(_)
    return self.Result
end

Bios.ClearCmosRsp = TClearCmosRsp

---@class Bios.ClearCmosReq
local TClearCmosReq = {}
TClearCmosReq.__index = TClearCmosReq
TClearCmosReq.group = {}

local function TClearCmosReq_from_obj(obj)
    return setmetatable(obj, TClearCmosReq)
end

function TClearCmosReq.new()
    return TClearCmosReq_from_obj({})
end
---@param obj Bios.ClearCmosReq
function TClearCmosReq:init_from_obj(obj)

end

function TClearCmosReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClearCmosReq.group)
end

TClearCmosReq.from_obj = TClearCmosReq_from_obj

TClearCmosReq.proto_property = {}

TClearCmosReq.default = {}

TClearCmosReq.struct = {}

function TClearCmosReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TClearCmosReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClearCmosReq.proto_property, errs, need_convert)
    return self
end

function TClearCmosReq:unpack(_)
end

Bios.ClearCmosReq = TClearCmosReq

Bios.interface = mdb.register_interface('bmc.kepler.Systems.Bios', {
    SystemStartupState = {'y', nil, true, nil},
    SystemId = {'y', nil, true, nil},
    Version = {'s', nil, true, nil},
    BackupVersion = {'s', nil, true, nil},
    CurrentValueFileName = {'s', nil, true, nil},
    ResultFileName = {'s', nil, true, nil},
    SettingFileName = {'s', nil, true, nil},
    RegistryFileName = {'s', nil, true, nil},
    MenuData = {'s', nil, true, nil},
    MenuChangeFlag = {'y', nil, true, nil},
    RegistryVersion = {'s', nil, true, nil},
    DEMTConfig = {'y', nil, true, nil},
    PcieCardBDF = {'ay', nil, true, nil},
    PcieDiskBDF = {'ay', nil, true, nil},
    OCPCardBDF = {'ay', nil, true, nil},
    BiosBootStage = {'y', nil, true, nil},
    UpgradeFailed = {'y', nil, true, nil},
    RecoverFailed = {'y', nil, true, nil},
    BiosLogPrintEnabled = {'y', nil, true, nil},
    SettingsEffectiveStatus = {'s', nil, true, nil},
    BiosConfigActiveMode = {'t', nil, true, nil},
    TeeOSVersion = {'s', nil, true, nil},
    ResetBiosToDefaultsPending = {'b', nil, true, nil}
}, {
    ClearCmos = {'a{ss}', 'i', TClearCmosReq, TClearCmosRsp},
    SetBiosConfigActiveMode = {'a{ss}t', '', TSetBiosConfigActiveModeReq, TSetBiosConfigActiveModeRsp},
    ResetSetupConfig = {'a{ss}', 'i', TResetSetupConfigReq, TResetSetupConfigRsp},
    ChangePassword = {'a{ss}sss', 'i', TChangePasswordReq, TChangePasswordRsp},
    SetBiosLogEnabled = {'a{ss}y', 'i', TSetBiosLogEnabledReq, TSetBiosLogEnabledRsp},
    ExportBiosSetup = {'a{ss}s', 's', TExportBiosSetupReq, TExportBiosSetupRsp},
    ImportBiosSetup = {'a{ss}ss', 'i', TImportBiosSetupReq, TImportBiosSetupRsp},
    GetCurrentValueSetting = {'a{ss}s', 's', TGetCurrentValueSettingReq, TGetCurrentValueSettingRsp},
    RemoveCachedSettings = {'a{ss}', 'i', TRemoveCachedSettingsReq, TRemoveCachedSettingsRsp},
    ExportFirmware = {'a{ss}s', 'u', TExportFirmwareReq, TExportFirmwareRsp}
}, {})

return Bios
