--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetTestType = {}

---@class ManufactureIpmiCmds.SetTestTypeReq
---@field FRUDeviceID integer
---@field TestType integer
---@field Open integer
---@field Param integer
local TSetTestTypeReq = {}
TSetTestTypeReq.__index = TSetTestTypeReq
TSetTestTypeReq.group = {}

local function TSetTestTypeReq_from_obj(obj)
    return setmetatable(obj, TSetTestTypeReq)
end

function TSetTestTypeReq.new(FRUDeviceID, TestType, Open, Param)
    return TSetTestTypeReq_from_obj({FRUDeviceID = FRUDeviceID, TestType = TestType, Open = Open, Param = Param})
end
---@param obj ManufactureIpmiCmds.SetTestTypeReq
function TSetTestTypeReq:init_from_obj(obj)
    self.FRUDeviceID = obj.FRUDeviceID
    self.TestType = obj.TestType
    self.Open = obj.Open
    self.Param = obj.Param
end

function TSetTestTypeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetTestTypeReq.group)
end

TSetTestTypeReq.from_obj = TSetTestTypeReq_from_obj

TSetTestTypeReq.proto_property = {'FRUDeviceID', 'TestType', 'Open', 'Param'}

TSetTestTypeReq.default = {0, 0, 0, 0}

TSetTestTypeReq.struct = {
    {name = 'FRUDeviceID', is_array = false, struct = nil}, {name = 'TestType', is_array = false, struct = nil},
    {name = 'Open', is_array = false, struct = nil}, {name = 'Param', is_array = false, struct = nil}
}

function TSetTestTypeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FRUDeviceID', self.FRUDeviceID, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'TestType', self.TestType, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Open', self.Open, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Param', self.Param, 'uint8', false, errs, need_convert)

    TSetTestTypeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetTestTypeReq.proto_property, errs, need_convert)
    return self
end

function TSetTestTypeReq:unpack(_)
    return self.FRUDeviceID, self.TestType, self.Open, self.Param
end

SetTestType.SetTestTypeReq = TSetTestTypeReq

---@class ManufactureIpmiCmds.SetTestTypeRsp
---@field CompletionCode integer
local TSetTestTypeRsp = {}
TSetTestTypeRsp.__index = TSetTestTypeRsp
TSetTestTypeRsp.group = {}

local function TSetTestTypeRsp_from_obj(obj)
    return setmetatable(obj, TSetTestTypeRsp)
end

function TSetTestTypeRsp.new(CompletionCode)
    return TSetTestTypeRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj ManufactureIpmiCmds.SetTestTypeRsp
function TSetTestTypeRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetTestTypeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetTestTypeRsp.group)
end

TSetTestTypeRsp.from_obj = TSetTestTypeRsp_from_obj

TSetTestTypeRsp.proto_property = {'CompletionCode'}

TSetTestTypeRsp.default = {0}

TSetTestTypeRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetTestTypeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetTestTypeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetTestTypeRsp.proto_property, errs, need_convert)
    return self
end

function TSetTestTypeRsp:unpack(_)
    return self.CompletionCode
end

SetTestType.SetTestTypeRsp = TSetTestTypeRsp

return SetTestType
