--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetTestCount = {}

---@class ManufactureIpmiCmds.SetTestCountReq
---@field FruId integer
---@field Tail string
local TSetTestCountReq = {}
TSetTestCountReq.__index = TSetTestCountReq
TSetTestCountReq.group = {}

local function TSetTestCountReq_from_obj(obj)
    return setmetatable(obj, TSetTestCountReq)
end

function TSetTestCountReq.new(FruId, Tail)
    return TSetTestCountReq_from_obj({FruId = FruId, Tail = Tail})
end
---@param obj ManufactureIpmiCmds.SetTestCountReq
function TSetTestCountReq:init_from_obj(obj)
    self.FruId = obj.FruId
    self.Tail = obj.Tail
end

function TSetTestCountReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetTestCountReq.group)
end

TSetTestCountReq.from_obj = TSetTestCountReq_from_obj

TSetTestCountReq.proto_property = {'FruId', 'Tail'}

TSetTestCountReq.default = {0, ''}

TSetTestCountReq.struct = {
    {name = 'FruId', is_array = false, struct = nil}, {name = 'Tail', is_array = false, struct = nil}
}

function TSetTestCountReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Tail', self.Tail, 'string', false, errs, need_convert)

    TSetTestCountReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetTestCountReq.proto_property, errs, need_convert)
    return self
end

function TSetTestCountReq:unpack(_)
    return self.FruId, self.Tail
end

SetTestCount.SetTestCountReq = TSetTestCountReq

---@class ManufactureIpmiCmds.SetTestCountRsp
---@field CompletionCode integer
local TSetTestCountRsp = {}
TSetTestCountRsp.__index = TSetTestCountRsp
TSetTestCountRsp.group = {}

local function TSetTestCountRsp_from_obj(obj)
    return setmetatable(obj, TSetTestCountRsp)
end

function TSetTestCountRsp.new(CompletionCode)
    return TSetTestCountRsp_from_obj({CompletionCode = CompletionCode})
end
---@param obj ManufactureIpmiCmds.SetTestCountRsp
function TSetTestCountRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
end

function TSetTestCountRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetTestCountRsp.group)
end

TSetTestCountRsp.from_obj = TSetTestCountRsp_from_obj

TSetTestCountRsp.proto_property = {'CompletionCode'}

TSetTestCountRsp.default = {0}

TSetTestCountRsp.struct = {{name = 'CompletionCode', is_array = false, struct = nil}}

function TSetTestCountRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)

    TSetTestCountRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetTestCountRsp.proto_property, errs, need_convert)
    return self
end

function TSetTestCountRsp:unpack(_)
    return self.CompletionCode
end

SetTestCount.SetTestCountRsp = TSetTestCountRsp

return SetTestCount
