--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SetDdrTestConfiguration = {}

---@class ManufactureIpmiCmds.SetDdrTestConfigurationReq
---@field ManufactureId integer
---@field Length integer
---@field Tail string
local TSetDdrTestConfigurationReq = {}
TSetDdrTestConfigurationReq.__index = TSetDdrTestConfigurationReq
TSetDdrTestConfigurationReq.group = {}

local function TSetDdrTestConfigurationReq_from_obj(obj)
    return setmetatable(obj, TSetDdrTestConfigurationReq)
end

function TSetDdrTestConfigurationReq.new(ManufactureId, Length, Tail)
    return TSetDdrTestConfigurationReq_from_obj({ManufactureId = ManufactureId, Length = Length, Tail = Tail})
end
---@param obj ManufactureIpmiCmds.SetDdrTestConfigurationReq
function TSetDdrTestConfigurationReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
    self.Length = obj.Length
    self.Tail = obj.Tail
end

function TSetDdrTestConfigurationReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDdrTestConfigurationReq.group)
end

TSetDdrTestConfigurationReq.from_obj = TSetDdrTestConfigurationReq_from_obj

TSetDdrTestConfigurationReq.proto_property = {'ManufactureId', 'Length', 'Tail'}

TSetDdrTestConfigurationReq.default = {0, 0, ''}

TSetDdrTestConfigurationReq.struct = {
    {name = 'ManufactureId', is_array = false, struct = nil}, {name = 'Length', is_array = false, struct = nil},
    {name = 'Tail', is_array = false, struct = nil}
}

function TSetDdrTestConfigurationReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Tail', self.Tail, 'string', false, errs, need_convert)

    TSetDdrTestConfigurationReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDdrTestConfigurationReq.proto_property, errs, need_convert)
    return self
end

function TSetDdrTestConfigurationReq:unpack(_)
    return self.ManufactureId, self.Length, self.Tail
end

SetDdrTestConfiguration.SetDdrTestConfigurationReq = TSetDdrTestConfigurationReq

---@class ManufactureIpmiCmds.SetDdrTestConfigurationRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Result integer
local TSetDdrTestConfigurationRsp = {}
TSetDdrTestConfigurationRsp.__index = TSetDdrTestConfigurationRsp
TSetDdrTestConfigurationRsp.group = {}

local function TSetDdrTestConfigurationRsp_from_obj(obj)
    return setmetatable(obj, TSetDdrTestConfigurationRsp)
end

function TSetDdrTestConfigurationRsp.new(CompletionCode, ManufactureId, Result)
    return TSetDdrTestConfigurationRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Result = Result
    })
end
---@param obj ManufactureIpmiCmds.SetDdrTestConfigurationRsp
function TSetDdrTestConfigurationRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Result = obj.Result
end

function TSetDdrTestConfigurationRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDdrTestConfigurationRsp.group)
end

TSetDdrTestConfigurationRsp.from_obj = TSetDdrTestConfigurationRsp_from_obj

TSetDdrTestConfigurationRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Result'}

TSetDdrTestConfigurationRsp.default = {0, 0, 0}

TSetDdrTestConfigurationRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Result', is_array = false, struct = nil}
}

function TSetDdrTestConfigurationRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Result', self.Result, 'uint8', false, errs, need_convert)

    TSetDdrTestConfigurationRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDdrTestConfigurationRsp.proto_property, errs, need_convert)
    return self
end

function TSetDdrTestConfigurationRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Result
end

SetDdrTestConfiguration.SetDdrTestConfigurationRsp = TSetDdrTestConfigurationRsp

return SetDdrTestConfiguration
