--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetTestCount = {}

---@class ManufactureIpmiCmds.GetTestCountReq
---@field FruId integer
---@field TestType integer
local TGetTestCountReq = {}
TGetTestCountReq.__index = TGetTestCountReq
TGetTestCountReq.group = {}

local function TGetTestCountReq_from_obj(obj)
    return setmetatable(obj, TGetTestCountReq)
end

function TGetTestCountReq.new(FruId, TestType)
    return TGetTestCountReq_from_obj({FruId = FruId, TestType = TestType})
end
---@param obj ManufactureIpmiCmds.GetTestCountReq
function TGetTestCountReq:init_from_obj(obj)
    self.FruId = obj.FruId
    self.TestType = obj.TestType
end

function TGetTestCountReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetTestCountReq.group)
end

TGetTestCountReq.from_obj = TGetTestCountReq_from_obj

TGetTestCountReq.proto_property = {'FruId', 'TestType'}

TGetTestCountReq.default = {0, 0}

TGetTestCountReq.struct = {
    {name = 'FruId', is_array = false, struct = nil}, {name = 'TestType', is_array = false, struct = nil}
}

function TGetTestCountReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FruId', self.FruId, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'TestType', self.TestType, 'uint8', false, errs, need_convert)

    TGetTestCountReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetTestCountReq.proto_property, errs, need_convert)
    return self
end

function TGetTestCountReq:unpack(_)
    return self.FruId, self.TestType
end

GetTestCount.GetTestCountReq = TGetTestCountReq

---@class ManufactureIpmiCmds.GetTestCountRsp
---@field CompletionCode integer
---@field Count integer
local TGetTestCountRsp = {}
TGetTestCountRsp.__index = TGetTestCountRsp
TGetTestCountRsp.group = {}

local function TGetTestCountRsp_from_obj(obj)
    return setmetatable(obj, TGetTestCountRsp)
end

function TGetTestCountRsp.new(CompletionCode, Count)
    return TGetTestCountRsp_from_obj({CompletionCode = CompletionCode, Count = Count})
end
---@param obj ManufactureIpmiCmds.GetTestCountRsp
function TGetTestCountRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.Count = obj.Count
end

function TGetTestCountRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetTestCountRsp.group)
end

TGetTestCountRsp.from_obj = TGetTestCountRsp_from_obj

TGetTestCountRsp.proto_property = {'CompletionCode', 'Count'}

TGetTestCountRsp.default = {0, 0}

TGetTestCountRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'Count', is_array = false, struct = nil}
}

function TGetTestCountRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Count', self.Count, 'uint8', false, errs, need_convert)

    TGetTestCountRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetTestCountRsp.proto_property, errs, need_convert)
    return self
end

function TGetTestCountRsp:unpack(_)
    return self.CompletionCode, self.Count
end

GetTestCount.GetTestCountRsp = TGetTestCountRsp

return GetTestCount
