--[[-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
]] --
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local GetDdrTestResult = {}

---@class ManufactureIpmiCmds.GetDdrTestResultReq
---@field ManufactureId integer
local TGetDdrTestResultReq = {}
TGetDdrTestResultReq.__index = TGetDdrTestResultReq
TGetDdrTestResultReq.group = {}

local function TGetDdrTestResultReq_from_obj(obj)
    return setmetatable(obj, TGetDdrTestResultReq)
end

function TGetDdrTestResultReq.new(ManufactureId)
    return TGetDdrTestResultReq_from_obj({ManufactureId = ManufactureId})
end
---@param obj ManufactureIpmiCmds.GetDdrTestResultReq
function TGetDdrTestResultReq:init_from_obj(obj)
    self.ManufactureId = obj.ManufactureId
end

function TGetDdrTestResultReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDdrTestResultReq.group)
end

TGetDdrTestResultReq.from_obj = TGetDdrTestResultReq_from_obj

TGetDdrTestResultReq.proto_property = {'ManufactureId'}

TGetDdrTestResultReq.default = {0}

TGetDdrTestResultReq.struct = {{name = 'ManufactureId', is_array = false, struct = nil}}

function TGetDdrTestResultReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)

    TGetDdrTestResultReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDdrTestResultReq.proto_property, errs, need_convert)
    return self
end

function TGetDdrTestResultReq:unpack(_)
    return self.ManufactureId
end

GetDdrTestResult.GetDdrTestResultReq = TGetDdrTestResultReq

---@class ManufactureIpmiCmds.GetDdrTestResultRsp
---@field CompletionCode integer
---@field ManufactureId integer
---@field Length integer
---@field Result integer
local TGetDdrTestResultRsp = {}
TGetDdrTestResultRsp.__index = TGetDdrTestResultRsp
TGetDdrTestResultRsp.group = {}

local function TGetDdrTestResultRsp_from_obj(obj)
    return setmetatable(obj, TGetDdrTestResultRsp)
end

function TGetDdrTestResultRsp.new(CompletionCode, ManufactureId, Length, Result)
    return TGetDdrTestResultRsp_from_obj({
        CompletionCode = CompletionCode,
        ManufactureId = ManufactureId,
        Length = Length,
        Result = Result
    })
end
---@param obj ManufactureIpmiCmds.GetDdrTestResultRsp
function TGetDdrTestResultRsp:init_from_obj(obj)
    self.CompletionCode = obj.CompletionCode
    self.ManufactureId = obj.ManufactureId
    self.Length = obj.Length
    self.Result = obj.Result
end

function TGetDdrTestResultRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetDdrTestResultRsp.group)
end

TGetDdrTestResultRsp.from_obj = TGetDdrTestResultRsp_from_obj

TGetDdrTestResultRsp.proto_property = {'CompletionCode', 'ManufactureId', 'Length', 'Result'}

TGetDdrTestResultRsp.default = {0, 0, 0, 0}

TGetDdrTestResultRsp.struct = {
    {name = 'CompletionCode', is_array = false, struct = nil}, {name = 'ManufactureId', is_array = false, struct = nil},
    {name = 'Length', is_array = false, struct = nil}, {name = 'Result', is_array = false, struct = nil}
}

function TGetDdrTestResultRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CompletionCode', self.CompletionCode, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'ManufactureId', self.ManufactureId, 'uint32', false, errs, need_convert)
    validate.Optional(prefix .. 'Length', self.Length, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'Result', self.Result, 'uint32', false, errs, need_convert)

    TGetDdrTestResultRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetDdrTestResultRsp.proto_property, errs, need_convert)
    return self
end

function TGetDdrTestResultRsp:unpack(_)
    return self.CompletionCode, self.ManufactureId, self.Length, self.Result
end

GetDdrTestResult.GetDdrTestResultRsp = TGetDdrTestResultRsp

return GetDdrTestResult
