*openUBMC 一体化集成开发环境Docker镜像构建-功能详细设计说明书*

<table>
    <tr>
        <td>所属SIG组:</td>
        <td>CICD</td>
    </tr>
    <tr>
        <td>落入版本:</td>
        <td>25.12</td>
    </tr>
    <tr>
        <td>设计人员:</td>
        <td>李睿宸</td>
    </tr>
    <tr>
        <td>日期:</td>
        <td>2025.11.24</td>
    </tr>
</table>

**Copyright © 2025 openUBMC Community**

您对&quot;本文档&quot;的复制，使用，修改及分发受木兰宽松许可证, 第2版协议(以下简称&quot;MulanPSL2&quot;)的约束。
为了方便用户理解，您可以通过访问<https://license.coscl.org.cn/MulanPSL2>了解MulanPSL2的概要 (但不是替代)。
MulanPSL2的完整协议内容您可以访问如下网址获取：<https://license.coscl.org.cn/MulanPSL2>。

**改版记录**

<table>
    <tr>
        <th>日期</th>
        <th>修订版本</th>
        <th>修订描述</th>
        <th>作者</th>
        <th>审核</th>
    </tr>
</table>

**List of abbreviations**  **缩略语清单** ：

<table>
    <tr>
        <th>Abbreviations 缩略语</th>
        <th>Full spelling 英文全名</th>
        <th>Chinese explanation 中文解释</th>
    </tr>
</table>

[TOC]

# 1.功能分析
## 1.1 功能背景

当前manifest中的dockerfile构建镜像需要传入社区conan中心仓的用户名和密码，容器使用者可以通过docker history命令查看docker镜像制作者传入的用户配置数据

为了避免镜像中带有敏感用户账户信息导致存在安全风险，需要修改镜像构建方式，以更安全的方式完成镜像的构建，同时确保必要的开发软件依赖、bmc_sdk、BMC Studio、Qemu工具集成在镜像中，可以开箱即用

## 1.2 功能描述

通过docker构建的secret挂载机制传入用户配置信息，并在完成镜像构建之后清除镜像中的conan用户配置和缓存，确保环境不带有任何用户配置数据，确保镜像可分发

## 1.3 功能场景

- 社区用户基于dockerfile构建docker镜像进行分发
- 社区基于dockerfile构建版本开发镜像

## 1.4 功能列表

| 功能编号 | 功能标题 | 功能描述 |
| ------- | ------- | -------- |
| 1 | 一体化集成开发环境Docker镜像构建 | 完善基于dockerfile的构建机制，确保社区用户可以基于文档构建出一个集成开发工具和必要数据的开发镜像 |


# 2.功能设计
## 2.1 总体方案分析

- 使用docker镜像构建的`--mount=type=secret,id=`机制，将敏感信息作为一个临时文件挂载进镜像，使用完成后取消挂载，将conan配置临时传入环境
- 完成镜像初始化后清除conan相关配置数据，确保不留存敏感用户配置
- 由于设计临时文件生成和挂载，提供简化配置的脚本，实现镜像的一步构建
- 完善README中的镜像构建与使用文档

### 2.1.1 方案详细设计
#### 2.1.1.1 方案概述

**基于secret的用户配置传入**

实现原理
传统方式（ENV/ARG）：环境变量会持久化在镜像配置中，任何人通过 docker history 或 docker inspect 都能看到明文密码。

Secret 方式：

宿主机端：构建命令指定一个本地文件作为 Secret 源。

容器构建端：Docker 仅在执行某条 RUN 指令的瞬间，将该文件挂载到容器内的 /run/secrets/ 目录下（通常是内存文件系统）。

构建结束：指令执行完毕后，挂载点立即消失，不会被提交（Commit）到镜像层中。

**敏感配置清除**
即使使用了 Secret 传入密码，工具（如 Conan）在运行 init.py 时，通常会将凭据缓存在本地目录（如 ~/.conan/）以供后续使用。如果不在同一个构建层内清理，这些缓存文件仍会被打包进镜像。

实现策略：单层原子操作
Docker 的每一条 RUN 指令都会生成一个新的镜像层。如果你在下一条 RUN 中执行 rm，虽然文件不可见了，但它实际上仍然存在于上一层的 OverlayFS 中，既占空间又有泄露风险。

必须在同一条 RUN 指令中完成“读取 -> 使用 -> 清理”的全过程。

**脚本实现一步构建**

由于 BuildKit 的命令参数（--mount, --secret, --build-context）非常冗长且容易出错，且涉及到临时文件的生命周期管理，提供一个 Python 脚本是最佳实践。

将 SDK 所在的文件夹作为一个外部上下文 "sdk" 传入
"--build-context", f"sdk={sdk_file.parent}",
配合 Dockerfile 中的：
--mount=type=bind,from=sdk,source=${SDK_ARCHIVE},target=/tmp/bmc_sdk.zip,ro
这使得 SDK 不需要 COPY 进镜像，仅仅是挂载进去读取一下。构建完成后，镜像里没有 SDK 安装包，只有安装后的产物。


#### 2.1.1.2 开发视图

不涉及

#### 2.1.1.3 运行视图

前后方案流程图对比：


![](./images/旧docker方案.png)



![](./images/新docker方案.png)


### 2.1.2 内部依赖分析

不涉及

### 2.1.3 外部依赖分析

不涉及

### 2.1.4 北向接口分析

不涉及

### 2.1.5 兼容性分析

不涉及

### 2.1.6 定制化接口分析

不涉及

### 2.1.7 导入导出分析

不涉及

### 2.1.8 传感器分析

不涉及

### 2.1.9 精准告警事件分析

不涉及

### 2.1.10 系统锁定分析
不涉及

### 2.1.11 用例场景分析

| 场景 |  期望结果 |
| ---- |  --- |
| 用户构建镜像  | 传入必要配置后，镜像构建成功，其中不带有敏感配置信息 |
| 用户使用镜像 | 完成conan配置后，manifest可以构建出产品，BMC Studio，Qemu内置进镜像 |


# 3.功能实现

## 3.1【1】一体化集成开发环境Docker镜像构建
### 3.1.1 功能实现设计

实现设计见总体方案设计部分

### 3.1.2 功能详细设计

代码实现逻辑，相关实现细节见总体方案设计部分

### 3.1.3 开发者测试
功能覆盖验证，不涉及DT。

#### 3.1.3.1 单元测试
不涉及

#### 3.1.3.2 集成测试
不涉及