#!/usr/bin/env python
# coding:utf-8
# Copyright (c) 2024 Huawei Technologies Co., Ltd.
# openUBMC is licensed under Mulan PSL v2.
# You can use this software according to the terms and conditions of the Mulan PSL v2.
# You may obtain a copy of Mulan PSL v2 at:
#         http://license.coscl.org.cn/MulanPSL2
# THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
# EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
# MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
# See the Mulan PSL v2 for more details.

"""
文件名：prototype.py
功能：默认裁剪脚本
"""
import os
import sys
import json
import stat
import logging

cwd = os.path.join(os.getcwd(), os.path.dirname(__file__))
sys.path.append(f"{cwd}/../")
sys.path.append(f"{cwd}/../../")
sys.path.append(f"{cwd}/../../../")
from customization.default import BaseCustomization


log = logging.getLogger(__name__)


subsys_startup_components = [
    # bmc_core components
    'firmware_mgmt',
    'bmc_upgrade',
    'bmc_time',
    'fructrl',
    'bmc_network',
    'bmc_health',
    'ipmi_core',
    'bmc_soc',
    # alarm components
    'sensor',
    'host_agent',
    'frudata',
    'event',
    # framework components
    'libsoc_adapter',
    'hwproxy',
    'hwdiscovery',
    'soctrl',
    'maca',
    "key_mgmt",
    "persistence",
    # hardware components
    'manufacture',
    'bios',
    'general_hardware',
    'thermal_mgmt',
    'power_mgmt',
    'pcie_device',
    'chassis',
    'network_adapter',
    'storage',
    'compute',
    'mctpd',
    # interface components
    'redfish',
    'web_backend',
    # om_priv components
    'nsm',
    'oms',
    # om components
    'ddns',
    'remote_console',
    'event_policy',
    'usb_entry',
    'product_mgmt',
    'rmcpd',
    # security components
    'iam',
    'certificate',
    'spdm',
    'dcmid',
    'vnc_proxy'
]


class Customization(BaseCustomization):
    def cutout_subsys_startup_comps(self, rootfs_path):
        """
        对于需要合并到子系统拉起的组件，需要对组件自带的systemd配置文件进行裁剪，否则可能出现组件被多次拉起的问题，
        在subsys_startup_components中添加组件名即可完成对组件自带的systemd配置文件的裁剪
        """
        for component in subsys_startup_components:
            path = f"{rootfs_path}/etc/systemd/system/{component}.service"
            self.work.run_command(f"rm -rf {path}", sudo=True)
            multi_user_path = f"{rootfs_path}/etc/systemd/system/multi-user.target.wants/{component}.service"
            self.work.run_command(f"rm -rf {multi_user_path}", sudo=True)
        self.work.run_command(f"rm -rf {rootfs_path}/opt/bmc/apps/mdb_mgmt", sudo=True)

    def rootfs_cust(self, rootfs_path):
        log.info("---->>> Start run prototype customization configure, path:{} <<<----".format(rootfs_path))
        os.chdir(rootfs_path)
        self.cutout_subsys_startup_comps(rootfs_path)

    def datafs_cust(self, rootfs_path):
        pass

    def rootfs_debug_cust(self, rootfs_path):
        pass

    def rootfs_release_cust(self, rootfs_path):
        log.info("---->>> 开始裁剪mdbctl <<<----")
        self.work.run_command(f"rm -rf {rootfs_path}/opt/bmc/apps/mdbctl/lualib/command/debug", sudo=True)
        pass

    def rootfs_common(self, rootfs_path):
        pass
