# manifest

此代码仓为openUBMC产品集成配置仓。

## 开发环境创建

openUBMC目前仅支持在Ubuntu 24.04系统上进行代码开发。为方便开发者快速搭建环境，我们提供以下三种方式：

方法一：本地环境初始化脚本（适用于Ubuntu 24.04系统）

方法二：使用官方发布的Docker镜像创建Docker容器

方法三：从源码构建Docker容器（通过提供的Dockerfile源码文件创建开发环境）

以上三种方式均可配置完整的openUBMC开发环境。

- 如果您的系统已经是Ubuntu 24.04，可以直接运行本地脚本初始化环境。

- 如果希望使用容器化开发，可以选择方法二或方法三的Docker方式。方法二中的Docker环境是已经发布的稳定版本，仅包含openUBMC的开发环境；方法三中的Docker环境是在研的最新版本，包含openUBMC的开发环境，Qemu以及Studio的编译和运行的依赖等。

请根据实际需求选择适合的方案。

### 方法一：本地环境初始化

> [NOTE]
> 此方法仅支持在Ubuntu 24.04系统中使用！
> 环境初始化脚本优先使用本地环境配置的apt源，下载bingo工具。若本地环境未配置，则会自动配置openUBMC官方的apt源。

此代码仓根目录下的init.py脚本是openUBMC开发环境初始化的代码实现。开发者可将此代码仓拉取到本地，前往[openUBMC社区软件应用中心](https://www.openubmc.cn/marketplace)下载社区组件bmcsdk。并将下载的bmcsdk压缩包路径作为参数传入，执行此脚本进行开发环境初始化。

```
cd manifest
python3 init.py -path <bmc_sdk.zip文件路径> -user <openUBMC社区用户名> -psw <openUBMC社区用户密码>
```

> [NOTE]
> 未指定 `-psw` 和 `-user` 参数时需要用户通过交互式输入账号密码。 **推荐**

### 方法二：官方发布的Docker镜像创建openUBMC开发环境

此方式的实现请参考[官方文档-Docker开发环境搭建章节](https://www.openubmc.cn/docs/zh/development/quick_start/prepare_environment/docker_env.html)

### 方法三：dockerfile源码制作openUBMC开发环境

> [NOTE]
> dockerfile制作镜像过程中，默认配置openUBMC官方提供的apt源并完成bingo下载。如需使用您自己的apt源，可修改 init.py --> install_bingo()方法中的apt源配置。

在本仓中提供dockerfile文件，该文件包含了构建openUBMC环境镜像的所有指令。

1、开发者需前往[openUBMC社区软件应用中心](https://openubmc.cn/marketplace)下载社区组件bmcsdk，并记录其本地路径（可放在任意位置）。在manifest目录下，通过提供的`build_image.py`脚本构建镜像，并以参数形式传入SDK路径与openUBMC社区账号信息：

```
cd manifest
python3 build_image.py \
    -s <bmc_sdk.zip文件路径，可为相对或绝对路径> \
    -u <openUBMC社区用户名> \
    -p <openUBMC社区用户密码> \
    -t openubmc/xx.yy
```

> [NOTE]
> `build_image.py` 使用 BuildKit secret 功能在构建期挂载SDK与凭据，整个过程不会把账号密码写入 Dockerfile、镜像层。若环境中Docker版本为20.09及以下，使用secret机制需要设置 `DOCKER_BUILDKIT=1`，脚本中会自动进行该变量的配置。

参数说明：

`-t` 定义镜像名称

2、构建成功后，可查看镜像是否加载成功：

```
docker images
```


3、创建上述生成的`openubmc/xx.yy`镜像的Container实例，并将Container实例命名为`openubmc`：
```
docker run \
    -p <BMC Studio服务端口>:10000 \
    -p <qemu ssh对外服务端口>:<qemu ssh服务端口> \
    ...
    -d --mount type=bind,source=/root/workspace,target=/home/workspace \
    --restart=always --name openubmc openubmc/xx.yy
```

参数说明：

`-p` 配置容器的端口映射，请按需配置，BMC Studio默认端口号为10000；qemu的ssh服务默认为10022，telnet端口号默认10023，https服务端口号默认10443，ipmi服务端口号默认10623

`-d` 以非交互方式启动容器。

`--mount` 将上述在宿主机创建的工作文件夹`/root/workspace`与Container中的`/home/workspace`链接作为同步文件夹。

`--restart=always` 系统重启时自动启动容器。

`--name` 定义容器的名称。

4、查看正在运行的容器：

```
docker ps
```

5、进入`openubmc`容器：

```
docker exec -it openubmc /bin/bash
```

执行成功，此时已进入`openubmc`容器。

## git仓库配置

上述步骤已经在环境中成功配置openUBMC开发所需要的工具和依赖。接下来开发者需在本地完成Git的全局配置，并将本地SSH公钥配置至gitcode仓库的ssh密钥中，即可开始代码开发、上库、和本地构建等工作。以下第二至第四步骤可参考[GitCode的SSH配置](https://docs.gitcode.com/v1-docs/docs/users/ssh-key/)。

1、首先开发者需要在本地完成Git的全局配置：

```
git config --global user.name <你的用户名>
git config --global user.email <你的邮箱>
```
2、在本地执行以下命令生成RSA密钥：
```
ssh-keygen -t rsa -b 2048 -C <你的邮箱>
```
3、查看 RSA 公钥：

```
cat ~/.ssh/id_rsa.pub
```
4、上述步骤会在本地的控制台中返回RSA密钥，开发者需要将此密钥添加到gitcode的SSH公钥中。

之后，开发者便可以在容器中克隆git仓库中的代码，并在容器中进行代码开发和构建。

# Qemu启动
openUBMC还提供了一套Qemu仿真环境，便于开发者验证openUBMC的制品包。开发者通过执行以下命令可以一键式启动Qemu仿真环境，在其中体验openUBMC。

```shell
python3 build/works/packet/qemu_shells/vemake_1711.py
```
当出现如下回显时，Qemu环境就正式启动了
```shell
Uncompressing... done, booting...
[    0.000000] Booting Linux on physical CPU 0x0000000000 [0x412fd050]
[    0.000000] Linux version 5.10.0 (oe-user@oe-host) (aarch64-euler-linux-gcc (BiSheng Embedded CPU 302.1.0.B016) 7.3.0, GNU ld (BiSheng Embedded CPU 302.1.0.B016) 2.41) #1 SMP PREEMPT Tue Nov 26 22:03:48 CST 2024
```

当然你也可以通过配置`build/works/packet/qemu_shells/config.json`文件来决定启动Qemu的方式,同时也可以参考`build/works/packet/qemu_shells/schema.json`来获取对应配置详情。

# 可视化后端一键部署
openUBMC镜像提供了可观测特性（observability）需要使用到的所有可视化后端，开发者可通过安装脚本一键部署所有可视化后端，节省安装可视化后端的时间。

## 可观测特性介绍
可观测特性的基本概念请查阅[可观测技术](https://www.openubmc.cn/docs/zh/development/design_reference/key_feature/observability.html)进行了解
可观测特性使用指南请查阅[可观测特性使用指南](https://www.openubmc.cn/docs/zh/development/design_reference/key_feature/observability_user_guide.html)进行了解，其中详细介绍了bmc可观测页面的配置方法与镜像中集成的可视化后端使用方法

## 部署方法
部署可视化后端大致分为三个步骤：
- 1、由于可观测功能必须使用TLS传输，且镜像中不提供预置的证书，因此需要开发者自行提供TLS认证的证书；
- 2、容器生成命令在创建上述生成的`openubmc/xx.yy`镜像的Container实例命令的基础上，还需要额外添加用于可视化后端通信的端口绑定及文件夹挂载操作，避免出现端口无法访问、bmc与可视化后端通信失败等问题；
- 3、进入容器后需要执行部署脚本，脚本执行成功即完成部署

### 1.准备证书
证书制作方法可以参考社区wiki[可观测环境搭建](https://discuss.openubmc.cn/t/topic/2118)中`2.2 准备证书/密钥文件`章节进行
证书制作之后，务必将SSL证书和SSL密钥文件的名字命名为如下名称：
- 1、SSL证书必须命名为`observability.otelcol.crt`
- 2、SSL密钥必须命名为`observability.otelcol.key.pem`

证书制作完成后，CA证书必须上传至BMC，SSL证书与SSL密钥必须放在本地同一个目录下，便于后续启动docker容器时进行挂载使用

### 2.生成容器
开发者需要访问可视化后端时，运行镜像命令须如下执行，否则会出现端口无法访问、bmc与可视化后端通信失败等问题，在创建上述生成的`openubmc/xx.yy`镜像的Container实例命令的基础上，还需要额外添加用于可视化后端通信的端口绑定及文件夹挂载
```
docker run \
    -p <BMC Studio服务端口>:10000 \
    -p <qemu ssh对外服务端口>:<qemu ssh服务端口> \
    -p <zipkin对外服务端口>:9411/tcp \
    -p <otelcol对外服务端口>:4318/tcp \
    -p <prometheus对外服务端口>:49092/tcp \
    -p <grafana对外服务端口>:3000/tcp \
    ...
    -d --mount type=bind,source=/root/workspace,target=/home/workspace \
    --mount type=bind,source=<证书存放路径>,target=/root/workspace/observability/collector-contrib/cert \
    --restart=always --name openubmc openubmc/xx.yy
```
下述四个端口为可视化后端正常运行必须使用的端口，务必进行配置
- `9411`端口为zipkin默认端口，`zipkin对外服务端口`建议设置为`9411`或者其他端口
- `4318`端口为otelcol默认端口，`otelcol对外服务端口`建议设置为`4318`或者其它端口
- `49092`端口为prometheus默认端口，`prometheus对外服务端口`建议设置为`49092`或者其他端口
- `3000`端口为grafana默认端口，`grafana对外服务端口`建议设置为`3000`或者其他端口

`证书存放路径`为可视化后端需要使用的证书和密钥，请将第一步准备证书中的SSL证书与SSL密钥存放路径进行替换，`/root/workspace/observability/collector-contrib/cert`为镜像中otelcol读取证书文件的路径，不要进行更改

### 3.执行部署脚本
进入容器后执行以下步骤：
- 1、执行`su root`切换为root用户
- 2、执行`cd /root/workspace/observability`进入可视化后端集成的目录
- 3、执行`bash observability.sh start`启动可视化后端
- 4、一般来说执行完成第三步之后，直接执行第五步即可，但如果没有看到回显`Password for the [elastic] user successfully reset.`的话，说明Elasticsearch密码重置失败，需要再次执行`expect /root/workspace/observability/reset_elastic_password.exp`重置Elasticsearch密码为预置密码
- 5、执行完成上述步骤后访问grafana对外服务端口（如127.0.0.1:3000）访问grafana终端，首次登陆grafana需要使用`用户名为admin、密码为admin`进行登录
- 6、此外还可以直接访问zipkin对外服务端口（如127.0.0.1:9411）访问zipkin终端来查询跟踪数据；直接访问prometheus对外服务端口（如127.0.0.1:49092）访问prometheus终端来查询度量数据
