-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local class = require 'mc.class'
local skynet = require 'skynet'
local component = class()

function component:ctor()
    self.mock_fault = false
end

local RTL_MAX_RETRY_TIMES<const> = 3
function component:healthy_check()
    if self.mock_fault then
        return false
    end
    for _ = 1, RTL_MAX_RETRY_TIMES do
        local ok, res = pcall(self.is_health, self)
        if ok and res then
            return true
        end
        skynet.sleep(50)
    end
end

function component:is_health()
    return true
end

return component
