-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local class = require 'mc.class'
local event_util = require 'infrastructure.event'
local defs = require 'domain.defs'
local mc_utils = require 'mc.utils'
local json = require 'cjson'
local skynet = require 'skynet'
local log = require 'mc.logging'
local Alarm = class()

function Alarm:ctor()
end

local AlarmMsgs = {
    [defs.ALARM_TYPE.PHY_ERR] = {
        ComponentName = '',
        State = '',
        EventKeyId = 'LSW.PHYMDIOErr',
        MessageArgs = '',
        SystemId = '',
        ManagerId = '1',
        ChassisId = '',
        NodeId = '',
        SubjectType = '93'
    },
    [defs.ALARM_TYPE.CHIP_ERR] = {
        ComponentName = '',
        State = '',
        EventKeyId = 'LSW.LswChipFault',
        MessageArgs = '',
        SystemId = '',
        ManagerId = '1',
        ChassisId = '',
        NodeId = '',
        SubjectType = '93'
    },
    [defs.ALARM_TYPE.PHY_POWER_OFF] = {
        ComponentName = '',
        State = '',
        EventKeyId = 'PHY.PHYPowerOff',
        MessageArgs = '',
        SystemId = '',
        ManagerId = '1',
        ChassisId = '',
        NodeId = '',
        SubjectType = '93'
    },
    [defs.ALARM_TYPE.LSW_POWER_OFF] = {
        ComponentName = '',
        State = '',
        EventKeyId = 'LSW.LSWPowerOff',
        MessageArgs = '',
        SystemId = '',
        ManagerId = '1',
        ChassisId = '',
        NodeId = '',
        SubjectType = '93'
    },
    [defs.ALARM_TYPE.LSW_RECOVERY] = {
        ComponentName = '',
        State = '',
        EventKeyId = 'LSW.LSWNetRecovery',
        MessageArgs = '',
        SystemId = '',
        ManagerId = '1',
        ChassisId = '',
        NodeId = '',
        SubjectType = '93'
    }
}

function Alarm:get_msg_args(alarm_type, arg)
    local msg_args = {}
    if alarm_type == defs.ALARM_TYPE.CHIP_ERR then
        table.insert(msg_args, defs.LSW_POS.MAIN_BOARD)
    end

    table.insert(msg_args, tostring(arg))
    return json.encode(msg_args)
end

function Alarm:generate_event(event, alarm_type)
    local ok, err = pcall(event_util.generate_event, event)
    if ok then
        log:notice('[lsw]add event: alarm_type(%s) event_type(%s) success', alarm_type, event.State)
    else
        log:error('[lsw]add event: alarm_type(%s) event_type(%s) fail(err:%s)', alarm_type, event.State, err)
    end
end

function Alarm:event(alarm_type, arg, slot, state)
    local event = mc_utils.table_copy(AlarmMsgs[alarm_type])
    if not event then
        log:error("[lsw] Alarm message format error, alarm type: %s", alarm_type)
        return
    end
    event.MessageArgs = self:get_msg_args(alarm_type, arg)
    event.State = tostring(state)
    event.ComponentName = string.format('ExpBoard%x', slot)
    skynet.fork_once(function()
        self:generate_event(event, alarm_type)
    end)
end

return Alarm