-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local EthConfig = {}

---@class EthConfig.SetSpeedRsp
local TSetSpeedRsp = {}
TSetSpeedRsp.__index = TSetSpeedRsp
TSetSpeedRsp.group = {}

local function TSetSpeedRsp_from_obj(obj)
    return setmetatable(obj, TSetSpeedRsp)
end

function TSetSpeedRsp.new()
    return TSetSpeedRsp_from_obj({})
end
---@param obj EthConfig.SetSpeedRsp
function TSetSpeedRsp:init_from_obj(obj)

end

function TSetSpeedRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSpeedRsp.group)
end

TSetSpeedRsp.from_obj = TSetSpeedRsp_from_obj

TSetSpeedRsp.proto_property = {}

TSetSpeedRsp.default = {}

TSetSpeedRsp.struct = {}

function TSetSpeedRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetSpeedRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSpeedRsp.proto_property, errs, need_convert)
    return self
end

function TSetSpeedRsp:unpack(_)
end

EthConfig.SetSpeedRsp = TSetSpeedRsp

---@class EthConfig.SetSpeedReq
---@field EthName string
---@field SpeedDuplexEnable boolean
---@field SpeedSetting integer
---@field DuplexSetting integer
local TSetSpeedReq = {}
TSetSpeedReq.__index = TSetSpeedReq
TSetSpeedReq.group = {}

local function TSetSpeedReq_from_obj(obj)
    return setmetatable(obj, TSetSpeedReq)
end

function TSetSpeedReq.new(EthName, SpeedDuplexEnable, SpeedSetting, DuplexSetting)
    return TSetSpeedReq_from_obj({
        EthName = EthName,
        SpeedDuplexEnable = SpeedDuplexEnable,
        SpeedSetting = SpeedSetting,
        DuplexSetting = DuplexSetting
    })
end
---@param obj EthConfig.SetSpeedReq
function TSetSpeedReq:init_from_obj(obj)
    self.EthName = obj.EthName
    self.SpeedDuplexEnable = obj.SpeedDuplexEnable
    self.SpeedSetting = obj.SpeedSetting
    self.DuplexSetting = obj.DuplexSetting
end

function TSetSpeedReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSpeedReq.group)
end

TSetSpeedReq.from_obj = TSetSpeedReq_from_obj

TSetSpeedReq.proto_property = {'EthName', 'SpeedDuplexEnable', 'SpeedSetting', 'DuplexSetting'}

TSetSpeedReq.default = {'', false, 0, 0}

TSetSpeedReq.struct = {
    {name = 'EthName', is_array = false, struct = nil}, {name = 'SpeedDuplexEnable', is_array = false, struct = nil},
    {name = 'SpeedSetting', is_array = false, struct = nil}, {name = 'DuplexSetting', is_array = false, struct = nil}
}

function TSetSpeedReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'EthName', self.EthName, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'SpeedDuplexEnable', self.SpeedDuplexEnable, 'bool', false, errs, need_convert)
    validate.Optional(prefix .. 'SpeedSetting', self.SpeedSetting, 'uint8', false, errs, need_convert)
    validate.Optional(prefix .. 'DuplexSetting', self.DuplexSetting, 'uint8', false, errs, need_convert)

    TSetSpeedReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSpeedReq.proto_property, errs, need_convert)
    return self
end

function TSetSpeedReq:unpack(_)
    return self.EthName, self.SpeedDuplexEnable, self.SpeedSetting, self.DuplexSetting
end

EthConfig.SetSpeedReq = TSetSpeedReq

EthConfig.interface = mdb.register_interface('bmc.kepler.Managers.EthernetInterfaces.EthConfig', {},
    {SetSpeed = {'a{ss}sbyy', '', TSetSpeedReq, TSetSpeedRsp}}, {})

return EthConfig
