-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MSmmMsg = {}

---@class MSmmMsg.ExternalVlanId
---@field ExternalVlanId integer
local TExternalVlanId = {}
TExternalVlanId.__index = TExternalVlanId
TExternalVlanId.group = {}

local function TExternalVlanId_from_obj(obj)
    return setmetatable(obj, TExternalVlanId)
end

function TExternalVlanId.new(ExternalVlanId)
    return TExternalVlanId_from_obj({ExternalVlanId = ExternalVlanId or 0})
end
---@param obj MSmmMsg.ExternalVlanId
function TExternalVlanId:init_from_obj(obj)
    self.ExternalVlanId = obj.ExternalVlanId or 0
end

function TExternalVlanId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExternalVlanId.group)
end

TExternalVlanId.from_obj = TExternalVlanId_from_obj

TExternalVlanId.proto_property = {'ExternalVlanId'}

TExternalVlanId.default = {0}

TExternalVlanId.struct = {{name = 'ExternalVlanId', is_array = false, struct = nil}}

function TExternalVlanId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'ExternalVlanId', self.ExternalVlanId, 'uint32', false, errs, need_convert)

    TExternalVlanId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExternalVlanId.proto_property, errs, need_convert)
    return self
end

function TExternalVlanId:unpack(_)
    return self.ExternalVlanId
end

MSmmMsg.ExternalVlanId = TExternalVlanId

---@class MSmmMsg.SMMLinkPath
---@field SMMLinkPath integer
local TSMMLinkPath = {}
TSMMLinkPath.__index = TSMMLinkPath
TSMMLinkPath.group = {}

local function TSMMLinkPath_from_obj(obj)
    return setmetatable(obj, TSMMLinkPath)
end

function TSMMLinkPath.new(SMMLinkPath)
    return TSMMLinkPath_from_obj({SMMLinkPath = SMMLinkPath or 0})
end
---@param obj MSmmMsg.SMMLinkPath
function TSMMLinkPath:init_from_obj(obj)
    self.SMMLinkPath = obj.SMMLinkPath or 0
end

function TSMMLinkPath:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSMMLinkPath.group)
end

TSMMLinkPath.from_obj = TSMMLinkPath_from_obj

TSMMLinkPath.proto_property = {'SMMLinkPath'}

TSMMLinkPath.default = {0}

TSMMLinkPath.struct = {{name = 'SMMLinkPath', is_array = false, struct = nil}}

function TSMMLinkPath:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'SMMLinkPath', self.SMMLinkPath, 'uint8', false, errs, need_convert)

    TSMMLinkPath:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSMMLinkPath.proto_property, errs, need_convert)
    return self
end

function TSMMLinkPath:unpack(_)
    return self.SMMLinkPath
end

MSmmMsg.SMMLinkPath = TSMMLinkPath

---@class MSmmMsg.Unit
---@field Unit integer
local TUnit = {}
TUnit.__index = TUnit
TUnit.group = {}

local function TUnit_from_obj(obj)
    return setmetatable(obj, TUnit)
end

function TUnit.new(Unit)
    return TUnit_from_obj({Unit = Unit})
end
---@param obj MSmmMsg.Unit
function TUnit:init_from_obj(obj)
    self.Unit = obj.Unit
end

function TUnit:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUnit.group)
end

TUnit.from_obj = TUnit_from_obj

TUnit.proto_property = {'Unit'}

TUnit.default = {0}

TUnit.struct = {{name = 'Unit', is_array = false, struct = nil}}

function TUnit:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Required(prefix .. 'Unit', self.Unit, 'uint32', false, errs, need_convert)

    TUnit:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUnit.proto_property, errs, need_convert)
    return self
end

function TUnit:unpack(_)
    return self.Unit
end

MSmmMsg.Unit = TUnit

return MSmmMsg
