-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local MLswPortInfo = {}

---@class MLswPortInfo.StpState
---@field StpState integer
local TStpState = {}
TStpState.__index = TStpState
TStpState.group = {}

local function TStpState_from_obj(obj)
    return setmetatable(obj, TStpState)
end

function TStpState.new(StpState)
    return TStpState_from_obj({StpState = StpState})
end
---@param obj MLswPortInfo.StpState
function TStpState:init_from_obj(obj)
    self.StpState = obj.StpState
end

function TStpState:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStpState.group)
end

TStpState.from_obj = TStpState_from_obj

TStpState.proto_property = {'StpState'}

TStpState.default = {0}

TStpState.struct = {{name = 'StpState', is_array = false, struct = nil}}

function TStpState:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'StpState', self.StpState, 'uint32', false, errs, need_convert)

    TStpState:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStpState.proto_property, errs, need_convert)
    return self
end

function TStpState:unpack(_)
    return self.StpState
end

MLswPortInfo.StpState = TStpState

---@class MLswPortInfo.AutoNego
---@field AutoNego integer
local TAutoNego = {}
TAutoNego.__index = TAutoNego
TAutoNego.group = {}

local function TAutoNego_from_obj(obj)
    return setmetatable(obj, TAutoNego)
end

function TAutoNego.new(AutoNego)
    return TAutoNego_from_obj({AutoNego = AutoNego})
end
---@param obj MLswPortInfo.AutoNego
function TAutoNego:init_from_obj(obj)
    self.AutoNego = obj.AutoNego
end

function TAutoNego:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAutoNego.group)
end

TAutoNego.from_obj = TAutoNego_from_obj

TAutoNego.proto_property = {'AutoNego'}

TAutoNego.default = {0}

TAutoNego.struct = {{name = 'AutoNego', is_array = false, struct = nil}}

function TAutoNego:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AutoNego', self.AutoNego, 'uint32', false, errs, need_convert)

    TAutoNego:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAutoNego.proto_property, errs, need_convert)
    return self
end

function TAutoNego:unpack(_)
    return self.AutoNego
end

MLswPortInfo.AutoNego = TAutoNego

---@class MLswPortInfo.PortError
---@field PortError integer
local TPortError = {}
TPortError.__index = TPortError
TPortError.group = {}

local function TPortError_from_obj(obj)
    return setmetatable(obj, TPortError)
end

function TPortError.new(PortError)
    return TPortError_from_obj({PortError = PortError})
end
---@param obj MLswPortInfo.PortError
function TPortError:init_from_obj(obj)
    self.PortError = obj.PortError
end

function TPortError:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPortError.group)
end

TPortError.from_obj = TPortError_from_obj

TPortError.proto_property = {'PortError'}

TPortError.default = {0}

TPortError.struct = {{name = 'PortError', is_array = false, struct = nil}}

function TPortError:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PortError', self.PortError, 'uint32', false, errs, need_convert)

    TPortError:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPortError.proto_property, errs, need_convert)
    return self
end

function TPortError:unpack(_)
    return self.PortError
end

MLswPortInfo.PortError = TPortError

---@class MLswPortInfo.Duplex
---@field Duplex integer
local TDuplex = {}
TDuplex.__index = TDuplex
TDuplex.group = {}

local function TDuplex_from_obj(obj)
    return setmetatable(obj, TDuplex)
end

function TDuplex.new(Duplex)
    return TDuplex_from_obj({Duplex = Duplex})
end
---@param obj MLswPortInfo.Duplex
function TDuplex:init_from_obj(obj)
    self.Duplex = obj.Duplex
end

function TDuplex:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TDuplex.group)
end

TDuplex.from_obj = TDuplex_from_obj

TDuplex.proto_property = {'Duplex'}

TDuplex.default = {0}

TDuplex.struct = {{name = 'Duplex', is_array = false, struct = nil}}

function TDuplex:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Duplex', self.Duplex, 'uint32', false, errs, need_convert)

    TDuplex:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TDuplex.proto_property, errs, need_convert)
    return self
end

function TDuplex:unpack(_)
    return self.Duplex
end

MLswPortInfo.Duplex = TDuplex

---@class MLswPortInfo.Speed
---@field Speed integer
local TSpeed = {}
TSpeed.__index = TSpeed
TSpeed.group = {}

local function TSpeed_from_obj(obj)
    return setmetatable(obj, TSpeed)
end

function TSpeed.new(Speed)
    return TSpeed_from_obj({Speed = Speed})
end
---@param obj MLswPortInfo.Speed
function TSpeed:init_from_obj(obj)
    self.Speed = obj.Speed
end

function TSpeed:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSpeed.group)
end

TSpeed.from_obj = TSpeed_from_obj

TSpeed.proto_property = {'Speed'}

TSpeed.default = {0}

TSpeed.struct = {{name = 'Speed', is_array = false, struct = nil}}

function TSpeed:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Speed', self.Speed, 'uint32', false, errs, need_convert)

    TSpeed:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSpeed.proto_property, errs, need_convert)
    return self
end

function TSpeed:unpack(_)
    return self.Speed
end

MLswPortInfo.Speed = TSpeed

---@class MLswPortInfo.LinkStatus
---@field LinkStatus integer
local TLinkStatus = {}
TLinkStatus.__index = TLinkStatus
TLinkStatus.group = {}

local function TLinkStatus_from_obj(obj)
    return setmetatable(obj, TLinkStatus)
end

function TLinkStatus.new(LinkStatus)
    return TLinkStatus_from_obj({LinkStatus = LinkStatus})
end
---@param obj MLswPortInfo.LinkStatus
function TLinkStatus:init_from_obj(obj)
    self.LinkStatus = obj.LinkStatus
end

function TLinkStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinkStatus.group)
end

TLinkStatus.from_obj = TLinkStatus_from_obj

TLinkStatus.proto_property = {'LinkStatus'}

TLinkStatus.default = {0}

TLinkStatus.struct = {{name = 'LinkStatus', is_array = false, struct = nil}}

function TLinkStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LinkStatus', self.LinkStatus, 'uint32', false, errs, need_convert)

    TLinkStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinkStatus.proto_property, errs, need_convert)
    return self
end

function TLinkStatus:unpack(_)
    return self.LinkStatus
end

MLswPortInfo.LinkStatus = TLinkStatus

---@class MLswPortInfo.ExportPort
---@field ExportPort boolean
local TExportPort = {}
TExportPort.__index = TExportPort
TExportPort.group = {}

local function TExportPort_from_obj(obj)
    return setmetatable(obj, TExportPort)
end

function TExportPort.new(ExportPort)
    return TExportPort_from_obj({ExportPort = ExportPort})
end
---@param obj MLswPortInfo.ExportPort
function TExportPort:init_from_obj(obj)
    self.ExportPort = obj.ExportPort
end

function TExportPort:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExportPort.group)
end

TExportPort.from_obj = TExportPort_from_obj

TExportPort.proto_property = {'ExportPort'}

TExportPort.default = {false}

TExportPort.struct = {{name = 'ExportPort', is_array = false, struct = nil}}

function TExportPort:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ExportPort', self.ExportPort, 'bool', false, errs, need_convert)

    TExportPort:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExportPort.proto_property, errs, need_convert)
    return self
end

function TExportPort:unpack(_)
    return self.ExportPort
end

MLswPortInfo.ExportPort = TExportPort

---@class MLswPortInfo.AccFrameType
---@field AccFrameType integer
local TAccFrameType = {}
TAccFrameType.__index = TAccFrameType
TAccFrameType.group = {}

local function TAccFrameType_from_obj(obj)
    return setmetatable(obj, TAccFrameType)
end

function TAccFrameType.new(AccFrameType)
    return TAccFrameType_from_obj({AccFrameType = AccFrameType})
end
---@param obj MLswPortInfo.AccFrameType
function TAccFrameType:init_from_obj(obj)
    self.AccFrameType = obj.AccFrameType
end

function TAccFrameType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TAccFrameType.group)
end

TAccFrameType.from_obj = TAccFrameType_from_obj

TAccFrameType.proto_property = {'AccFrameType'}

TAccFrameType.default = {0}

TAccFrameType.struct = {{name = 'AccFrameType', is_array = false, struct = nil}}

function TAccFrameType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'AccFrameType', self.AccFrameType, 'uint32', false, errs, need_convert)

    TAccFrameType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TAccFrameType.proto_property, errs, need_convert)
    return self
end

function TAccFrameType:unpack(_)
    return self.AccFrameType
end

MLswPortInfo.AccFrameType = TAccFrameType

---@class MLswPortInfo.PVid
---@field PVid integer
local TPVid = {}
TPVid.__index = TPVid
TPVid.group = {}

local function TPVid_from_obj(obj)
    return setmetatable(obj, TPVid)
end

function TPVid.new(PVid)
    return TPVid_from_obj({PVid = PVid})
end
---@param obj MLswPortInfo.PVid
function TPVid:init_from_obj(obj)
    self.PVid = obj.PVid
end

function TPVid:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPVid.group)
end

TPVid.from_obj = TPVid_from_obj

TPVid.proto_property = {'PVid'}

TPVid.default = {0}

TPVid.struct = {{name = 'PVid', is_array = false, struct = nil}}

function TPVid:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PVid', self.PVid, 'uint32', false, errs, need_convert)

    TPVid:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPVid.proto_property, errs, need_convert)
    return self
end

function TPVid:unpack(_)
    return self.PVid
end

MLswPortInfo.PVid = TPVid

---@class MLswPortInfo.PortIso
---@field PortIso integer
local TPortIso = {}
TPortIso.__index = TPortIso
TPortIso.group = {}

local function TPortIso_from_obj(obj)
    return setmetatable(obj, TPortIso)
end

function TPortIso.new(PortIso)
    return TPortIso_from_obj({PortIso = PortIso})
end
---@param obj MLswPortInfo.PortIso
function TPortIso:init_from_obj(obj)
    self.PortIso = obj.PortIso
end

function TPortIso:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPortIso.group)
end

TPortIso.from_obj = TPortIso_from_obj

TPortIso.proto_property = {'PortIso'}

TPortIso.default = {0}

TPortIso.struct = {{name = 'PortIso', is_array = false, struct = nil}}

function TPortIso:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PortIso', self.PortIso, 'uint32', false, errs, need_convert)

    TPortIso:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPortIso.proto_property, errs, need_convert)
    return self
end

function TPortIso:unpack(_)
    return self.PortIso
end

MLswPortInfo.PortIso = TPortIso

---@class MLswPortInfo.LinkCheck
---@field LinkCheck boolean
local TLinkCheck = {}
TLinkCheck.__index = TLinkCheck
TLinkCheck.group = {}

local function TLinkCheck_from_obj(obj)
    return setmetatable(obj, TLinkCheck)
end

function TLinkCheck.new(LinkCheck)
    return TLinkCheck_from_obj({LinkCheck = LinkCheck})
end
---@param obj MLswPortInfo.LinkCheck
function TLinkCheck:init_from_obj(obj)
    self.LinkCheck = obj.LinkCheck
end

function TLinkCheck:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLinkCheck.group)
end

TLinkCheck.from_obj = TLinkCheck_from_obj

TLinkCheck.proto_property = {'LinkCheck'}

TLinkCheck.default = {false}

TLinkCheck.struct = {{name = 'LinkCheck', is_array = false, struct = nil}}

function TLinkCheck:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LinkCheck', self.LinkCheck, 'bool', false, errs, need_convert)

    TLinkCheck:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLinkCheck.proto_property, errs, need_convert)
    return self
end

function TLinkCheck:unpack(_)
    return self.LinkCheck
end

MLswPortInfo.LinkCheck = TLinkCheck

---@class MLswPortInfo.ConPhyAddr
---@field ConPhyAddr integer
local TConPhyAddr = {}
TConPhyAddr.__index = TConPhyAddr
TConPhyAddr.group = {}

local function TConPhyAddr_from_obj(obj)
    return setmetatable(obj, TConPhyAddr)
end

function TConPhyAddr.new(ConPhyAddr)
    return TConPhyAddr_from_obj({ConPhyAddr = ConPhyAddr})
end
---@param obj MLswPortInfo.ConPhyAddr
function TConPhyAddr:init_from_obj(obj)
    self.ConPhyAddr = obj.ConPhyAddr
end

function TConPhyAddr:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConPhyAddr.group)
end

TConPhyAddr.from_obj = TConPhyAddr_from_obj

TConPhyAddr.proto_property = {'ConPhyAddr'}

TConPhyAddr.default = {0}

TConPhyAddr.struct = {{name = 'ConPhyAddr', is_array = false, struct = nil}}

function TConPhyAddr:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ConPhyAddr', self.ConPhyAddr, 'uint32', false, errs, need_convert)

    TConPhyAddr:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConPhyAddr.proto_property, errs, need_convert)
    return self
end

function TConPhyAddr:unpack(_)
    return self.ConPhyAddr
end

MLswPortInfo.ConPhyAddr = TConPhyAddr

---@class MLswPortInfo.ExtMode
---@field ExtMode integer
local TExtMode = {}
TExtMode.__index = TExtMode
TExtMode.group = {}

local function TExtMode_from_obj(obj)
    return setmetatable(obj, TExtMode)
end

function TExtMode.new(ExtMode)
    return TExtMode_from_obj({ExtMode = ExtMode})
end
---@param obj MLswPortInfo.ExtMode
function TExtMode:init_from_obj(obj)
    self.ExtMode = obj.ExtMode
end

function TExtMode:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExtMode.group)
end

TExtMode.from_obj = TExtMode_from_obj

TExtMode.proto_property = {'ExtMode'}

TExtMode.default = {0}

TExtMode.struct = {{name = 'ExtMode', is_array = false, struct = nil}}

function TExtMode:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ExtMode', self.ExtMode, 'uint32', false, errs, need_convert)

    TExtMode:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExtMode.proto_property, errs, need_convert)
    return self
end

function TExtMode:unpack(_)
    return self.ExtMode
end

MLswPortInfo.ExtMode = TExtMode

---@class MLswPortInfo.PortType
---@field PortType integer
local TPortType = {}
TPortType.__index = TPortType
TPortType.group = {}

local function TPortType_from_obj(obj)
    return setmetatable(obj, TPortType)
end

function TPortType.new(PortType)
    return TPortType_from_obj({PortType = PortType})
end
---@param obj MLswPortInfo.PortType
function TPortType:init_from_obj(obj)
    self.PortType = obj.PortType
end

function TPortType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPortType.group)
end

TPortType.from_obj = TPortType_from_obj

TPortType.proto_property = {'PortType'}

TPortType.default = {0}

TPortType.struct = {{name = 'PortType', is_array = false, struct = nil}}

function TPortType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PortType', self.PortType, 'uint32', false, errs, need_convert)

    TPortType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPortType.proto_property, errs, need_convert)
    return self
end

function TPortType:unpack(_)
    return self.PortType
end

MLswPortInfo.PortType = TPortType

---@class MLswPortInfo.PhysicalId
---@field PhysicalId integer
local TPhysicalId = {}
TPhysicalId.__index = TPhysicalId
TPhysicalId.group = {}

local function TPhysicalId_from_obj(obj)
    return setmetatable(obj, TPhysicalId)
end

function TPhysicalId.new(PhysicalId)
    return TPhysicalId_from_obj({PhysicalId = PhysicalId})
end
---@param obj MLswPortInfo.PhysicalId
function TPhysicalId:init_from_obj(obj)
    self.PhysicalId = obj.PhysicalId
end

function TPhysicalId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPhysicalId.group)
end

TPhysicalId.from_obj = TPhysicalId_from_obj

TPhysicalId.proto_property = {'PhysicalId'}

TPhysicalId.default = {0}

TPhysicalId.struct = {{name = 'PhysicalId', is_array = false, struct = nil}}

function TPhysicalId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PhysicalId', self.PhysicalId, 'uint32', false, errs, need_convert)

    TPhysicalId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPhysicalId.proto_property, errs, need_convert)
    return self
end

function TPhysicalId:unpack(_)
    return self.PhysicalId
end

MLswPortInfo.PhysicalId = TPhysicalId

---@class MLswPortInfo.LogicId
---@field LogicId integer
local TLogicId = {}
TLogicId.__index = TLogicId
TLogicId.group = {}

local function TLogicId_from_obj(obj)
    return setmetatable(obj, TLogicId)
end

function TLogicId.new(LogicId)
    return TLogicId_from_obj({LogicId = LogicId})
end
---@param obj MLswPortInfo.LogicId
function TLogicId:init_from_obj(obj)
    self.LogicId = obj.LogicId
end

function TLogicId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TLogicId.group)
end

TLogicId.from_obj = TLogicId_from_obj

TLogicId.proto_property = {'LogicId'}

TLogicId.default = {0}

TLogicId.struct = {{name = 'LogicId', is_array = false, struct = nil}}

function TLogicId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'LogicId', self.LogicId, 'uint32', false, errs, need_convert)

    TLogicId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TLogicId.proto_property, errs, need_convert)
    return self
end

function TLogicId:unpack(_)
    return self.LogicId
end

MLswPortInfo.LogicId = TLogicId

---@class MLswPortInfo.Unit
---@field Unit integer
local TUnit = {}
TUnit.__index = TUnit
TUnit.group = {}

local function TUnit_from_obj(obj)
    return setmetatable(obj, TUnit)
end

function TUnit.new(Unit)
    return TUnit_from_obj({Unit = Unit})
end
---@param obj MLswPortInfo.Unit
function TUnit:init_from_obj(obj)
    self.Unit = obj.Unit
end

function TUnit:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUnit.group)
end

TUnit.from_obj = TUnit_from_obj

TUnit.proto_property = {'Unit'}

TUnit.default = {0}

TUnit.struct = {{name = 'Unit', is_array = false, struct = nil}}

function TUnit:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Unit', self.Unit, 'uint32', false, errs, need_convert)

    TUnit:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUnit.proto_property, errs, need_convert)
    return self
end

function TUnit:unpack(_)
    return self.Unit
end

MLswPortInfo.Unit = TUnit

return MLswPortInfo
