-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'

local SyssdmEnums = require 'syssdm.types.enums'

local SyssdmMsg = {}

---@class SyssdmMsg.PowerCtrlReq
---@field SystemId integer
---@field FruId integer
---@field PowerCtrlType SyssdmEnums.PowerCtrlType
---@field RestartCause SyssdmEnums.RestartCause
local TPowerCtrlReq = {}
TPowerCtrlReq.__index = TPowerCtrlReq
TPowerCtrlReq.group = {}

local function TPowerCtrlReq_from_obj(obj)
    obj.PowerCtrlType = obj.PowerCtrlType and SyssdmEnums.PowerCtrlType.new(obj.PowerCtrlType)
    obj.RestartCause = obj.RestartCause and SyssdmEnums.RestartCause.new(obj.RestartCause)
    return setmetatable(obj, TPowerCtrlReq)
end

function TPowerCtrlReq.new(SystemId, FruId, PowerCtrlType, RestartCause)
    return TPowerCtrlReq_from_obj({
        SystemId = SystemId,
        FruId = FruId,
        PowerCtrlType = PowerCtrlType,
        RestartCause = RestartCause
    })
end
---@param obj SyssdmMsg.PowerCtrlReq
function TPowerCtrlReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.FruId = obj.FruId
    self.PowerCtrlType = obj.PowerCtrlType
    self.RestartCause = obj.RestartCause
end

function TPowerCtrlReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerCtrlReq.group)
end

TPowerCtrlReq.from_obj = TPowerCtrlReq_from_obj

TPowerCtrlReq.proto_property = {'SystemId', 'FruId', 'PowerCtrlType', 'RestartCause'}

TPowerCtrlReq.default = {0, 0, SyssdmEnums.PowerCtrlType.default, SyssdmEnums.RestartCause.default}

TPowerCtrlReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'FruId', is_array = false, struct = nil},
    {name = 'PowerCtrlType', is_array = false, struct = SyssdmEnums.PowerCtrlType.struct},
    {name = 'RestartCause', is_array = false, struct = SyssdmEnums.RestartCause.struct}
}

function TPowerCtrlReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'int32', false, errs)
    validate.Required(prefix .. 'FruId', self.FruId, 'int32', false, errs)
    validate.Required(prefix .. 'PowerCtrlType', self.PowerCtrlType, 'SyssdmEnums.PowerCtrlType',
        false, errs)
    validate.Required(prefix .. 'RestartCause', self.RestartCause, 'SyssdmEnums.RestartCause',
        false, errs)

    TPowerCtrlReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerCtrlReq.proto_property, errs)
    return self
end

function TPowerCtrlReq:unpack(raw)
    local PowerCtrlType = utils.unpack_enum(raw, self.PowerCtrlType)
    local RestartCause = utils.unpack_enum(raw, self.RestartCause)
    return self.SystemId, self.FruId, PowerCtrlType, RestartCause
end

SyssdmMsg.PowerCtrlReq = TPowerCtrlReq

---@class SyssdmMsg.PowerCtrlRsp
---@field CmdResult integer
local TPowerCtrlRsp = {}
TPowerCtrlRsp.__index = TPowerCtrlRsp
TPowerCtrlRsp.group = {}

local function TPowerCtrlRsp_from_obj(obj)
    return setmetatable(obj, TPowerCtrlRsp)
end

function TPowerCtrlRsp.new(CmdResult)
    return TPowerCtrlRsp_from_obj({CmdResult = CmdResult})
end
---@param obj SyssdmMsg.PowerCtrlRsp
function TPowerCtrlRsp:init_from_obj(obj)
    self.CmdResult = obj.CmdResult
end

function TPowerCtrlRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerCtrlRsp.group)
end

TPowerCtrlRsp.from_obj = TPowerCtrlRsp_from_obj

TPowerCtrlRsp.proto_property = {'CmdResult'}

TPowerCtrlRsp.default = {0}

TPowerCtrlRsp.struct = {{name = 'CmdResult', is_array = false, struct = nil}}

function TPowerCtrlRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'CmdResult', self.CmdResult, 'int32', false, errs)

    TPowerCtrlRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerCtrlRsp.proto_property, errs)
    return self
end

function TPowerCtrlRsp:unpack(_)
    return self.CmdResult
end

SyssdmMsg.PowerCtrlRsp = TPowerCtrlRsp

---@class SyssdmMsg.UpgradePrepareReq
---@field SystemId integer
---@field FirmwareType string
local TUpgradePrepareReq = {}
TUpgradePrepareReq.__index = TUpgradePrepareReq
TUpgradePrepareReq.group = {}

local function TUpgradePrepareReq_from_obj(obj)
    return setmetatable(obj, TUpgradePrepareReq)
end

function TUpgradePrepareReq.new(SystemId, FirmwareType)
    return TUpgradePrepareReq_from_obj({SystemId = SystemId, FirmwareType = FirmwareType})
end
---@param obj SyssdmMsg.UpgradePrepareReq
function TUpgradePrepareReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.FirmwareType = obj.FirmwareType
end

function TUpgradePrepareReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpgradePrepareReq.group)
end

TUpgradePrepareReq.from_obj = TUpgradePrepareReq_from_obj

TUpgradePrepareReq.proto_property = {'SystemId', 'FirmwareType'}

TUpgradePrepareReq.default = {0, ''}

TUpgradePrepareReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'FirmwareType', is_array = false, struct = nil}
}

function TUpgradePrepareReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'int32', false, errs)
    validate.Required(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs)

    TUpgradePrepareReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpgradePrepareReq.proto_property, errs)
    return self
end

function TUpgradePrepareReq:unpack(_)
    return self.SystemId, self.FirmwareType
end

SyssdmMsg.UpgradePrepareReq = TUpgradePrepareReq

---@class SyssdmMsg.UpgradePrepareReplyReq
---@field SystemId integer
---@field FirmwareType string
---@field PrepareResult integer
local TUpgradePrepareReplyReq = {}
TUpgradePrepareReplyReq.__index = TUpgradePrepareReplyReq
TUpgradePrepareReplyReq.group = {}

local function TUpgradePrepareReplyReq_from_obj(obj)
    return setmetatable(obj, TUpgradePrepareReplyReq)
end

function TUpgradePrepareReplyReq.new(SystemId, FirmwareType, PrepareResult)
    return TUpgradePrepareReplyReq_from_obj({
        SystemId = SystemId,
        FirmwareType = FirmwareType,
        PrepareResult = PrepareResult
    })
end
---@param obj SyssdmMsg.UpgradePrepareReplyReq
function TUpgradePrepareReplyReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.FirmwareType = obj.FirmwareType
    self.PrepareResult = obj.PrepareResult
end

function TUpgradePrepareReplyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpgradePrepareReplyReq.group)
end

TUpgradePrepareReplyReq.from_obj = TUpgradePrepareReplyReq_from_obj

TUpgradePrepareReplyReq.proto_property = {'SystemId', 'FirmwareType', 'PrepareResult'}

TUpgradePrepareReplyReq.default = {0, '', 0}

TUpgradePrepareReplyReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'FirmwareType', is_array = false, struct = nil},
    {name = 'PrepareResult', is_array = false, struct = nil}
}

function TUpgradePrepareReplyReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'int32', false, errs)
    validate.Required(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs)
    validate.Required(prefix .. 'PrepareResult', self.PrepareResult, 'int32', false, errs)

    TUpgradePrepareReplyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpgradePrepareReplyReq.proto_property, errs)
    return self
end

function TUpgradePrepareReplyReq:unpack(_)
    return self.SystemId, self.FirmwareType, self.PrepareResult
end

SyssdmMsg.UpgradePrepareReplyReq = TUpgradePrepareReplyReq

---@class SyssdmMsg.UpgradeProcessReq
---@field SystemId integer
---@field FirmwareType string
---@field FirmwarePath string
local TUpgradeProcessReq = {}
TUpgradeProcessReq.__index = TUpgradeProcessReq
TUpgradeProcessReq.group = {}

local function TUpgradeProcessReq_from_obj(obj)
    return setmetatable(obj, TUpgradeProcessReq)
end

function TUpgradeProcessReq.new(SystemId, FirmwareType, FirmwarePath)
    return TUpgradeProcessReq_from_obj({
        SystemId = SystemId,
        FirmwareType = FirmwareType,
        FirmwarePath = FirmwarePath
    })
end
---@param obj SyssdmMsg.UpgradeProcessReq
function TUpgradeProcessReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.FirmwareType = obj.FirmwareType
    self.FirmwarePath = obj.FirmwarePath
end

function TUpgradeProcessReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpgradeProcessReq.group)
end

TUpgradeProcessReq.from_obj = TUpgradeProcessReq_from_obj

TUpgradeProcessReq.proto_property = {'SystemId', 'FirmwareType', 'FirmwarePath'}

TUpgradeProcessReq.default = {0, '', ''}

TUpgradeProcessReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'FirmwareType', is_array = false, struct = nil},
    {name = 'FirmwarePath', is_array = false, struct = nil}
}

function TUpgradeProcessReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'int32', false, errs)
    validate.Required(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs)
    validate.Required(prefix .. 'FirmwarePath', self.FirmwarePath, 'string', false, errs)

    TUpgradeProcessReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpgradeProcessReq.proto_property, errs)
    return self
end

function TUpgradeProcessReq:unpack(_)
    return self.SystemId, self.FirmwareType, self.FirmwarePath
end

SyssdmMsg.UpgradeProcessReq = TUpgradeProcessReq

---@class SyssdmMsg.UpgradeProcessReplyReq
---@field SystemId integer
---@field FirmwareType string
---@field ProcessResult integer
local TUpgradeProcessReplyReq = {}
TUpgradeProcessReplyReq.__index = TUpgradeProcessReplyReq
TUpgradeProcessReplyReq.group = {}

local function TUpgradeProcessReplyReq_from_obj(obj)
    return setmetatable(obj, TUpgradeProcessReplyReq)
end

function TUpgradeProcessReplyReq.new(SystemId, FirmwareType, ProcessResult)
    return TUpgradeProcessReplyReq_from_obj({
        SystemId = SystemId,
        FirmwareType = FirmwareType,
        ProcessResult = ProcessResult
    })
end
---@param obj SyssdmMsg.UpgradeProcessReplyReq
function TUpgradeProcessReplyReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.FirmwareType = obj.FirmwareType
    self.ProcessResult = obj.ProcessResult
end

function TUpgradeProcessReplyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpgradeProcessReplyReq.group)
end

TUpgradeProcessReplyReq.from_obj = TUpgradeProcessReplyReq_from_obj

TUpgradeProcessReplyReq.proto_property = {'SystemId', 'FirmwareType', 'ProcessResult'}

TUpgradeProcessReplyReq.default = {0, '', 0}

TUpgradeProcessReplyReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'FirmwareType', is_array = false, struct = nil},
    {name = 'ProcessResult', is_array = false, struct = nil}
}

function TUpgradeProcessReplyReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'int32', false, errs)
    validate.Required(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs)
    validate.Required(prefix .. 'ProcessResult', self.ProcessResult, 'int32', false, errs)

    TUpgradeProcessReplyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpgradeProcessReplyReq.proto_property, errs)
    return self
end

function TUpgradeProcessReplyReq:unpack(_)
    return self.SystemId, self.FirmwareType, self.ProcessResult
end

SyssdmMsg.UpgradeProcessReplyReq = TUpgradeProcessReplyReq

---@class SyssdmMsg.UpgradeStatusReplyReq
---@field SystemId integer
---@field FirmwareType string
---@field Status integer
---@field Progress integer
---@field ResultDescription string
local TUpgradeStatusReplyReq = {}
TUpgradeStatusReplyReq.__index = TUpgradeStatusReplyReq
TUpgradeStatusReplyReq.group = {}

local function TUpgradeStatusReplyReq_from_obj(obj)
    return setmetatable(obj, TUpgradeStatusReplyReq)
end

function TUpgradeStatusReplyReq.new(SystemId, FirmwareType, Status, Progress, ResultDescription)
    return TUpgradeStatusReplyReq_from_obj({
        SystemId = SystemId,
        FirmwareType = FirmwareType,
        Status = Status,
        Progress = Progress,
        ResultDescription = ResultDescription
    })
end
---@param obj SyssdmMsg.UpgradeStatusReplyReq
function TUpgradeStatusReplyReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.FirmwareType = obj.FirmwareType
    self.Status = obj.Status
    self.Progress = obj.Progress
    self.ResultDescription = obj.ResultDescription
end

function TUpgradeStatusReplyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpgradeStatusReplyReq.group)
end

TUpgradeStatusReplyReq.from_obj = TUpgradeStatusReplyReq_from_obj

TUpgradeStatusReplyReq.proto_property = {
    'SystemId', 'FirmwareType', 'Status', 'Progress', 'ResultDescription'
}

TUpgradeStatusReplyReq.default = {0, '', 0, 0, ''}

TUpgradeStatusReplyReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'FirmwareType', is_array = false, struct = nil},
    {name = 'Status', is_array = false, struct = nil},
    {name = 'Progress', is_array = false, struct = nil},
    {name = 'ResultDescription', is_array = false, struct = nil}
}

function TUpgradeStatusReplyReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'int32', false, errs)
    validate.Required(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs)
    validate.Required(prefix .. 'Status', self.Status, 'int32', false, errs)
    validate.Required(prefix .. 'Progress', self.Progress, 'int32', false, errs)
    validate.Required(prefix .. 'ResultDescription', self.ResultDescription, 'string', false, errs)

    validate.ranges(prefix .. 'Progress', self.Progress, 0, 100, errs)

    TUpgradeStatusReplyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpgradeStatusReplyReq.proto_property, errs)
    return self
end

function TUpgradeStatusReplyReq:unpack(_)
    return self.SystemId, self.FirmwareType, self.Status, self.Progress, self.ResultDescription
end

SyssdmMsg.UpgradeStatusReplyReq = TUpgradeStatusReplyReq

---@class SyssdmMsg.UpgradeFinishReq
---@field SystemId integer
---@field FirmwareType string
local TUpgradeFinishReq = {}
TUpgradeFinishReq.__index = TUpgradeFinishReq
TUpgradeFinishReq.group = {}

local function TUpgradeFinishReq_from_obj(obj)
    return setmetatable(obj, TUpgradeFinishReq)
end

function TUpgradeFinishReq.new(SystemId, FirmwareType)
    return TUpgradeFinishReq_from_obj({SystemId = SystemId, FirmwareType = FirmwareType})
end
---@param obj SyssdmMsg.UpgradeFinishReq
function TUpgradeFinishReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.FirmwareType = obj.FirmwareType
end

function TUpgradeFinishReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpgradeFinishReq.group)
end

TUpgradeFinishReq.from_obj = TUpgradeFinishReq_from_obj

TUpgradeFinishReq.proto_property = {'SystemId', 'FirmwareType'}

TUpgradeFinishReq.default = {0, ''}

TUpgradeFinishReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'FirmwareType', is_array = false, struct = nil}
}

function TUpgradeFinishReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'int32', false, errs)
    validate.Required(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs)

    TUpgradeFinishReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpgradeFinishReq.proto_property, errs)
    return self
end

function TUpgradeFinishReq:unpack(_)
    return self.SystemId, self.FirmwareType
end

SyssdmMsg.UpgradeFinishReq = TUpgradeFinishReq

---@class SyssdmMsg.UpgradeFinishReplyReq
---@field SystemId integer
---@field FirmwareType string
---@field FinishResult integer
local TUpgradeFinishReplyReq = {}
TUpgradeFinishReplyReq.__index = TUpgradeFinishReplyReq
TUpgradeFinishReplyReq.group = {}

local function TUpgradeFinishReplyReq_from_obj(obj)
    return setmetatable(obj, TUpgradeFinishReplyReq)
end

function TUpgradeFinishReplyReq.new(SystemId, FirmwareType, FinishResult)
    return TUpgradeFinishReplyReq_from_obj({
        SystemId = SystemId,
        FirmwareType = FirmwareType,
        FinishResult = FinishResult
    })
end
---@param obj SyssdmMsg.UpgradeFinishReplyReq
function TUpgradeFinishReplyReq:init_from_obj(obj)
    self.SystemId = obj.SystemId
    self.FirmwareType = obj.FirmwareType
    self.FinishResult = obj.FinishResult
end

function TUpgradeFinishReplyReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpgradeFinishReplyReq.group)
end

TUpgradeFinishReplyReq.from_obj = TUpgradeFinishReplyReq_from_obj

TUpgradeFinishReplyReq.proto_property = {'SystemId', 'FirmwareType', 'FinishResult'}

TUpgradeFinishReplyReq.default = {0, '', 0}

TUpgradeFinishReplyReq.struct = {
    {name = 'SystemId', is_array = false, struct = nil},
    {name = 'FirmwareType', is_array = false, struct = nil},
    {name = 'FinishResult', is_array = false, struct = nil}
}

function TUpgradeFinishReplyReq:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'SystemId', self.SystemId, 'int32', false, errs)
    validate.Required(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs)
    validate.Required(prefix .. 'FinishResult', self.FinishResult, 'int32', false, errs)

    TUpgradeFinishReplyReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpgradeFinishReplyReq.proto_property, errs)
    return self
end

function TUpgradeFinishReplyReq:unpack(_)
    return self.SystemId, self.FirmwareType, self.FinishResult
end

SyssdmMsg.UpgradeFinishReplyReq = TUpgradeFinishReplyReq

---@class SyssdmMsg.UpgradeCtrlRsp
---@field CmdResult integer
local TUpgradeCtrlRsp = {}
TUpgradeCtrlRsp.__index = TUpgradeCtrlRsp
TUpgradeCtrlRsp.group = {}

local function TUpgradeCtrlRsp_from_obj(obj)
    return setmetatable(obj, TUpgradeCtrlRsp)
end

function TUpgradeCtrlRsp.new(CmdResult)
    return TUpgradeCtrlRsp_from_obj({CmdResult = CmdResult})
end
---@param obj SyssdmMsg.UpgradeCtrlRsp
function TUpgradeCtrlRsp:init_from_obj(obj)
    self.CmdResult = obj.CmdResult
end

function TUpgradeCtrlRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUpgradeCtrlRsp.group)
end

TUpgradeCtrlRsp.from_obj = TUpgradeCtrlRsp_from_obj

TUpgradeCtrlRsp.proto_property = {'CmdResult'}

TUpgradeCtrlRsp.default = {0}

TUpgradeCtrlRsp.struct = {{name = 'CmdResult', is_array = false, struct = nil}}

function TUpgradeCtrlRsp:validate(prefix, errs)
    prefix = prefix or ''

    validate.Required(prefix .. 'CmdResult', self.CmdResult, 'int32', false, errs)

    TUpgradeCtrlRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUpgradeCtrlRsp.proto_property, errs)
    return self
end

function TUpgradeCtrlRsp:unpack(_)
    return self.CmdResult
end

SyssdmMsg.UpgradeCtrlRsp = TUpgradeCtrlRsp

return SyssdmMsg
