-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local create_enum_type = require 'mc.enum'

local SyssdmEnums = {}

---@class SyssdmEnums.PowerCtrlType: Enum
local EPowerCtrlType = create_enum_type('PowerCtrlType')
EPowerCtrlType.On = EPowerCtrlType.new(0)
EPowerCtrlType.ForceOff = EPowerCtrlType.new(1)
EPowerCtrlType.GraceShutDown = EPowerCtrlType.new(2)
EPowerCtrlType.GracefulRestart = EPowerCtrlType.new(3)
EPowerCtrlType.ForceRestart = EPowerCtrlType.new(4)
EPowerCtrlType.NMI = EPowerCtrlType.new(5)
EPowerCtrlType.ForceOn = EPowerCtrlType.new(6)
EPowerCtrlType.PushPowerButton = EPowerCtrlType.new(7)
EPowerCtrlType.PowerCycle = EPowerCtrlType.new(8)
EPowerCtrlType.Suspend = EPowerCtrlType.new(9)
EPowerCtrlType.Pause = EPowerCtrlType.new(10)
EPowerCtrlType.Resume = EPowerCtrlType.new(11)

SyssdmEnums.PowerCtrlType = EPowerCtrlType

---@class SyssdmEnums.RestartCause: Enum
local ERestartCause = create_enum_type('RestartCause')
ERestartCause.Unknown = ERestartCause.new(0)
ERestartCause.ChassisControlCommand = ERestartCause.new(1)
ERestartCause.ResetViaPushButton = ERestartCause.new(2)
ERestartCause.PowerUpViaPushButton = ERestartCause.new(3)
ERestartCause.WatchdogExpiration = ERestartCause.new(4)
ERestartCause.Oem = ERestartCause.new(5)
ERestartCause.ACRestoreAlwaysPowerUp = ERestartCause.new(6)
ERestartCause.ACRestoreKeepPreviousState = ERestartCause.new(7)
ERestartCause.ResetViaPEF = ERestartCause.new(8)
ERestartCause.PowerCycleViaPEF = ERestartCause.new(9)
ERestartCause.SoftReset = ERestartCause.new(10)
ERestartCause.PowerupViaRTC = ERestartCause.new(11)

SyssdmEnums.RestartCause = ERestartCause

---@class SyssdmEnums.UpgradeState: Enum
local EUpgradeState = create_enum_type('UpgradeState')
EUpgradeState.UpgradeIdle = EUpgradeState.new(0)
EUpgradeState.UpgradePreparing = EUpgradeState.new(1)
EUpgradeState.UpgradePrepareDone = EUpgradeState.new(2)
EUpgradeState.UpgradeInprogress = EUpgradeState.new(3)
EUpgradeState.UpgradeStopped = EUpgradeState.new(4)
EUpgradeState.UpgradeCompleted = EUpgradeState.new(5)

SyssdmEnums.UpgradeState = EUpgradeState

---@class SyssdmEnums.ConfigState: Enum
local EConfigState = create_enum_type('ConfigState')
EConfigState.ConfigIdle = EConfigState.new(0)
EConfigState.ConfigImportInprogress = EConfigState.new(1)
EConfigState.ConfigExportInprogress = EConfigState.new(2)
EConfigState.ConfigBackupInprogress = EConfigState.new(3)
EConfigState.ConfigRetoreInprogress = EConfigState.new(4)

SyssdmEnums.ConfigState = EConfigState

return SyssdmEnums
