-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local lu = require 'luaunit'
local unit = require 'unit_manager.class.unit.unit'

TestUnit = {}

local unit_tab = {}
function TestUnit:setUp()
    unit.set_prop = function(_, k, v)
        if k == 'CpldTestReg' then
            -- CPLD自检异常打桩测试
            unit_tab[k] = v == 0x55 and 0xaa or 0x55
        else
            unit_tab[k] = v
        end
    end
    unit.get_prop = function(_, k)
        return unit_tab[k]
    end
end

function TestUnit:test_cpld_self_test_process_failed()
    unit:ctor({}, {name = "Expboard_1", CpldStatus = 0, CpldTestReg = 0xaa}, nil, nil)
    local ok = unit:cpld_self_test_process(1, 0xaa)
    lu.assertEquals(ok, nil)
end

function TestUnit:test_cpld_self_test_reg()
    unit.get_prop = function(name)
        return 1
    end
    local temp = unit.mds_obj
    unit.mds_obj = {
        get_property = function()
            return 1
        end
    }
    unit.fail_count_list = {1}
    unit.mds_obj.remote_ref_props = {
        ['CpldTestReg'] = true
    }
    local ok = pcall(function ()
        return unit:cpld_self_test()        
    end)
    lu.assertEquals(ok, true)
    unit.mds_obj = temp
end