-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local fpga_test = require 'unit_manager.class.logic_fw.fpga.fpga_self_test'
local client = require 'general_hardware.client'

TestFPGAFlow = {}

function TestFPGAFlow:test_add_event()
    local check_para = nil
    local origin_fun = client.ForeachEventsObjects
    client.obj = {path = '/bmc/kepler/Systems/1/Events'}
    client.ForeachEventsObjects = function(self, cb)
        cb(self.obj)
    end
    client.obj.AddEvent_PACKED = function(self, ctx, param)
        check_para = param
        return {unpack = function() end}
    end
    fpga_test.get_instance():generate_fpga_self_test_event(1, 'ExpBoard1')
    lu.assertEquals(check_para[1][2], 'ExpBoard1')
    lu.assertEquals(check_para[2][2], 'true')
    lu.assertEquals(check_para[3][2], 'ExpBoard.ExpBoardFPGASelfTestFailure')
    lu.assertEquals(check_para[4][2], '["L1","1"]')
    lu.assertEquals(check_para[5][2], '')
    lu.assertEquals(check_para[7][2], '1')
    lu.assertEquals(check_para[8][2], '')
    lu.assertEquals(fpga_test.get_instance().event_status, 1)

    fpga_test.get_instance():generate_fpga_self_test_event(0, 'ExpBoard2')
    lu.assertEquals(check_para[1][2], 'ExpBoard2')
    lu.assertEquals(check_para[2][2], 'false')
    lu.assertEquals(check_para[3][2], 'ExpBoard.ExpBoardFPGASelfTestFailure')
    lu.assertEquals(check_para[4][2], '["L1","2"]')
    lu.assertEquals(check_para[5][2], '')
    lu.assertEquals(check_para[7][2], '1')
    lu.assertEquals(check_para[8][2], '')
    lu.assertEquals(fpga_test.get_instance().event_status, 0)
    client.ForeachEventsObjects = origin_fun
    client.obj = nil
end

function TestFPGAFlow:test_find_event_obj_fail()
    -- fpga_test在各用例中共用，先恢复默认值
    fpga_test.get_instance().event_status = -1
    local origin_fun = client.ForeachEventsObjects
    client.obj = {path = '/bmc/Events'}
    client.ForeachEventsObjects = function(self, cb)
        cb(self.obj)
    end
    client.obj.AddEvent_PACKED = function(self, ctx, param)
    end
    fpga_test.get_instance():generate_fpga_self_test_event(1, 'ExpBoard1')
    lu.assertEquals(fpga_test.get_instance().event_status, -1)
    client.ForeachEventsObjects = origin_fun
    client.obj = nil
end

function TestFPGAFlow:test_add_event_fail()
    fpga_test.get_instance().event_status = -1
    local origin_fun = client.ForeachEventsObjects
    client.obj = {path = '/bmc/kepler/Systems/1/Events'}
    client.ForeachEventsObjects = function(self, cb)
        cb(self.obj)
    end
    local event_obj = {}
    event_obj.unpack = function()

    end
    client.obj.AddEvent_PACKED = function(self, ctx, param)
        error("mock add event failed")
    end
    fpga_test.get_instance():generate_fpga_self_test_event(1, 'ExpBoard1')
    lu.assertEquals(fpga_test.get_instance().event_status, -1)
    client.ForeachEventsObjects = origin_fun
    client.obj = nil
end

return TestFPGAFlow
