-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local npu_board = require 'unit_manager.class.unit.acu.npu_board'
local event = require 'infrastructure.event'
local lu = require 'luaunit'
local i3c = require 'protocol.i3c'
local mdb = require 'mc.mdb'

TestNpuBoard = {}

function TestNpuBoard:test_init_npu_board_health()
    event.get_latest_alarm_list = function()
        return true, {
            {
                ['EventName'] = 'SoCBoardMinorAlarm',
                ['ComponentName'] = 'NpuBoard1',
                ['MessageArgs'] = '["NpuBoard1", "", "", "Error Code: ", "0x80000001"]'
            }
        }
    end
    npu_board.mds_obj = {
        ['DeviceName'] = 'NpuBoard1'
    }
    npu_board:init_npu_board_health()
    lu.assertEquals(npu_board.health, 1)
    lu.assertEquals(npu_board.assert, 1)
    lu.assertEquals(npu_board.fault_code, '0x80000001')

    event.get_latest_alarm_list = function()
        return true, {
            {
                ['EventName'] = 'SoCBoardMinorAlarm',
                ['ComponentName'] = 'NpuBoard1',
                ['MessageArgs'] = '["NpuBoard1", "", "", "Error Code: ", ""]'
            }
        }
    end
    npu_board:init_npu_board_health()
    lu.assertEquals(npu_board.health, 0)
    lu.assertEquals(npu_board.assert, 0)
    lu.assertEquals(npu_board.fault_code, '')
end

function TestNpuBoard:test_generate_npuboard_event()
    local params = {
        ['assert'] = 1,
        ['fault_code'] = '0x80000001, 0x80000002, 0x80000003',
        ['health'] = 1
    }
    npu_board.mds_obj = {
        ['DeviceName'] = 'NpuBoard1',
        ['Name'] = 'IT23MBT23'
    }
    event.generate_event = function()
        return true
    end
    npu_board:generate_npuboard_event(params)
    lu.assertEquals(npu_board.health, 1)
    lu.assertEquals(npu_board.assert, 1)
    lu.assertEquals(npu_board.fault_code, '0x80000001, 0x80000002, 0x80000003')
end

function TestNpuBoard:test_monitor_npu_board_health()
    i3c.get_npu_board_health = function()
        return {
            ['health'] = 1,
            ['count'] = 1
        }
    end
    i3c.get_npuboard_error_code = function()
        return '0x80000001'
    end
    npu_board.get_prop = function(prop)
        return {
            ['path'] = '/bmc/kepler/Chip/Complex/Chip_0101'
        }
    end
    mdb.get_object = function()
        return {
            ['LockStatus'] = 0
        }
    end
    event.generate_event = function()
        return true
    end
    npu_board.health = 0
    npu_board.assert = 0
    npu_board.fault_code = ''
    npu_board:monitor_npu_board_health(i3c)
    lu.assertEquals(npu_board.health, 1)
    lu.assertEquals(npu_board.assert, 1)
    lu.assertEquals(npu_board.fault_code, '0x80000001')

    -- 告警码变化 
    i3c.get_npuboard_error_code = function()
        return '0x80000001, 0x80000002, 0x80000003'
    end
    npu_board:monitor_npu_board_health(i3c)
    lu.assertEquals(npu_board.health, 1)
    lu.assertEquals(npu_board.assert, 1)
    lu.assertEquals(npu_board.fault_code, '0x80000001, 0x80000002, 0x80000003')

    -- 健康状态变化
    i3c.get_npu_board_health = function()
        return {
            ['health'] = 2,
            ['count'] = 1
        }
    end
    npu_board:monitor_npu_board_health(i3c)
    lu.assertEquals(npu_board.health, 2)
    lu.assertEquals(npu_board.assert, 1)
    lu.assertEquals(npu_board.fault_code, '0x80000001, 0x80000002, 0x80000003')

    i3c.get_npu_board_health = function()
        return {
            ['health'] = 0,
            ['count'] = 0
        }
    end
    npu_board:monitor_npu_board_health(i3c)
    lu.assertEquals(npu_board.health, 0)
    lu.assertEquals(npu_board.assert, 0)
    lu.assertEquals(npu_board.fault_code, '')
end

