-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local iic_process = require 'unit_manager.class.logic_fw.upgrade.iic_process'
local mc_utils = require 'mc.utils'
local file_sec = require 'utils.file'
local skynet = require 'skynet'
local vos = require 'utils.vos'
local defs = require 'unit_manager.class.logic_fw.comm_defs'

TestIICProcess = {}

function mock_plug() 
    return 0 
end

local fw_anlu_1 = {
    smc_chip = {["bmc.kepler.Chip.BlockIO"] = {
            Read = function()
                return '\x03\x00\x01\x01' -- i2c模式+anlu
            end
        }
    },
    i2c_upgrade_chip = {
        PluginRequest=mock_plug,
        Write = function() end
    },
    position = "123456"
}


local function get_filedata()
    local len = 0x38800 + 1024
    local data = string.rep("a", len)
    return data
end

local fw_pango = {
    smc_chip = {["bmc.kepler.Chip.BlockIO"] = {
            Read = function()
                return '\x03\x00\x02\x01' -- i2c模式+pango
            end
        }
    },
    i2c_upgrade_chip = {
        PluginRequest=mock_plug,
        Write = function() end
    },
    position = "123456"
}

local fw_pango_1 = {
    smc_chip = {["bmc.kepler.Chip.BlockIO"] = {
            Read = function()
                return '\x03\x00\x02\x01' -- i2c模式+pango
            end
        }
    },
    i2c_upgrade_chip = {
        PluginRequest=mock_plug,
        Write = function()
            if cmd == 0x20 then
                error("write fail")
            end
        end
    },
    position = "123456"
}

function TestIICProcess:setupClass()
    ori_open_s = file_sec.open_s
    ori_close = mc_utils.close
    ori_get_file_accessible = vos.get_file_accessible

    file_sec.open_s = function ()
        return {read=function () return 0 end}
    end
    mc_utils.close = function ()
        return 'test'
    end
    vos.get_file_accessible = function(file_path)
        if file_path == '/dev/shm/upgrade/Firmware' then
            return true
        end
        return false
    end
end

function TestIICProcess:teardownClass()
    --recover function
    file_sec.open_s = ori_open_s
    mc_utils.close = ori_close
    if ori_get_file_accessible then
        vos.get_file_accessible = ori_get_file_accessible
    end
end

function TestIICProcess:test_iic_upgrade_cpld_anlu()
    local ret = iic_process.i2c_load_cpld(fw_anlu_1, '/tmp', _, _, _)
    lu.assertEquals(ret, 0)
end

function TestIICProcess:test_iic_upgrade_cpld_pango()
    mc_utils.close = get_filedata
    local ret = iic_process.i2c_load_cpld(fw_pango, '/tmp', _, _, _)
    lu.assertEquals(ret, 0)
end

function TestIICProcess:test_iic_upgrade_cpld_pango_1()
    mc_utils.close = get_filedata
    local ret = iic_process.i2c_load_cpld(fw_pango_1, '/tmp', _, _, _)
    lu.assertEquals(ret, 0)
end

-- 测试iic_upgrade_cpld函数，当没有匹配的组件时返回MATCH_FAIL (覆盖line 361)
function TestIICProcess:test_iic_upgrade_cpld_no_match_component()
    local db = {}
    local fw_list = {
        {
            system_id = 1,
            uid = 100,
            name = 'test_fw'
        }
    }
    local cfg_list = {
        {
            name = 'Firmware',
            uid = 200,  -- 不匹配的UID
            check_fw_uid_exist = function(fw)
                return false  -- 返回false，导致没有匹配的组件
            end
        }
    }
    local file_path = '/dev/shm/upgrade/Firmware'
    local system_id = 1
    local firmware_type = 0
    local parameters = {}

    local ret, is_need_valid = iic_process:iic_upgrade_cpld(db, fw_list, cfg_list, file_path, system_id, firmware_type, parameters)
    lu.assertEquals(ret, defs.RET.MATCH_FAIL)
    lu.assertEquals(is_need_valid, false)
end

return TestIICProcess