-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local cfg = require 'unit_manager.class.logic_fw.upgrade.fw_cfgs'
local fpga_package = require 'unit_manager.class.logic_fw.fpga.fpga_package'
local fw_mgmt_client = require 'general_hardware.client'
local fpga_upgrade = require 'unit_manager.class.logic_fw.fpga.fpga_upgrade'

TestFpgaUpgrade = {}

function TestFpgaUpgrade.test_prepare_upgrade()
    local temp_get_cfg_list = cfg.get_cfg_list
    local temp_cache_fpga_hpm = fpga_package.cache_fpga_hpm
    local temp_fw_mgmt_client = fw_mgmt_client.UpdateServiceUpdateServicePrepareReply
    local fpga_signal = {
        fw_list = {
            [1] = {
                name = 'TestBoard CPLD',
                get_fw_version = function ()
                    return '1.0'
                end
            },
            [2] = {
                name = 'TestBoard FPGA',
                get_fw_version = function ()
                    return '2.0'
                end
            }
        }
    }

    local ret_version = '0.0'

    cfg.get_cfg_list = function()
        return {
            {
                name = "Firmware1",
                check_fw_uid_exist = function(fw)
                    return true
                end,
                supplier_mode = 2,        -- 多厂商模式
                cold_valid_list = { 1, 2 }, -- 冷升级列表
                hot_valid_list = {},
                chip_num = 2
            }
        }
    end
    fpga_package.cache_fpga_hpm = function()
        return
    end
    fw_mgmt_client.UpdateServiceUpdateServicePrepareReply =
        function(fw_mgmt_client, ctx, system_id, firmware_type, version, ret, parameters)
            ret_version = version
        end

    fpga_upgrade.prepare_upgrade(fpga_signal, 0, 'FPGA', nil, nil, nil)
    lu.assertEquals(ret_version, '2.0')

    cfg.get_cfg_list = temp_get_cfg_list
    fpga_package.cache_fpga_hpm = temp_cache_fpga_hpm
    fw_mgmt_client.UpdateServiceUpdateServicePrepareReply = temp_fw_mgmt_client
end