-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

loadfile(os.getenv('CONFIG_FILE'), 't', {package = package, os = os})()
package.path = './test_utils/?.lua;' .. package.path

local utils = require 'utils.core'
local logging = require 'mc.logging'
local current_file_dir = debug.getinfo(1).source:match('@?(.*)/')
utils.chdir(current_file_dir)
logging:setPrint(nil)
logging:setLevel(logging.INFO)

local lu = require('luaunit')

require 'protocol.test_smbus_5902'
require 'protocol.test_smbus_M88RT51632'
require 'protocol.test_std_smbus'
require 'sr_upg_service'
require 'vrd_manager'
require 'dpu_service'
require 'maintenance_service'
require 'test_progress_statistics'
require 'test_upgrade_service_subject'
require 'mcu'
require "retimer_service"
require 'unit_manager.test_unit_manager'
require 'gpu_service'
require 'npu_service'
require 'test_security_module.test_security_object'
require "dpu_service.test_dpu_object"
require "dpu_service.test_dpu_service"
require 'retimer.agent.test_retimer_agent_CS81532_utils'
require 'protocol.test_smbus_CS81532'
require 'retimer.test_retimer_upg_service'
require 'retimer.test_retimer_upg_base'
require 'retimer.test_retimer_base'
require "device_mgmt"
require 'vrd'
require 'metric_collect'
require 'general_hardware_release.test_release_command'
require 'protocol.test_i3c'
require 'unit_manager.class.unit.acu.test_npu_board'
require 'test_common_ipmi'
require 'unit_manager'
os.exit(lu.LuaUnit.run())
