-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
--         http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local agent = require 'retimer.agent.retimer_agent_5902l'

TestRetimerAgent5902 = {}

-- 测试读取失败，温度设置为默认值的用例
function TestRetimerAgent5902:test_retimer_monitor_read_fail()
    local retimer = {
        name = "retimer",
        retimer = {
            retimer_obj = {
                RefChip = {},
                ['FirmwareVersion'] = "N/A",
                ['TemperatureCelsius'] = 61,
                ['DieID'] = 0,
            }
        },
        protocol = {}
    }

    retimer.protocol.write = function()
        return true, 0x068EB00F
    end

    retimer.protocol.read = function(obj, length)
        if length == 64 then
            return false, false
        end
        if length == 2 then
            return false, false
        end
        return true, 0x068EB006068EB006068EB006068E1234
    end
    agent:update_retimer_info(retimer)
    lu.assertEquals(retimer.retimer.retimer_obj['TemperatureCelsius'], 0)
end
