-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local std_smbus = require 'protocol.std_smbus'
local mc_utils = require 'mc.utils'
local file_sec = require 'utils.file'
local skynet = require 'skynet'
local lu = require 'luaunit'

local LENGTH<const> = 20
local STATUS_DATA<const> = 5

TestStdSmbus = {}


function TestStdSmbus:test_SetLLDPStatus()
    std_smbus._send_and_receive_request_in_frames = function()
        return "\x01\x02"
    end
    local ret = std_smbus:SetLLDPStatus(STATUS_DATA)
    lu.assertEquals(ret, "\x01\x02")
end

function TestStdSmbus:test_GetLLDPStatus()
    std_smbus._send_and_receive_request_in_frames = function()
        return "\x01\x02"
    end
    std_smbus.buffer_len = LENGTH
    local ret = std_smbus:GetLLDPStatus()
    lu.assertEquals(ret.type, 1)
    lu.assertEquals(ret.status, 2)
end

function TestStdSmbus:test_UpgradeFirmware()
    local ori_open_s = file_sec.open_s
    local ori_close = mc_utils.close
    local ori_skynet = skynet

    local chip = {PluginRequest=function() return 0 end}
    local smbus = std_smbus.new(chip, LENGTH)
    file_sec.open_s = function ()
        return {read=function () return 0 end}
    end
    mc_utils.close = function ()
        return 'test'
    end
    skynet.packstring = function ()
        return 0
    end
    skynet.unpack = function ()
        return 0
    end
    local ret = smbus:UpgradeFirmware('/testPath/',0,10,0,0,0,0,nil)
    lu.assertEquals(ret, true)
    local ret = smbus:UpgradeFirmware('/testPath/',0,10,0,0,0,0,1)
    lu.assertEquals(ret, true)

    --recover function
    file_sec.open_s = ori_open_s
    mc_utils.close = ori_close
    skynet = ori_skynet
end

function TestStdSmbus:test_WriteProtext()
    local std_smbus_obj = std_smbus.new({}, 0)
    std_smbus_obj.send_and_receive = function()
        local recv_data = {}
        recv_data.length = 2
        recv_data.data = '\x01\x02'
        recv_data.total_length = 2
        return recv_data
    end
    local ret = std_smbus_obj:WriteProtext(0)
    lu.assertEquals(ret, "\x01\x02")
end

function TestStdSmbus:test_GetBiosLogLevel()
    std_smbus.buffer_len = LENGTH
    std_smbus._send_and_receive_request_in_frames = function()
        return '\x01'
    end
    local ret = std_smbus:GetBiosLogLevel('\x01')
    lu.assertNotEquals(ret, nil)
    lu.assertEquals(ret.level, 1)
end

function TestStdSmbus:test_GetPxeOption()
    std_smbus._send_and_receive_request_in_frames = function()
        return '\x04\x06'
    end
    local ret = std_smbus:GetPxeOption()
    lu.assertNotEquals(ret, nil)
    lu.assertEquals(ret.pxe_option, 6)
end