-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local i3c = require 'protocol.i3c'
local lu = require 'luaunit'

TestI3c = {}

function TestI3c:test_get_npu_board_health()
    -- 读报错
    local chip = {
        Read = function()
            error('read error')
        end
    }
    local health_info = i3c.get_npu_board_health(chip)
    lu.assertEquals(health_info, nil)
    -- 读成功
    chip = {
        Read = function()
            return string.pack('I1I2I2', 0XA3, 0, 0)
        end
    }
    health_info = i3c.get_npu_board_health(chip)
    lu.assertEquals(health_info.health, 0)
    lu.assertEquals(health_info.count, 0)
    -- 读成功
    chip = {
        Read = function()
            return string.pack('I1I2I2', 0XA3, 1, 256)
        end
    }
    health_info = i3c.get_npu_board_health(chip)
    lu.assertEquals(health_info.health, 1)
    lu.assertEquals(health_info.count, 70)
end

function TestI3c:test_get_npuboard_error_code()
    -- 读报错
    local chip = {
        Read = function()
            error('read error')
        end
    }
    local health_info = {
        ['count'] = 4
    }
    local error_code = i3c.get_npuboard_error_code(chip, health_info)
    lu.assertEquals(error_code, nil)
    -- 读成功，单帧告警码
    chip = {
        Read = function(obj, context, offset, len)
            if offset == 0x0404190f then
                return string.pack('I1I4I4I4I4', 0xA3,
                    0x80000001, 0x80000002, 0x80000003, 0x80000004)
            end
        end
    }
    error_code = i3c.get_npuboard_error_code(chip, health_info)
    lu.assertEquals(error_code, '0x80000001, 0x80000002, 0x80000003, 0x80000004')
    -- 多帧告警码
    chip = {
        Read = function(obj, context, offset, len)
            if offset == 0x0404190f then
                return string.pack('I1I4I4I4I4', 0xA3,
                    0x80000001, 0x80000002, 0x80000003, 0x80000004)
            end
            if offset == 0x0314190f then
                return string.pack('I1I4I4I4', 0xA3,
                    0x80000005, 0x06, 0x80000007)
            end
        end
    }
    health_info = {
        ['count'] = 7
    }
    error_code = i3c.get_npuboard_error_code(chip, health_info)
    lu.assertEquals(error_code, '0x80000001, 0x80000002, 0x80000003, 0x80000004, 0x80000005, 0x06, 0x80000007')
end
