-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local unit_manager = require 'unit_manager.unit_manager'
local ipmi = require 'ipmi'
local lu = require 'luaunit'

TestNpuPowerCap = {}

function TestNpuPowerCap:test_set_npu_power_cap()
    local ipmi_request_mock = ipmi.request
    ipmi.request = function ()
        local res = 0
        local payload = '\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x00\x84\x03\x00\x00\xe8\x03\x00\x00'
        return res, payload
    end
    local unit_mgr = unit_manager.new()
    local obj = {
        BusType = 1,
        Slot = 1,
        PowerCapWatts = 0,
        MaxPowerCapWatts = 0
    }
    local npu_board_1 = {
        get_prop = function (_, prop)
            return obj[prop]
        end,
        set_prop = function (_, prop, value)
            if not obj[prop] then
                error()
            end
            obj[prop] = value
        end
    }
    unit_mgr.npu_boards = {npu_board_1}

    local configs = {{NpuId = 255, Power = 100}}
    local result = unit_mgr:set_npu_power_cap(_, _, configs)
    lu.assertEquals(result, {255})

    obj.BusType = 2
    result = unit_mgr:set_npu_power_cap(_, _, configs)
    lu.assertEquals(result, {255})

    obj.PowerCapReduce = 0
    result = unit_mgr:set_npu_power_cap(_, _, configs)
    lu.assertEquals(obj.PowerCapReduce, 100)
    lu.assertEquals(obj.PowerCapWatts, 900)
    lu.assertEquals(obj.MaxPowerCapWatts, 1000)
    lu.assertEquals(result, {})

    ipmi.request = ipmi_request_mock
end