-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local npu_board = require 'unit_manager.class.unit.acu.npu_board'
local c_unit = require 'unit_manager.class.unit.unit'
local utils = require 'mc.utils'
local file_sec = require 'utils.file'
local i3c = require 'protocol.i3c'
local lu = require 'luaunit'
local _, skynet = pcall(require, 'skynet')

TestNpu = {}

function TestNpu:test_npu_log()
    local true_func = function(...)
        return 0
    end
    local false_func = function(...)
        return -1
    end

    local mkdir = utils.mkdir_with_parents
    local check_realpath = file_sec.check_realpath_before_open_s
    utils.mkdir_with_parents = true_func

    -- test on_dump_mcu_log_cb 行206
    file_sec.check_realpath_before_open_s = true_func
    npu_board.mds_obj = {
        DeviceName = 'test',
        Name = 'test'
    }
    local ok = pcall(function ()
        return npu_board:on_dump_mcu_log_cb()
    end)
    lu.assertEquals(ok, true)
    -- test on_dump_mcu_log_cb 行200
    file_sec.check_realpath_before_open_s = false_func
    local ok = pcall(function ()
        return npu_board:on_dump_mcu_log_cb()
    end)
    lu.assertEquals(ok, true)

    file_sec.check_realpath_before_open_s = check_realpath
    utils.mkdir_with_parents = mkdir
end

function TestNpu:test_i3c_channel()
    local data = string.pack('L', 0)
    local chip = {
    }
    local ok, result = pcall(function ()
        return i3c.chip_blkwrite(nil, 0x00004100, data)
    end)
    lu.assertEquals(ok, true)
    lu.assertEquals(result, nil)

    ok = pcall(function ()
        i3c.chip_blkwrite(chip, 0x00004100, data)
    end)
    lu.assertEquals(ok, false)

    local date
    ok, date = pcall(function ()
        return i3c.chip_blkread(nil, 0x00004100, 1)
    end)
    lu.assertEquals(ok, true)
    lu.assertEquals(date, nil)

    ok = pcall(function ()
        i3c.chip_blkread(chip, 0x00004100, 1)
    end)
    lu.assertEquals(ok, false)

    chip = {
        PluginRequest = function ()
        end
    }

    local packstring = skynet.packstring
    skynet.packstring = function ()
    end

    ok = pcall(function ()
        i3c.chip_blkwrite(chip, 0x00004100, data)
    end)
    lu.assertEquals(ok, true)

    local unpack = skynet.unpack
    skynet.unpack = function ()
        return '\x61\x62\x63'
    end

    ok, date = pcall(function ()
        return i3c.chip_blkread(chip, 0x00004100, 3)
    end)
    lu.assertEquals(ok, true)
    lu.assertEquals(date, 'abc')
    skynet.packstring = packstring
    skynet.unpack = unpack
end

function TestNpu:test_update_dump_info()
    local bus_type = 2
    local obj = {
        ['RefSMCChip'] = {},
        ['CurrentUpgradeStatus'] = 0
    }
    local init = c_unit.init
    c_unit.init = function ()
    end
    local npu_board_obj = npu_board.new({}, obj, 1, {})
    i3c.chip_blkwrite = function ()
    end
    i3c.chip_blkread = function (chip, cmd, length)
        if length == 4 then
            return '\x01\x01\x00\x00'
        else
            return '\x00\x00\x00\x00\x61'
        end
    end
    npu_board_obj.update_dump_data = function (_, print_data)
        if print_data ~= 'a' then
            error()
        end
    end

    local ok = pcall(function ()
        npu_board_obj:update_dump_info('npu_log', '', bus_type)
    end)
    lu.assertEquals(ok, true)
    c_unit.init = init
end