-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local utils = require 'mc.utils'
local parser_cfg = require 'mcu.upgrade.parser_cfg'
local cmn = require 'common'

TestSaveCfg = {}

-- 打桩模拟升级文件cfg数据
local cfgs = {
        name = "Vrd",
        ComponentId = 23,
        ComponentIdex = 125,
        uid_list = {'00000001020302056876','0000000102030205704'}
}

-- 打桩模拟数据库中数据
local vrd = {
    Id = "Vrd",
    ComponentId = 23,
    ComponentIdex = 125,
    save = function()
        return true
    end
}

-- 打桩模拟mcu对象中数据库
local mcu_upgrade_service = {
    db = {
        FwUpdateCfgTable = function(info)
            return vrd
        end
    }
}

-- 测试vrd升级完成后向数据库中缓存数据
function TestSaveCfg:test_save_cfg()
    local ok = pcall(parser_cfg.save_cfg, mcu_upgrade_service, cfgs)
    lu.assertEquals(ok, true)
    lu.assertEquals(vrd.Uid, "00000001020302056876,0000000102030205704")
end

local DATA_PATH <const> = './test_data/mcu/'
-- Test cases for is_support_multifirmware function
function TestParserCfg:test_is_support_multifirmware_multiple_mode()
    local cfg_path = DATA_PATH .. 'update_multifirmware.cfg'
    local result = cmn.is_support_multifirmware(utils.realpath(cfg_path))
    lu.assertEquals(result, true)
end

function TestParserCfg:test_is_support_multifirmware_single_mode()
    local cfg_path = DATA_PATH .. 'update_single.cfg'
    local result = cmn.is_support_multifirmware(utils.realpath(cfg_path))
    lu.assertEquals(result, false)
end

function TestParserCfg:test_is_support_multifirmware_no_firmware_mode()
    local cfg_path = DATA_PATH .. 'update_no_firmware_mode.cfg'
    local result = cmn.is_support_multifirmware(utils.realpath(cfg_path))
    lu.assertEquals(result, false)
end

function TestParserCfg:test_is_support_multifirmware_original_config()
    -- Test case: Original config file without FirmwareMode - should return false
    local cfg_path = DATA_PATH .. 'update.cfg'
    local result = cmn.is_support_multifirmware(utils.realpath(cfg_path))
    lu.assertEquals(result, false)
end