-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local lu = require 'luaunit'
local fructl = require 'mcu.upgrade.fructl_handler'

TestFructrlHandler = {}

function TestFructrlHandler:test_set_chassis_power_state()
    local obj = {
        pcall = {
            PowerCtrl = function () return true end
        }
    }
    fructl.get_chassis_fructl_obj = function ()
        return obj
    end
    local ret = fructl.set_chassis_power_state(bus, 1, 'OFF', 'Unknown')
    lu.assertEquals(ret, true)

    fructl.get_chassis_fructl_obj = function ()
        return
    end
    ret = fructl.set_chassis_power_state(bus, 1, 'OFF', 'Unknown')
    lu.assertEquals(ret, nil)
end