-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local lu = require 'luaunit'
local test_utils = require 'mc.utils'
local test_file_sec = require 'utils.file'
local test_main_service = require 'maintenance_service.maintenance_csr'
local client = require 'general_hardware.client'
local test_vos = require 'utils.vos'
local test_cfg = require 'unit_manager.class.logic_fw.upgrade.fw_cfgs'
local test_mdb = require 'mc.mdb'
local test_bs = require 'mc.bitstring'
local test_core = require 'utils.core'
local sr_upg_service = require 'sr_upg_service.sr_upg_service'
local test_bs_header = test_bs.new([[<<
    standard_code:12/string,
    spec_version:8,
    elabel_offset:16,
    sys_desc_offset:16,
    inner_area_offset:16,
    psr_offset:16,
    csr_offset:16,
    digital_sign_offset:16,
    _:73/string,
    sr_version:2/string,
    component_uid:24/string,
    verification_code:4/string
>>]])

TestMaintenance = {}

local connector_name = "Connextor_CLU_1_0101"
local file_path = 'test'
local ctx = {}
ctx.get_initiator = function()
    return {}
end

local import_task = test_main_service.import_csr_task
test_main_service.import_csr_task = function (...)
    return true
end

function TestMaintenance:TestImportPathFalse()
    test_main_service:init()
    local pre_fun = test_utils.realpath
    local pre_fun_name_s = test_utils.get_file_name_s
    test_utils.realpath = function ()
        return error("path is nil")
    end
    test_file_sec.get_file_name_s =function ()
        return 'real_path.txt'
    end
    local data_first_byte = test_main_service:import_csr(self.construct_ctx, connector_name, file_path)
    lu.assertEquals(data_first_byte, 1)
    test_utils.realpath = pre_fun
    test_utils.get_file_name_s = pre_fun_name_s
end

function TestMaintenance:TestImportPathTrue()
    test_main_service:init()
    local pre_fun = test_utils.realpath
    local pre_fun_name_s = test_utils.get_file_name_s
    local pre_fun_realpath_before = test_file_sec.check_realpath_before_open_s
    test_utils.realpath = function ()
        return '/tmp/real_path.txt'
    end
    test_file_sec.get_file_name_s =function ()
        return 'real_path.txt'
    end
    test_file_sec.check_realpath_before_open_s =function (...)
        return 0
    end

    local data_first_byte = test_main_service:import_csr(ctx, connector_name, file_path)
    lu.assertEquals(data_first_byte, 1)
    test_utils.realpath = pre_fun
    test_utils.get_file_name_s = pre_fun_name_s
    test_file_sec.check_realpath_before_open_s = pre_fun_realpath_before

end

function TestMaintenance:TestImportPathTrueflag()
    test_main_service:init()
    local pre_fun = test_utils.realpath
    local pre_fun_name_s = test_utils.get_file_name_s
    local pre_fun_realpath_before = test_file_sec.check_realpath_before_open_s
    test_utils.realpath = function ()
        return '/t/ok'
    end
    test_file_sec.get_file_name_s =function ()
        return 'path.txt'
    end
    test_file_sec.check_realpath_before_open_s =function (...)
        return 1
    end
    local data_first_byte = test_main_service:import_csr(ctx, connector_name, file_path)
    lu.assertEquals(data_first_byte, nil)
    test_utils.realpath = pre_fun
    test_utils.get_file_name_s = pre_fun_name_s
    test_file_sec.check_realpath_before_open_s = pre_fun_realpath_before
end

function TestMaintenance:TestProcessPackageInfo()
    test_main_service:init()
    local client_func = client.UpdateServiceUpdateServiceParseFirmwarePackage
    local check_shell = test_file_sec.check_shell_special_character_s
    test_file_sec.check_shell_special_character_s = function(...)
        return -1
    end
    client.UpdateServiceUpdateServiceParseFirmwarePackage = function(...)
        return {FirmwareDirectory = 'test'}
    end
    ok = pcall(import_task, test_main_service, ctx, nil, file_path, nil)
    lu.assertEquals(ok, true)
    client.UpdateServiceUpdateServiceParseFirmwarePackage = client_func
    test_file_sec.check_shell_special_character_s = check_shell
end

function TestMaintenance:TestRequireTraceFail()
    local pre_fun = test_main_service.init
    test_main_service.init = function(self)
        self.tracer = nil
    end
    test_main_service:init()
    local client_func = client.UpdateServiceUpdateServiceParseFirmwarePackage
    local check_shell = test_file_sec.check_shell_special_character_s
    test_file_sec.check_shell_special_character_s = function(...)
        return -1
    end
    client.UpdateServiceUpdateServiceParseFirmwarePackage = function(...)
        return {FirmwareDirectory = 'test'}
    end
    ok = pcall(import_task, test_main_service, ctx, nil, file_path, nil)
    lu.assertEquals(ok, true)
    client.UpdateServiceUpdateServiceParseFirmwarePackage = client_func
    test_file_sec.check_shell_special_character_s = check_shell
    test_main_service.init = pre_fun
end

function TestMaintenance:TestClearData()
    test_main_service:init()
    local client_func = client.UpdateServiceUpdateServiceParseFirmwarePackage
    local check_shell = test_file_sec.check_shell_special_character_s
    local pre_read_file_s = test_file_sec.read_file_s
    local pre_open_s = test_file_sec.open_s
    local pre_get_cfg_list = test_cfg.get_cfg_list
    local pre_get_file_accessible = test_vos.get_file_accessible
    local pre_system_s = test_vos.system_s
    local pre_get_object = test_mdb.get_object
    local pre_inflate = test_core.inflate
    test_file_sec.check_shell_special_character_s = function(...)
        return 0
    end
    client.UpdateServiceUpdateServiceParseFirmwarePackage = function(...)
        return {FirmwareDirectory = 'test'}
    end
    test_cfg.get_cfg_list = function(...)
        return {{name = 'test'}}
    end
    test_vos.get_file_accessible = function(...)
        return true
    end
    test_vos.system_s = function(...)
        return 0
    end
    test_mdb.get_object = function(...)
        return {
            pcall = {
                Reload = function(...)
                    return
                end
            },
            Id = '1825',
            GroupPosition = '0101'
        }
    end
    test_file_sec.read_file_s = function(...)
        return '1825'
    end
    test_file_sec.open_s = function(...)
        return {
            read = function(...)
                return test_bs_header:pack({
                    standard_code = 1,
                    spec_version = 1,
                    digital_sign_offset = 1,
                    sr_version = 1,
                    component_uid = 1825,
                    verification_code = 1,
                    sys_desc_offset = 1,
                    elabel_offset = 1,
                    psr_offset = 1,
                    csr_offset = 1,
                    inner_area_offset = 1
                })
            end,
            seek = function(...)
                return ""
            end,
            close = function(...)
                return
            end,
            write = function(...)
                return
            end
        }
    end
    test_core.inflate = function(...)
        return ""
    end
    sr_upg_service.get_instance().sr_upgrade_list = {
        {
            position = '0101',
            mds_obj = {
                UID = '1825'
            }
        }
    }
    local test_main_csr = require 'maintenance_service.maintenance_csr'
    test_main_csr:init()
    ok = pcall(import_task, test_main_csr, ctx, 'Connector_BCU_01', file_path, nil)
    lu.assertEquals(ok, true)
    client.UpdateServiceUpdateServiceParseFirmwarePackage = client_func
    test_file_sec.check_shell_special_character_s = check_shell
    test_cfg.get_cfg_list = pre_get_cfg_list
    test_vos.get_file_accessible = pre_get_file_accessible
    test_vos.system_s = pre_system_s
    test_mdb.get_object = pre_get_object
    test_file_sec.read_file_s = pre_read_file_s
    test_file_sec.open_s = pre_open_s
    test_core.inflate = pre_inflate
end