-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local gpu_object = require 'gpu_service.gpu_object'
local lu = require 'luaunit'

TestGpu = {}

local obj = {
    Slot = '1',
    SerialNumber = '1111111111111111',
    CardFirmwareVersion = '1.0.0',
    Manufacturer = 'ODM',
    CardPartNumber = '222222222222222',
    Model = 'Model1',
    SN = '1111111111111111',
    FirmwareVersion = '1.0.0',
    InventorySerialNumber = '1111111111111111',
    InventoryFirmwareVersion = '1.0.0',
    PartNumber = '1.0.0'
}

function TestGpu:testinit()
    local gpu_object = gpu_object.new(obj)
    gpu_object:init()
    gpu_object:init_gpu_property()
    lu.assertEquals(gpu_object.gpu.AssetType, 'PCIe GPU Card')
    lu.assertEquals(gpu_object.gpu.AssetName, 'GPU' .. obj.Slot)
    lu.assertEquals(gpu_object.gpu.InventoryFirmwareVersion, obj.CardFirmwareVersion)
    lu.assertEquals(gpu_object.gpu.PCBVersion, 'N/A')
    lu.assertEquals(gpu_object.gpu.InventoryManufacturer, obj.Manufacturer)
    lu.assertEquals(gpu_object.gpu.AssetTag, 'N/A')
    lu.assertEquals(gpu_object.gpu.InventoryPartNumber, obj.CardPartNumber)
    lu.assertEquals(gpu_object.gpu.ManufactureDate, 'N/A')
    lu.assertEquals(gpu_object.gpu.InventorySlot, obj.Slot)
    lu.assertEquals(gpu_object.gpu.InventoryModel, obj.Model)
end

function TestGpu:test_set_prop()
    local gpu_object = gpu_object.new(obj)
    gpu_object:set_prop('SN', '1234')
    gpu_object:set_prop('FirmwareVersion', '1.2.3')
    gpu_object:set_prop('PartNumber', '')
    lu.assertEquals(gpu_object.gpu.InventorySerialNumber, '1234')
    lu.assertEquals(gpu_object.gpu.InventoryFirmwareVersion, '1.2.3')
    lu.assertEquals(gpu_object.gpu.PartNumber, 'Unknown')
end