-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local lu = require 'luaunit'
local dpu_service = require 'dpu_service.dpu_service'
local client = require 'general_hardware.client'
local utils = require 'dpu_service.utils'
local dpu_upgrade_object = require 'dpu_service.dpu_upgrade_object'
local g_process_res
local STATUS_SUC<const> = 3

TestDpuUpgrade = {}

local function stub_dpu_service_info(stub_name)
    client.UpdateServiceUpdateServiceProcessReply = function(_, _, _, _, result, parameters)
        g_process_res = result
    end
    client.PFileFileChown = function()
        return true
    end
    dpu_service.upgrade_task = function()
        return true
    end
    dpu_service.upgradable_cfgs = {
        name = stub_name,
        component_id = 1,
        component_id_ex = 2,
        board_id = 3
    }
end

function TestDpuUpgrade:test_cpld_upgrade()
    utils.retry_func = function(param1, param2, cb)
        return cb()
    end

    dpu_upgrade_obj = dpu_upgrade_object.new({})
    dpu_upgrade_obj.query_cpld_upgrade_status = function()
        return nil
    end
    local ret = dpu_upgrade_obj:cpld_upgrade("/path/");
    lu.assertEquals(ret, false)

    dpu_upgrade_obj.query_cpld_upgrade_status = function()
        return STATUS_SUC
    end

    dpu_upgrade_obj.std_smbus = {
        UpgradeFirmware = function()
            return false
        end
    }
    local ret = dpu_upgrade_obj:cpld_upgrade("/path/");
    lu.assertEquals(ret, false)

    dpu_upgrade_obj.std_smbus = {
        UpgradeFirmware = function()
            return true
        end
    }
    local mock1 = dpu_upgrade_obj.wait_upgrade_success 
    dpu_upgrade_obj.wait_upgrade_success = function()
        return false
    end
    local ret = dpu_upgrade_obj:cpld_upgrade("/path/");
    lu.assertEquals(ret, false)

    dpu_upgrade_obj.wait_upgrade_success = function()
        return true
    end

    dpu_upgrade_obj.std_smbus =  { 
                    VaildCpld = function ()
                        return false
                    end,
                    UpgradeFirmware = function()
                        return true
                    end
                }
    local ret = dpu_upgrade_obj:cpld_upgrade("/path/");
    lu.assertEquals(ret, false)

    dpu_upgrade_obj.std_smbus.VaildCpld = function ()
                        return true
                    end
    local mock2 = dpu_upgrade_obj.wait_valid_success
    dpu_upgrade_obj.wait_valid_success = function()
        return false
    end

    local ret = dpu_upgrade_obj:cpld_upgrade("/path/", nil, nil, nil, nil, nil, STATUS_SUC);
    lu.assertEquals(ret, false)

    dpu_upgrade_obj.wait_valid_success = function()
        return true
    end

    local ret = dpu_upgrade_obj:cpld_upgrade("/path/", nil, nil, nil, nil, nil, STATUS_SUC);
    lu.assertEquals(ret, true)

    dpu_upgrade_obj.wait_upgrade_success = mock1
    dpu_upgrade_obj.wait_valid_success = mock2
end

-- 测试dpu固件升级处理成功
function TestDpuUpgrade:test_on_upgrade_process_succ()
    stub_dpu_service_info('Firmware1')
    local ok = pcall(function()
        return dpu_service:on_upgrade_process(_, _, 'Mcu', '/dev/shm/upgrade/123456/name')
    end)

    lu.assertEquals(ok, true)
    lu.assertEquals(g_process_res, utils.DBUS_CALL_CODE.RET_OK)
end

-- 测试dpu固件升级处理失败
function TestDpuUpgrade:test_on_upgrade_process_fail()
    stub_dpu_service_info(nil)
    local ok = pcall(function()
        return dpu_service:on_upgrade_process(_, _, 'Mcu', '/dev/shm/upgrade/123456/name')
    end)

    lu.assertEquals(ok, true)
    lu.assertEquals(g_process_res, utils.DBUS_CALL_CODE.RET_ERR)
end

function TestDpuUpgrade:test_get_vrd_upgrade_status()
    local ret
    dpu_upgrade_object.std_smbus = {
        GetVrdUpgradeStatus = function()
            return {status = true}
        end
    }
    ret = dpu_upgrade_object:get_vrd_upgrade_status()
    lu.assertEquals(ret, true)

    dpu_upgrade_object.std_smbus = {}
    ret = dpu_upgrade_object:get_vrd_upgrade_status()
    lu.assertEquals(ret, nil)
end

function TestDpuUpgrade:test_wait_upgrade_success()
    dpu_upgrade_object.std_smbus = {
        GetCpldUpgradeStatus = function()
            return {status = 4}
        end
    }
    local ret = dpu_upgrade_object:wait_upgrade_success(5)
    lu.assertEquals(ret, false)

    dpu_upgrade_object.std_smbus = {
        GetCpldUpgradeStatus = function()
            return {status = 3}
        end
    }
    local ret = dpu_upgrade_object:wait_upgrade_success(5)
    lu.assertEquals(ret, true)
end

function TestDpuUpgrade:test_wait_valid_success()
    dpu_upgrade_object.std_smbus = {
        GetCpldUpgradeStatus = function()
            return {status = 4}
        end
    }
    local ret = dpu_upgrade_object:wait_valid_success(5)
    lu.assertEquals(ret, false)

    dpu_upgrade_object.std_smbus = {
        GetCpldUpgradeStatus = function()
            return {status = 0}
        end
    }
    local ret = dpu_upgrade_object:wait_valid_success(5)
    lu.assertEquals(ret, true)
end

