-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local skynet = require 'skynet'
local log = require 'mc.logging'
local fw_upgrade = require 'unit_manager.class.logic_fw.upgrade.fw_upgrade'
local fw_mgmt_client = require 'general_hardware.client'
local signal = require 'unit_manager.class.logic_fw.signal'

local active_success = false

local SYSTEM_ID = 1

-- 只新增signal相关测试，后续集成验证整合验证整个CPLD升级流程
local test_signal = {}

function test_signal.prepare_date()
    skynet.fork = function(cb)
        cb()
    end

    test_signal.old_prepare_upgrade = fw_upgrade.prepare_upgrade
    fw_upgrade.prepare_upgrade = function()
        error('prepare_upgrade unexpected error')
    end
    test_signal.old_process_upgrade = fw_upgrade.process_upgrade
    fw_upgrade.process_upgrade = function()
        error('process_upgrade unexpected error')
    end
    test_signal.old_finish_upgrade = fw_upgrade.finish_upgrade
    fw_upgrade.finish_upgrade = function()
        return true
    end

    test_signal.old_cpld_valid = fw_upgrade.cpld_valid
    fw_upgrade.cpld_valid = true

    fw_mgmt_client.FirmwareActiveFirmwareActiveUpdateActiveStatus = function()
    end

    fw_mgmt_client.UpdateServiceUpdateServiceUpdateUpgradeStatus = function()
    end
    fw_mgmt_client.PFileFileChown = function()
        return true
    end
    fw_mgmt_client.UpdateServiceUpdateServicePrepareReply = function()
        log:notice('prepare reply')
    end
    fw_mgmt_client.UpdateServiceUpdateServiceProcessReply = function()
        log:notice('process reply')
    end
    fw_mgmt_client.UpdateServiceUpdateServiceFinishReply = function()
        log:notice('finish reply')
    end

    fw_mgmt_client.FirmwareActiveFirmwareActiveActiveProcessReply = function()
        -- 生效流程进入此函数表示成功，将结果置为true
        active_success = true
    end
end

function test_signal.clear_env()
    fw_upgrade.cpld_valid = test_signal.old_cpld_valid
    fw_upgrade.prepare_upgrade = test_signal.old_prepare_upgrade
    fw_upgrade.process_upgrade = test_signal.old_process_upgrade
    fw_upgrade.finish_upgrade = test_signal.old_finish_upgrade
end

-- 测试CPLD升级生效流程
function test_signal.test_active_callback()
    signal.active_callback(_, SYSTEM_ID, 'CPLD')
    assert(active_success)
    assert(fw_upgrade.cpld_valid)
end

-- 测试CPLD升级prepare流程
function test_signal.test_upgrade_prepare_callback()
    local ok, err = pcall(signal.upgrade_prepare_callback, _, SYSTEM_ID, 'Cpld', '')
    assert(ok, err)
end

-- 测试CPLD升级process流程
function test_signal.test_upgrade_process_callback()
    local ok, err = pcall(signal.upgrade_process_callback, _, SYSTEM_ID, 'Cpld', '')
    assert(ok, err)
end

-- 测试CPLD升级finish流程
function test_signal.test_upgrade_finish_callback()
    local ok, err = pcall(signal.upgrade_finish_callback, _, SYSTEM_ID, 'Cpld')
    assert(ok, err)
end

function test_signal.main(bus)
    log:notice('================ test cpld upgrade signal start ================')
    test_signal.prepare_date()
    
    test_signal.test_upgrade_prepare_callback()
    test_signal.test_upgrade_process_callback()
    test_signal.test_upgrade_finish_callback()
    test_signal.test_active_callback()

    test_signal.clear_env()
    log:notice('================ test cpld upgrade signal finish ================')
end

return test_signal
