-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local class = require 'mc.class'
local c_seu = require 'unit_manager.class.unit.seu.seu'
local cmn = require 'common'
local log = require 'mc.logging'
local skynet = require 'skynet'

---@class HddBackplane: SEU @硬盘背板
local c_hdd_backplane = class(c_seu)

local UNIT_INTERFACE <const> = 'bmc.kepler.Systems.Board.Unit'

function c_hdd_backplane:update_start_slot(customize_sign)
    -- 没有定制化项则直接退出
    if not customize_sign.StartSlot then
        return
    end

    local device_name = self:get_prop('DeviceName')
    local slot = tonumber(device_name:match('(%d+)'))

    for _, item in pairs(customize_sign.StartSlotItems) do
        -- 只有一个硬盘背板的情况,直接保存slot为0
        if item[1] == 0 or item[1] == slot then
            self:set_prop('StartSlot', item[2], 'bmc.kepler.Systems.HddBackplane')
            log:notice('set_prop StartSlot: %s, position: %s', item[2], self.position)
            break
        end
    end
end

function c_hdd_backplane:update_slot_info(board_slot_configs)
    local error_count = 0
    local container_obj
    repeat
        container_obj = self:get_container_object()
        error_count = error_count + 1
        skynet.sleep(100)
    until container_obj or error_count > 9
    if not container_obj then
        return
    end

    for _, config in pairs(board_slot_configs) do
        if container_obj.UniqueId ~= config.mds_obj.UID then
            goto next
        end
        for _, slot_config in pairs(config.mds_obj.SlotConfigs) do
            local slot = slot_config[1]
            log:notice('container_obj.Instance: %s, config.slot: %s', container_obj.Instance, slot)
            if container_obj.Instance ~= slot then
                goto skip
            end
            local child_slot_type = slot_config[2]
            -- Type在SR文件中为固定值或未配置
            if self:get_prop('Type', UNIT_INTERFACE) ~= child_slot_type then
                goto skip
            end
            local child_slot_index = slot_config[3]
            -- Slot在SR文件中为固定值或未配置
            local index = cmn.find(child_slot_index, self:get_prop('Slot'))
            if not index then
                goto skip
            end
            -- 根据整机配置更新逻辑编号
            local child_slot_number = slot_config[4]
            if child_slot_number[index] then
                -- Number在SR文件中为固定值或未配置
                self:set_prop('Number', child_slot_number[index])
                log:notice('set_prop Number: %s', child_slot_number[index])
            end
            -- 根据整机配置更新槽位丝印 "Front" "Inner" "Rear"
            local child_slot_silk = slot_config[5]
            if child_slot_silk[index] then
                -- SilkText在SR文件中为固定值或未配置
                self:set_prop('SilkText', child_slot_silk[index])
                log:notice('set_prop SilkText: %s', child_slot_silk[index])
            end
            ::skip::
        end
        ::next::
    end
end

return c_hdd_backplane