-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 定义模块需要的通用常量和方法
local defs = {}

defs.UPGRADE_CPLD_VALID_FILE_DIR = "/data/opt/bmc/up_cfg"
-- 冷热升级valid文件分开存放
defs.HOT_UPGRADE_CPLD_VALID_FILE_DIR = "/data/opt/bmc/hot_up_cfg"

defs.UPGRADE_FPGA_TMP_PATH = '/data/backup/fpga/tmp/fpga.hpm'
defs.UPGRADE_FPGA_GOLD_PATH = '/data/backup/fpga/gold/fpga.hpm'

defs.UPGRADING_FPGA = 0  -- 0: 无FPGA升级  1: 存在FPGA升级
defs.UPGRADING_CPLD = 0  -- 0: 无CPLD升级  1: 存在CPLD升级
defs.ACTIVING_CPLD = 0   -- 0: 无CPLD生效  1: 存在CPLD生效

defs.SINGEL_SYSTEM_ID = 1
defs.ALL_SYSTEM_ID = 0xff

defs.START_RYTRY_TIME = 10  -- 启动时版本获取重试时长间隔10s
defs.RYTRY_TIME = 1         -- 非启动时版本获取重试时长间隔1s

defs.UPGRADE_FPGA_BY_SFC = 'SFC'    -- FPGA采用flash升级的方式
defs.UPGRADE_FPGA_BY_JTAG = 'JTAG'  -- FPGA采用jtag升级的方式
defs.FPGA_MUX = 0     -- cpld选通至FPGA侧
defs.UPGRADE_MUX = 1  -- cpld选通至BMC侧
defs.ACTIVE_MUX = 1   -- 触发FPGA生效
defs.VALID_ACTION = {
    VALID_ACTION_DEFAULT = 0,     -- 默认值为0，AC重启
    SUPPORT_AC_RESET_ACTIVE = 1,  -- 生效完CPLD后进行AC重启
    SUPPORT_BMC_RESET_ACTIVE = 2, -- 生效完CPLD后进行BMC重启
    SUPPORT_NO_RESET_ACTIVE = 3   -- 不执行任何重启操作
}

defs.VALID_CONDITION = {
    POWER_OFF = 0,            -- 下电生效
    POWER_CYCLE = 1,          -- 电源循环生效
    CHASSIS_POWER_OFF = 2,    -- 机箱下电生效
    RESET_BMC = 3             -- 复位BMC生效
}

-- 生效条件字符串常量
defs.VALID_CONDITION_STR = {
    POWER_OFF = 'PowerOff',
    POWER_CYCLE = 'PowerCycle',
    CHASSIS_POWER_OFF = 'ChassisPowerOff',
    RESET_BMC = 'ResetBMC'
}

-- 生效动作字符串常量
defs.VALID_ACTION_STR = {
    RESET_NONE = 'None',
    RESET_AC = 'ResetAC',
    RESET_BMC = 'ResetBMC'
}

defs.RET = {
    OK = 0,
    ERR = (-1),
    OTHERS_UPGRADING = 248,
    IN_UPGRADING = 36,
    MATCH_FAIL = 38
}

defs.CPLD_SUPPLIER_MODE = {
    SINGLE = 1,
    MULTIPLE = 2,
    MIXED = 3 -- 新产品使用，用来标识多厂商模式
}

defs.CPLD_ACTIVE_MODE = {
    NO_IMMED = 0, -- 冷升级标志，先load, 后台等待下电再refresh
    IMMED = 1, -- 热升级标志，load，立即refresh
    ONLY_ACTIVE = 2 -- 额外场景，不load, 仅refresh
}

return defs