-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local singleton = require 'mc.singleton'
local class = require 'mc.class'
local log = require 'mc.logging'

local security_object = class()

local function copy_properties(dest_table, src_table)
    dest_table.Health = src_table.Health
    log:maintenance(log.MLOG_INFO, log.FC__PUBLIC_OK,
        'Set security module self test result to (%s) successfully',
        (src_table.Health == 1) and "pass" or "fail")
    dest_table.Protocol = src_table.Protocol
    log:running(log.RLOG_INFO, 'Set security module specification type to (%s) successfully',
        src_table.Protocol)
    dest_table.Manufacturer = src_table.Manufacturer
    log:running(log.RLOG_INFO, 'Set security module manufacturer name to (%s) successfully',
        src_table.Manufacturer)
    dest_table.ProtocolVersion = src_table.ProtocolVersion
    log:running(log.RLOG_INFO, 'Set security module specification version to (%s) successfully',
        src_table.ProtocolVersion)
    dest_table.FirmwareVersion = src_table.FirmwareVersion
    log:running(log.RLOG_INFO, 'Set security module manufacturer version to (%s) successfully',
        src_table.FirmwareVersion)
end

function security_object:ctor(obj, position)
    self.obj = obj
    self.position = position
end

function security_object:update_properties(cache_data) -- 更新属性并持久化
    copy_properties(self.obj, cache_data)
end

function security_object:get_protocol()
    return self.obj.Protocol
end

function security_object:get_protocol_version()
    return self.obj.ProtocolVersion
end

function security_object:get_firmware_version()
    return self.obj.FirmwareVersion
end

function security_object:get_manufacturer()
    return self.obj.Manufacturer
end

function security_object:get_health()
    return self.obj.Health
end

return singleton(security_object)