-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.


local log = require 'mc.logging'
local context = require 'mc.context'

local smc = {}

--- @function 向SMC写命令+数据，SMC返回完成码
function smc.chip_blkwrite(chip, cmd, data)
    if not chip then
        log:error('smc.chip_blkwrite: unkonwn chip')
        return
    end
    chip:Write(context.new(), cmd, data)
end

--- @function 向SMC发送读命令+数据长度，SMC返回数据
function smc.chip_blkread(chip, cmd, len)
    if not chip then
        log:error('smc.chip_blkread: unkonwn chip')
        return nil
    end
    return chip:Read(context.get_context_or_default(), cmd, len)
end

-- chip_batch_write 批量写入数据
function smc.chip_batch_write(chip, data)
    if not chip then
        log:error('smbus.chip_batch_write: unkonwn chip')
        return nil
    end

    return chip:BatchWrite(context.new(), data)
end

return smc
