-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

-- Description: 独立VRD管理相关公用常量定义

local ind_vrd_defs = {}

-- 返回值定义
ind_vrd_defs.RET = {
    OK = 0,                -- 成功
    ERR = -1,              -- 通用错误
    OTHERS_UPGRADING = 248 -- 其他组件正在升级
}

-- 独立VRD类型常量定义
ind_vrd_defs.FIRMWARE_TYPE = {
    UPGRADE = 'Independent_Vrd',
    SMC_UPGRADE = 'Independent_Vrd_Smc',
    PMBUS_UPGRADE = 'Independent_Vrd_PMBus',
    ACTIVE = 'INDEPENDENT_VRD',
    SMC_ACTIVE = 'INDEPENDENT_VRD_SMC',
    PMBUS_ACTIVE = 'INDEPENDENT_VRD_PMBUS'
}

-- 固件缓存目录定义
ind_vrd_defs.FW_VALID_FILE_DIR = {
    [ind_vrd_defs.FIRMWARE_TYPE.UPGRADE] = '/data/backup/independent_vrd/up_cfg/'
}

ind_vrd_defs.CONVERT_COMPONENT = {
    [ind_vrd_defs.FIRMWARE_TYPE.UPGRADE] = {
        id = 0x17,
        idex = 0x17000002
    }
}

return ind_vrd_defs