-- Copyright (c) 2025 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at: http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.

local class = require 'mc.class'
local singleton = require 'mc.singleton'
local log = require 'mc.logging'
local gpu_mgmt = require 'device_mgmt.gpu_mgmt'

local m = class()

function m:ctor(app)
    log:notice('[device_mgmt] ctor')
    self.app = app
end

function m:init()
    log:notice('[device_mgmt] init')
    local ok, ret = pcall(function()
        gpu_mgmt.new(self.app)
    end)
    if not ok then
        log:notice('[device_mgmt] error %s', ret)
    end
end

return singleton(m)