-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local VrdMgmt = {}

---@class VrdMgmt.Status
---@field Status integer
local TStatus = {}
TStatus.__index = TStatus
TStatus.group = {}

local function TStatus_from_obj(obj)
    return setmetatable(obj, TStatus)
end

function TStatus.new(Status)
    return TStatus_from_obj({Status = Status})
end
---@param obj VrdMgmt.Status
function TStatus:init_from_obj(obj)
    self.Status = obj.Status
end

function TStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TStatus.group)
end

TStatus.from_obj = TStatus_from_obj

TStatus.proto_property = {'Status'}

TStatus.default = {0}

TStatus.struct = {{name = 'Status', is_array = false, struct = nil}}

function TStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Status', self.Status, 'uint8', true, errs, need_convert)

    TStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TStatus.proto_property, errs, need_convert)
    return self
end

function TStatus:unpack(_)
    return self.Status
end

VrdMgmt.Status = TStatus

---@class VrdMgmt.Watts
---@field Watts number
local TWatts = {}
TWatts.__index = TWatts
TWatts.group = {}

local function TWatts_from_obj(obj)
    return setmetatable(obj, TWatts)
end

function TWatts.new(Watts)
    return TWatts_from_obj({Watts = Watts})
end
---@param obj VrdMgmt.Watts
function TWatts:init_from_obj(obj)
    self.Watts = obj.Watts
end

function TWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TWatts.group)
end

TWatts.from_obj = TWatts_from_obj

TWatts.proto_property = {'Watts'}

TWatts.default = {0}

TWatts.struct = {{name = 'Watts', is_array = false, struct = nil}}

function TWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Watts', self.Watts, 'double', false, errs, need_convert)

    TWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TWatts.proto_property, errs, need_convert)
    return self
end

function TWatts:unpack(_)
    return self.Watts
end

VrdMgmt.Watts = TWatts

---@class VrdMgmt.Health
---@field Health integer
local THealth = {}
THealth.__index = THealth
THealth.group = {}

local function THealth_from_obj(obj)
    return setmetatable(obj, THealth)
end

function THealth.new(Health)
    return THealth_from_obj({Health = Health})
end
---@param obj VrdMgmt.Health
function THealth:init_from_obj(obj)
    self.Health = obj.Health
end

function THealth:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THealth.group)
end

THealth.from_obj = THealth_from_obj

THealth.proto_property = {'Health'}

THealth.default = {0}

THealth.struct = {{name = 'Health', is_array = false, struct = nil}}

function THealth:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Health', self.Health, 'uint8', true, errs, need_convert)

    THealth:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THealth.proto_property, errs, need_convert)
    return self
end

function THealth:unpack(_)
    return self.Health
end

VrdMgmt.Health = THealth

---@class VrdMgmt.VrdTemperatureCelsius
---@field VrdTemperatureCelsius number
local TVrdTemperatureCelsius = {}
TVrdTemperatureCelsius.__index = TVrdTemperatureCelsius
TVrdTemperatureCelsius.group = {}

local function TVrdTemperatureCelsius_from_obj(obj)
    return setmetatable(obj, TVrdTemperatureCelsius)
end

function TVrdTemperatureCelsius.new(VrdTemperatureCelsius)
    return TVrdTemperatureCelsius_from_obj({VrdTemperatureCelsius = VrdTemperatureCelsius})
end
---@param obj VrdMgmt.VrdTemperatureCelsius
function TVrdTemperatureCelsius:init_from_obj(obj)
    self.VrdTemperatureCelsius = obj.VrdTemperatureCelsius
end

function TVrdTemperatureCelsius:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVrdTemperatureCelsius.group)
end

TVrdTemperatureCelsius.from_obj = TVrdTemperatureCelsius_from_obj

TVrdTemperatureCelsius.proto_property = {'VrdTemperatureCelsius'}

TVrdTemperatureCelsius.default = {0}

TVrdTemperatureCelsius.struct = {{name = 'VrdTemperatureCelsius', is_array = false, struct = nil}}

function TVrdTemperatureCelsius:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VrdTemperatureCelsius', self.VrdTemperatureCelsius, 'double', true, errs, need_convert)

    TVrdTemperatureCelsius:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVrdTemperatureCelsius.proto_property, errs, need_convert)
    return self
end

function TVrdTemperatureCelsius:unpack(_)
    return self.VrdTemperatureCelsius
end

VrdMgmt.VrdTemperatureCelsius = TVrdTemperatureCelsius

---@class VrdMgmt.CpuDDRVddqTemp
---@field CpuDDRVddqTemp number
local TCpuDDRVddqTemp = {}
TCpuDDRVddqTemp.__index = TCpuDDRVddqTemp
TCpuDDRVddqTemp.group = {}

local function TCpuDDRVddqTemp_from_obj(obj)
    return setmetatable(obj, TCpuDDRVddqTemp)
end

function TCpuDDRVddqTemp.new(CpuDDRVddqTemp)
    return TCpuDDRVddqTemp_from_obj({CpuDDRVddqTemp = CpuDDRVddqTemp})
end
---@param obj VrdMgmt.CpuDDRVddqTemp
function TCpuDDRVddqTemp:init_from_obj(obj)
    self.CpuDDRVddqTemp = obj.CpuDDRVddqTemp
end

function TCpuDDRVddqTemp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpuDDRVddqTemp.group)
end

TCpuDDRVddqTemp.from_obj = TCpuDDRVddqTemp_from_obj

TCpuDDRVddqTemp.proto_property = {'CpuDDRVddqTemp'}

TCpuDDRVddqTemp.default = {0}

TCpuDDRVddqTemp.struct = {{name = 'CpuDDRVddqTemp', is_array = false, struct = nil}}

function TCpuDDRVddqTemp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CpuDDRVddqTemp', self.CpuDDRVddqTemp, 'double', false, errs, need_convert)

    TCpuDDRVddqTemp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpuDDRVddqTemp.proto_property, errs, need_convert)
    return self
end

function TCpuDDRVddqTemp:unpack(_)
    return self.CpuDDRVddqTemp
end

VrdMgmt.CpuDDRVddqTemp = TCpuDDRVddqTemp

---@class VrdMgmt.CpuNBDVDDTemp
---@field CpuNBDVDDTemp number
local TCpuNBDVDDTemp = {}
TCpuNBDVDDTemp.__index = TCpuNBDVDDTemp
TCpuNBDVDDTemp.group = {}

local function TCpuNBDVDDTemp_from_obj(obj)
    return setmetatable(obj, TCpuNBDVDDTemp)
end

function TCpuNBDVDDTemp.new(CpuNBDVDDTemp)
    return TCpuNBDVDDTemp_from_obj({CpuNBDVDDTemp = CpuNBDVDDTemp})
end
---@param obj VrdMgmt.CpuNBDVDDTemp
function TCpuNBDVDDTemp:init_from_obj(obj)
    self.CpuNBDVDDTemp = obj.CpuNBDVDDTemp
end

function TCpuNBDVDDTemp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpuNBDVDDTemp.group)
end

TCpuNBDVDDTemp.from_obj = TCpuNBDVDDTemp_from_obj

TCpuNBDVDDTemp.proto_property = {'CpuNBDVDDTemp'}

TCpuNBDVDDTemp.default = {0}

TCpuNBDVDDTemp.struct = {{name = 'CpuNBDVDDTemp', is_array = false, struct = nil}}

function TCpuNBDVDDTemp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CpuNBDVDDTemp', self.CpuNBDVDDTemp, 'double', false, errs, need_convert)

    TCpuNBDVDDTemp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpuNBDVDDTemp.proto_property, errs, need_convert)
    return self
end

function TCpuNBDVDDTemp:unpack(_)
    return self.CpuNBDVDDTemp
end

VrdMgmt.CpuNBDVDDTemp = TCpuNBDVDDTemp

---@class VrdMgmt.CpuNADVDDTemp
---@field CpuNADVDDTemp number
local TCpuNADVDDTemp = {}
TCpuNADVDDTemp.__index = TCpuNADVDDTemp
TCpuNADVDDTemp.group = {}

local function TCpuNADVDDTemp_from_obj(obj)
    return setmetatable(obj, TCpuNADVDDTemp)
end

function TCpuNADVDDTemp.new(CpuNADVDDTemp)
    return TCpuNADVDDTemp_from_obj({CpuNADVDDTemp = CpuNADVDDTemp})
end
---@param obj VrdMgmt.CpuNADVDDTemp
function TCpuNADVDDTemp:init_from_obj(obj)
    self.CpuNADVDDTemp = obj.CpuNADVDDTemp
end

function TCpuNADVDDTemp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpuNADVDDTemp.group)
end

TCpuNADVDDTemp.from_obj = TCpuNADVDDTemp_from_obj

TCpuNADVDDTemp.proto_property = {'CpuNADVDDTemp'}

TCpuNADVDDTemp.default = {0}

TCpuNADVDDTemp.struct = {{name = 'CpuNADVDDTemp', is_array = false, struct = nil}}

function TCpuNADVDDTemp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CpuNADVDDTemp', self.CpuNADVDDTemp, 'double', false, errs, need_convert)

    TCpuNADVDDTemp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpuNADVDDTemp.proto_property, errs, need_convert)
    return self
end

function TCpuNADVDDTemp:unpack(_)
    return self.CpuNADVDDTemp
end

VrdMgmt.CpuNADVDDTemp = TCpuNADVDDTemp

---@class VrdMgmt.CpuUncoreTemp
---@field CpuUncoreTemp number
local TCpuUncoreTemp = {}
TCpuUncoreTemp.__index = TCpuUncoreTemp
TCpuUncoreTemp.group = {}

local function TCpuUncoreTemp_from_obj(obj)
    return setmetatable(obj, TCpuUncoreTemp)
end

function TCpuUncoreTemp.new(CpuUncoreTemp)
    return TCpuUncoreTemp_from_obj({CpuUncoreTemp = CpuUncoreTemp})
end
---@param obj VrdMgmt.CpuUncoreTemp
function TCpuUncoreTemp:init_from_obj(obj)
    self.CpuUncoreTemp = obj.CpuUncoreTemp
end

function TCpuUncoreTemp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpuUncoreTemp.group)
end

TCpuUncoreTemp.from_obj = TCpuUncoreTemp_from_obj

TCpuUncoreTemp.proto_property = {'CpuUncoreTemp'}

TCpuUncoreTemp.default = {0}

TCpuUncoreTemp.struct = {{name = 'CpuUncoreTemp', is_array = false, struct = nil}}

function TCpuUncoreTemp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CpuUncoreTemp', self.CpuUncoreTemp, 'double', false, errs, need_convert)

    TCpuUncoreTemp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpuUncoreTemp.proto_property, errs, need_convert)
    return self
end

function TCpuUncoreTemp:unpack(_)
    return self.CpuUncoreTemp
end

VrdMgmt.CpuUncoreTemp = TCpuUncoreTemp

---@class VrdMgmt.CpuTBCoreTemp
---@field CpuTBCoreTemp number
local TCpuTBCoreTemp = {}
TCpuTBCoreTemp.__index = TCpuTBCoreTemp
TCpuTBCoreTemp.group = {}

local function TCpuTBCoreTemp_from_obj(obj)
    return setmetatable(obj, TCpuTBCoreTemp)
end

function TCpuTBCoreTemp.new(CpuTBCoreTemp)
    return TCpuTBCoreTemp_from_obj({CpuTBCoreTemp = CpuTBCoreTemp})
end
---@param obj VrdMgmt.CpuTBCoreTemp
function TCpuTBCoreTemp:init_from_obj(obj)
    self.CpuTBCoreTemp = obj.CpuTBCoreTemp
end

function TCpuTBCoreTemp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpuTBCoreTemp.group)
end

TCpuTBCoreTemp.from_obj = TCpuTBCoreTemp_from_obj

TCpuTBCoreTemp.proto_property = {'CpuTBCoreTemp'}

TCpuTBCoreTemp.default = {0}

TCpuTBCoreTemp.struct = {{name = 'CpuTBCoreTemp', is_array = false, struct = nil}}

function TCpuTBCoreTemp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CpuTBCoreTemp', self.CpuTBCoreTemp, 'double', false, errs, need_convert)

    TCpuTBCoreTemp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpuTBCoreTemp.proto_property, errs, need_convert)
    return self
end

function TCpuTBCoreTemp:unpack(_)
    return self.CpuTBCoreTemp
end

VrdMgmt.CpuTBCoreTemp = TCpuTBCoreTemp

---@class VrdMgmt.CpuDDRVDDTemp
---@field CpuDDRVDDTemp number
local TCpuDDRVDDTemp = {}
TCpuDDRVDDTemp.__index = TCpuDDRVDDTemp
TCpuDDRVDDTemp.group = {}

local function TCpuDDRVDDTemp_from_obj(obj)
    return setmetatable(obj, TCpuDDRVDDTemp)
end

function TCpuDDRVDDTemp.new(CpuDDRVDDTemp)
    return TCpuDDRVDDTemp_from_obj({CpuDDRVDDTemp = CpuDDRVDDTemp})
end
---@param obj VrdMgmt.CpuDDRVDDTemp
function TCpuDDRVDDTemp:init_from_obj(obj)
    self.CpuDDRVDDTemp = obj.CpuDDRVDDTemp
end

function TCpuDDRVDDTemp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpuDDRVDDTemp.group)
end

TCpuDDRVDDTemp.from_obj = TCpuDDRVDDTemp_from_obj

TCpuDDRVDDTemp.proto_property = {'CpuDDRVDDTemp'}

TCpuDDRVDDTemp.default = {0}

TCpuDDRVDDTemp.struct = {{name = 'CpuDDRVDDTemp', is_array = false, struct = nil}}

function TCpuDDRVDDTemp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CpuDDRVDDTemp', self.CpuDDRVDDTemp, 'double', false, errs, need_convert)

    TCpuDDRVDDTemp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpuDDRVDDTemp.proto_property, errs, need_convert)
    return self
end

function TCpuDDRVDDTemp:unpack(_)
    return self.CpuDDRVDDTemp
end

VrdMgmt.CpuDDRVDDTemp = TCpuDDRVDDTemp

---@class VrdMgmt.CpuTACoreTemp
---@field CpuTACoreTemp number
local TCpuTACoreTemp = {}
TCpuTACoreTemp.__index = TCpuTACoreTemp
TCpuTACoreTemp.group = {}

local function TCpuTACoreTemp_from_obj(obj)
    return setmetatable(obj, TCpuTACoreTemp)
end

function TCpuTACoreTemp.new(CpuTACoreTemp)
    return TCpuTACoreTemp_from_obj({CpuTACoreTemp = CpuTACoreTemp})
end
---@param obj VrdMgmt.CpuTACoreTemp
function TCpuTACoreTemp:init_from_obj(obj)
    self.CpuTACoreTemp = obj.CpuTACoreTemp
end

function TCpuTACoreTemp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpuTACoreTemp.group)
end

TCpuTACoreTemp.from_obj = TCpuTACoreTemp_from_obj

TCpuTACoreTemp.proto_property = {'CpuTACoreTemp'}

TCpuTACoreTemp.default = {0}

TCpuTACoreTemp.struct = {{name = 'CpuTACoreTemp', is_array = false, struct = nil}}

function TCpuTACoreTemp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CpuTACoreTemp', self.CpuTACoreTemp, 'double', false, errs, need_convert)

    TCpuTACoreTemp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpuTACoreTemp.proto_property, errs, need_convert)
    return self
end

function TCpuTACoreTemp:unpack(_)
    return self.CpuTACoreTemp
end

VrdMgmt.CpuTACoreTemp = TCpuTACoreTemp

---@class VrdMgmt.Cpu1v1DDRVddq
---@field Cpu1v1DDRVddq number
local TCpu1v1DDRVddq = {}
TCpu1v1DDRVddq.__index = TCpu1v1DDRVddq
TCpu1v1DDRVddq.group = {}

local function TCpu1v1DDRVddq_from_obj(obj)
    return setmetatable(obj, TCpu1v1DDRVddq)
end

function TCpu1v1DDRVddq.new(Cpu1v1DDRVddq)
    return TCpu1v1DDRVddq_from_obj({Cpu1v1DDRVddq = Cpu1v1DDRVddq})
end
---@param obj VrdMgmt.Cpu1v1DDRVddq
function TCpu1v1DDRVddq:init_from_obj(obj)
    self.Cpu1v1DDRVddq = obj.Cpu1v1DDRVddq
end

function TCpu1v1DDRVddq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpu1v1DDRVddq.group)
end

TCpu1v1DDRVddq.from_obj = TCpu1v1DDRVddq_from_obj

TCpu1v1DDRVddq.proto_property = {'Cpu1v1DDRVddq'}

TCpu1v1DDRVddq.default = {0}

TCpu1v1DDRVddq.struct = {{name = 'Cpu1v1DDRVddq', is_array = false, struct = nil}}

function TCpu1v1DDRVddq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Cpu1v1DDRVddq', self.Cpu1v1DDRVddq, 'double', false, errs, need_convert)

    TCpu1v1DDRVddq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpu1v1DDRVddq.proto_property, errs, need_convert)
    return self
end

function TCpu1v1DDRVddq:unpack(_)
    return self.Cpu1v1DDRVddq
end

VrdMgmt.Cpu1v1DDRVddq = TCpu1v1DDRVddq

---@class VrdMgmt.Cpu0v8NBDVDD
---@field Cpu0v8NBDVDD number
local TCpu0v8NBDVDD = {}
TCpu0v8NBDVDD.__index = TCpu0v8NBDVDD
TCpu0v8NBDVDD.group = {}

local function TCpu0v8NBDVDD_from_obj(obj)
    return setmetatable(obj, TCpu0v8NBDVDD)
end

function TCpu0v8NBDVDD.new(Cpu0v8NBDVDD)
    return TCpu0v8NBDVDD_from_obj({Cpu0v8NBDVDD = Cpu0v8NBDVDD})
end
---@param obj VrdMgmt.Cpu0v8NBDVDD
function TCpu0v8NBDVDD:init_from_obj(obj)
    self.Cpu0v8NBDVDD = obj.Cpu0v8NBDVDD
end

function TCpu0v8NBDVDD:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpu0v8NBDVDD.group)
end

TCpu0v8NBDVDD.from_obj = TCpu0v8NBDVDD_from_obj

TCpu0v8NBDVDD.proto_property = {'Cpu0v8NBDVDD'}

TCpu0v8NBDVDD.default = {0}

TCpu0v8NBDVDD.struct = {{name = 'Cpu0v8NBDVDD', is_array = false, struct = nil}}

function TCpu0v8NBDVDD:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Cpu0v8NBDVDD', self.Cpu0v8NBDVDD, 'double', false, errs, need_convert)

    TCpu0v8NBDVDD:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpu0v8NBDVDD.proto_property, errs, need_convert)
    return self
end

function TCpu0v8NBDVDD:unpack(_)
    return self.Cpu0v8NBDVDD
end

VrdMgmt.Cpu0v8NBDVDD = TCpu0v8NBDVDD

---@class VrdMgmt.Cpu0v8NADVDD
---@field Cpu0v8NADVDD number
local TCpu0v8NADVDD = {}
TCpu0v8NADVDD.__index = TCpu0v8NADVDD
TCpu0v8NADVDD.group = {}

local function TCpu0v8NADVDD_from_obj(obj)
    return setmetatable(obj, TCpu0v8NADVDD)
end

function TCpu0v8NADVDD.new(Cpu0v8NADVDD)
    return TCpu0v8NADVDD_from_obj({Cpu0v8NADVDD = Cpu0v8NADVDD})
end
---@param obj VrdMgmt.Cpu0v8NADVDD
function TCpu0v8NADVDD:init_from_obj(obj)
    self.Cpu0v8NADVDD = obj.Cpu0v8NADVDD
end

function TCpu0v8NADVDD:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpu0v8NADVDD.group)
end

TCpu0v8NADVDD.from_obj = TCpu0v8NADVDD_from_obj

TCpu0v8NADVDD.proto_property = {'Cpu0v8NADVDD'}

TCpu0v8NADVDD.default = {0}

TCpu0v8NADVDD.struct = {{name = 'Cpu0v8NADVDD', is_array = false, struct = nil}}

function TCpu0v8NADVDD:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Cpu0v8NADVDD', self.Cpu0v8NADVDD, 'double', false, errs, need_convert)

    TCpu0v8NADVDD:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpu0v8NADVDD.proto_property, errs, need_convert)
    return self
end

function TCpu0v8NADVDD:unpack(_)
    return self.Cpu0v8NADVDD
end

VrdMgmt.Cpu0v8NADVDD = TCpu0v8NADVDD

---@class VrdMgmt.Cpu0v9Uncore
---@field Cpu0v9Uncore number
local TCpu0v9Uncore = {}
TCpu0v9Uncore.__index = TCpu0v9Uncore
TCpu0v9Uncore.group = {}

local function TCpu0v9Uncore_from_obj(obj)
    return setmetatable(obj, TCpu0v9Uncore)
end

function TCpu0v9Uncore.new(Cpu0v9Uncore)
    return TCpu0v9Uncore_from_obj({Cpu0v9Uncore = Cpu0v9Uncore})
end
---@param obj VrdMgmt.Cpu0v9Uncore
function TCpu0v9Uncore:init_from_obj(obj)
    self.Cpu0v9Uncore = obj.Cpu0v9Uncore
end

function TCpu0v9Uncore:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpu0v9Uncore.group)
end

TCpu0v9Uncore.from_obj = TCpu0v9Uncore_from_obj

TCpu0v9Uncore.proto_property = {'Cpu0v9Uncore'}

TCpu0v9Uncore.default = {0}

TCpu0v9Uncore.struct = {{name = 'Cpu0v9Uncore', is_array = false, struct = nil}}

function TCpu0v9Uncore:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Cpu0v9Uncore', self.Cpu0v9Uncore, 'double', false, errs, need_convert)

    TCpu0v9Uncore:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpu0v9Uncore.proto_property, errs, need_convert)
    return self
end

function TCpu0v9Uncore:unpack(_)
    return self.Cpu0v9Uncore
end

VrdMgmt.Cpu0v9Uncore = TCpu0v9Uncore

---@class VrdMgmt.Cpu0v9TBCore
---@field Cpu0v9TBCore number
local TCpu0v9TBCore = {}
TCpu0v9TBCore.__index = TCpu0v9TBCore
TCpu0v9TBCore.group = {}

local function TCpu0v9TBCore_from_obj(obj)
    return setmetatable(obj, TCpu0v9TBCore)
end

function TCpu0v9TBCore.new(Cpu0v9TBCore)
    return TCpu0v9TBCore_from_obj({Cpu0v9TBCore = Cpu0v9TBCore})
end
---@param obj VrdMgmt.Cpu0v9TBCore
function TCpu0v9TBCore:init_from_obj(obj)
    self.Cpu0v9TBCore = obj.Cpu0v9TBCore
end

function TCpu0v9TBCore:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpu0v9TBCore.group)
end

TCpu0v9TBCore.from_obj = TCpu0v9TBCore_from_obj

TCpu0v9TBCore.proto_property = {'Cpu0v9TBCore'}

TCpu0v9TBCore.default = {0}

TCpu0v9TBCore.struct = {{name = 'Cpu0v9TBCore', is_array = false, struct = nil}}

function TCpu0v9TBCore:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Cpu0v9TBCore', self.Cpu0v9TBCore, 'double', false, errs, need_convert)

    TCpu0v9TBCore:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpu0v9TBCore.proto_property, errs, need_convert)
    return self
end

function TCpu0v9TBCore:unpack(_)
    return self.Cpu0v9TBCore
end

VrdMgmt.Cpu0v9TBCore = TCpu0v9TBCore

---@class VrdMgmt.Cpu0v75DDRVDD
---@field Cpu0v75DDRVDD number
local TCpu0v75DDRVDD = {}
TCpu0v75DDRVDD.__index = TCpu0v75DDRVDD
TCpu0v75DDRVDD.group = {}

local function TCpu0v75DDRVDD_from_obj(obj)
    return setmetatable(obj, TCpu0v75DDRVDD)
end

function TCpu0v75DDRVDD.new(Cpu0v75DDRVDD)
    return TCpu0v75DDRVDD_from_obj({Cpu0v75DDRVDD = Cpu0v75DDRVDD})
end
---@param obj VrdMgmt.Cpu0v75DDRVDD
function TCpu0v75DDRVDD:init_from_obj(obj)
    self.Cpu0v75DDRVDD = obj.Cpu0v75DDRVDD
end

function TCpu0v75DDRVDD:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpu0v75DDRVDD.group)
end

TCpu0v75DDRVDD.from_obj = TCpu0v75DDRVDD_from_obj

TCpu0v75DDRVDD.proto_property = {'Cpu0v75DDRVDD'}

TCpu0v75DDRVDD.default = {0}

TCpu0v75DDRVDD.struct = {{name = 'Cpu0v75DDRVDD', is_array = false, struct = nil}}

function TCpu0v75DDRVDD:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Cpu0v75DDRVDD', self.Cpu0v75DDRVDD, 'double', false, errs, need_convert)

    TCpu0v75DDRVDD:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpu0v75DDRVDD.proto_property, errs, need_convert)
    return self
end

function TCpu0v75DDRVDD:unpack(_)
    return self.Cpu0v75DDRVDD
end

VrdMgmt.Cpu0v75DDRVDD = TCpu0v75DDRVDD

---@class VrdMgmt.Cpu0v9TACore
---@field Cpu0v9TACore number
local TCpu0v9TACore = {}
TCpu0v9TACore.__index = TCpu0v9TACore
TCpu0v9TACore.group = {}

local function TCpu0v9TACore_from_obj(obj)
    return setmetatable(obj, TCpu0v9TACore)
end

function TCpu0v9TACore.new(Cpu0v9TACore)
    return TCpu0v9TACore_from_obj({Cpu0v9TACore = Cpu0v9TACore})
end
---@param obj VrdMgmt.Cpu0v9TACore
function TCpu0v9TACore:init_from_obj(obj)
    self.Cpu0v9TACore = obj.Cpu0v9TACore
end

function TCpu0v9TACore:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpu0v9TACore.group)
end

TCpu0v9TACore.from_obj = TCpu0v9TACore_from_obj

TCpu0v9TACore.proto_property = {'Cpu0v9TACore'}

TCpu0v9TACore.default = {0}

TCpu0v9TACore.struct = {{name = 'Cpu0v9TACore', is_array = false, struct = nil}}

function TCpu0v9TACore:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Cpu0v9TACore', self.Cpu0v9TACore, 'double', false, errs, need_convert)

    TCpu0v9TACore:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpu0v9TACore.proto_property, errs, need_convert)
    return self
end

function TCpu0v9TACore:unpack(_)
    return self.Cpu0v9TACore
end

VrdMgmt.Cpu0v9TACore = TCpu0v9TACore

---@class VrdMgmt.CpuId
---@field CpuId integer
local TCpuId = {}
TCpuId.__index = TCpuId
TCpuId.group = {}

local function TCpuId_from_obj(obj)
    return setmetatable(obj, TCpuId)
end

function TCpuId.new(CpuId)
    return TCpuId_from_obj({CpuId = CpuId})
end
---@param obj VrdMgmt.CpuId
function TCpuId:init_from_obj(obj)
    self.CpuId = obj.CpuId
end

function TCpuId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCpuId.group)
end

TCpuId.from_obj = TCpuId_from_obj

TCpuId.proto_property = {'CpuId'}

TCpuId.default = {0}

TCpuId.struct = {{name = 'CpuId', is_array = false, struct = nil}}

function TCpuId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CpuId', self.CpuId, 'uint8', true, errs, need_convert)

    TCpuId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCpuId.proto_property, errs, need_convert)
    return self
end

function TCpuId:unpack(_)
    return self.CpuId
end

VrdMgmt.CpuId = TCpuId

---@class VrdMgmt.SystemId
---@field SystemId integer
local TSystemId = {}
TSystemId.__index = TSystemId
TSystemId.group = {}

local function TSystemId_from_obj(obj)
    return setmetatable(obj, TSystemId)
end

function TSystemId.new(SystemId)
    return TSystemId_from_obj({SystemId = SystemId})
end
---@param obj VrdMgmt.SystemId
function TSystemId:init_from_obj(obj)
    self.SystemId = obj.SystemId
end

function TSystemId:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSystemId.group)
end

TSystemId.from_obj = TSystemId_from_obj

TSystemId.proto_property = {'SystemId'}

TSystemId.default = {0}

TSystemId.struct = {{name = 'SystemId', is_array = false, struct = nil}}

function TSystemId:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SystemId', self.SystemId, 'uint8', true, errs, need_convert)

    TSystemId:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSystemId.proto_property, errs, need_convert)
    return self
end

function TSystemId:unpack(_)
    return self.SystemId
end

VrdMgmt.SystemId = TSystemId

VrdMgmt.interface = mdb.register_interface('bmc.kepler.Systems.VrdMgmt', {
    SystemId = {'y', nil, true, nil},
    CpuId = {'y', nil, true, nil},
    Cpu0v9TACore = {'d', nil, false, nil},
    Cpu0v75DDRVDD = {'d', nil, false, nil},
    Cpu0v9TBCore = {'d', nil, false, nil},
    Cpu0v9Uncore = {'d', nil, false, nil},
    Cpu0v8NADVDD = {'d', nil, false, nil},
    Cpu0v8NBDVDD = {'d', nil, false, nil},
    Cpu1v1DDRVddq = {'d', nil, false, nil},
    CpuTACoreTemp = {'d', nil, false, nil},
    CpuDDRVDDTemp = {'d', nil, false, nil},
    CpuTBCoreTemp = {'d', nil, false, nil},
    CpuUncoreTemp = {'d', nil, false, nil},
    CpuNADVDDTemp = {'d', nil, false, nil},
    CpuNBDVDDTemp = {'d', nil, false, nil},
    CpuDDRVddqTemp = {'d', nil, false, nil},
    VrdTemperatureCelsius = {'d', nil, true, nil},
    Health = {'y', nil, true, nil},
    Watts = {'d', nil, false, nil},
    Status = {'y', nil, true, nil}
}, {}, {})

return VrdMgmt
