-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Unit = {}

---@class Unit.CurrentUpgradeStatus
---@field CurrentUpgradeStatus integer
local TCurrentUpgradeStatus = {}
TCurrentUpgradeStatus.__index = TCurrentUpgradeStatus
TCurrentUpgradeStatus.group = {}

local function TCurrentUpgradeStatus_from_obj(obj)
    return setmetatable(obj, TCurrentUpgradeStatus)
end

function TCurrentUpgradeStatus.new(CurrentUpgradeStatus)
    return TCurrentUpgradeStatus_from_obj({CurrentUpgradeStatus = CurrentUpgradeStatus})
end
---@param obj Unit.CurrentUpgradeStatus
function TCurrentUpgradeStatus:init_from_obj(obj)
    self.CurrentUpgradeStatus = obj.CurrentUpgradeStatus
end

function TCurrentUpgradeStatus:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TCurrentUpgradeStatus.group)
end

TCurrentUpgradeStatus.from_obj = TCurrentUpgradeStatus_from_obj

TCurrentUpgradeStatus.proto_property = {'CurrentUpgradeStatus'}

TCurrentUpgradeStatus.default = {0}

TCurrentUpgradeStatus.struct = {{name = 'CurrentUpgradeStatus', is_array = false, struct = nil}}

function TCurrentUpgradeStatus:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CurrentUpgradeStatus', self.CurrentUpgradeStatus, 'uint8', true, errs, need_convert)

    TCurrentUpgradeStatus:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TCurrentUpgradeStatus.proto_property, errs, need_convert)
    return self
end

function TCurrentUpgradeStatus:unpack(_)
    return self.CurrentUpgradeStatus
end

Unit.CurrentUpgradeStatus = TCurrentUpgradeStatus

---@class Unit.HWSRVersion
---@field HWSRVersion string
local THWSRVersion = {}
THWSRVersion.__index = THWSRVersion
THWSRVersion.group = {}

local function THWSRVersion_from_obj(obj)
    return setmetatable(obj, THWSRVersion)
end

function THWSRVersion.new(HWSRVersion)
    return THWSRVersion_from_obj({HWSRVersion = HWSRVersion})
end
---@param obj Unit.HWSRVersion
function THWSRVersion:init_from_obj(obj)
    self.HWSRVersion = obj.HWSRVersion
end

function THWSRVersion:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, THWSRVersion.group)
end

THWSRVersion.from_obj = THWSRVersion_from_obj

THWSRVersion.proto_property = {'HWSRVersion'}

THWSRVersion.default = {''}

THWSRVersion.struct = {{name = 'HWSRVersion', is_array = false, struct = nil}}

function THWSRVersion:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'HWSRVersion', self.HWSRVersion, 'string', true, errs, need_convert)

    THWSRVersion:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, THWSRVersion.proto_property, errs, need_convert)
    return self
end

function THWSRVersion:unpack(_)
    return self.HWSRVersion
end

Unit.HWSRVersion = THWSRVersion

---@class Unit.Type
---@field Type string
local TType = {}
TType.__index = TType
TType.group = {}

local function TType_from_obj(obj)
    return setmetatable(obj, TType)
end

function TType.new(Type)
    return TType_from_obj({Type = Type})
end
---@param obj Unit.Type
function TType:init_from_obj(obj)
    self.Type = obj.Type
end

function TType:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TType.group)
end

TType.from_obj = TType_from_obj

TType.proto_property = {'Type'}

TType.default = {''}

TType.struct = {{name = 'Type', is_array = false, struct = nil}}

function TType:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'string', true, errs, need_convert)

    TType:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TType.proto_property, errs, need_convert)
    return self
end

function TType:unpack(_)
    return self.Type
end

Unit.Type = TType

---@class Unit.UID
---@field UID string
local TUID = {}
TUID.__index = TUID
TUID.group = {}

local function TUID_from_obj(obj)
    return setmetatable(obj, TUID)
end

function TUID.new(UID)
    return TUID_from_obj({UID = UID})
end
---@param obj Unit.UID
function TUID:init_from_obj(obj)
    self.UID = obj.UID
end

function TUID:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TUID.group)
end

TUID.from_obj = TUID_from_obj

TUID.proto_property = {'UID'}

TUID.default = {''}

TUID.struct = {{name = 'UID', is_array = false, struct = nil}}

function TUID:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'UID', self.UID, 'string', true, errs, need_convert)

    TUID:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TUID.proto_property, errs, need_convert)
    return self
end

function TUID:unpack(_)
    return self.UID
end

Unit.UID = TUID

Unit.interface = mdb.register_interface('bmc.kepler.Systems.Board.Unit', {
    UID = {'s', nil, true, nil},
    Type = {'s', nil, true, nil},
    HWSRVersion = {'s', nil, true, nil},
    CurrentUpgradeStatus = {'y', nil, true, nil}
}, {}, {})

return Unit
