-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Time = {}

---@class Time.KeyValueTable
---@field key string
---@field value string
local TKeyValueTable = {}
TKeyValueTable.__index = TKeyValueTable
TKeyValueTable.group = {}

local function TKeyValueTable_from_obj(obj)
    return setmetatable(obj, TKeyValueTable)
end

function TKeyValueTable.new(dict)
    return TKeyValueTable_from_obj(dict)
end

---@param obj Time.KeyValueTable
function TKeyValueTable:init_from_obj(obj)
    self = obj
end

function TKeyValueTable:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TKeyValueTable.group)
end

TKeyValueTable.from_obj = TKeyValueTable_from_obj

TKeyValueTable.proto_property = {}

TKeyValueTable.default = {}

TKeyValueTable.struct = {}

function TKeyValueTable:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TKeyValueTable:remove_error_props(errs, self)
    return self
end

function TKeyValueTable:unpack(_)
    return self
end

Time.KeyValueTable = TKeyValueTable

---@class Time.SetRtcTimeRsp
local TSetRtcTimeRsp = {}
TSetRtcTimeRsp.__index = TSetRtcTimeRsp
TSetRtcTimeRsp.group = {}

local function TSetRtcTimeRsp_from_obj(obj)
    return setmetatable(obj, TSetRtcTimeRsp)
end

function TSetRtcTimeRsp.new()
    return TSetRtcTimeRsp_from_obj({})
end
---@param obj Time.SetRtcTimeRsp
function TSetRtcTimeRsp:init_from_obj(obj)

end

function TSetRtcTimeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetRtcTimeRsp.group)
end

TSetRtcTimeRsp.from_obj = TSetRtcTimeRsp_from_obj

TSetRtcTimeRsp.proto_property = {}

TSetRtcTimeRsp.default = {}

TSetRtcTimeRsp.struct = {}

function TSetRtcTimeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetRtcTimeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetRtcTimeRsp.proto_property, errs, need_convert)
    return self
end

function TSetRtcTimeRsp:unpack(_)
end

Time.SetRtcTimeRsp = TSetRtcTimeRsp

---@class Time.SetRtcTimeReq
---@field TimeStamp integer
local TSetRtcTimeReq = {}
TSetRtcTimeReq.__index = TSetRtcTimeReq
TSetRtcTimeReq.group = {}

local function TSetRtcTimeReq_from_obj(obj)
    return setmetatable(obj, TSetRtcTimeReq)
end

function TSetRtcTimeReq.new(TimeStamp)
    return TSetRtcTimeReq_from_obj({TimeStamp = TimeStamp})
end
---@param obj Time.SetRtcTimeReq
function TSetRtcTimeReq:init_from_obj(obj)
    self.TimeStamp = obj.TimeStamp
end

function TSetRtcTimeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetRtcTimeReq.group)
end

TSetRtcTimeReq.from_obj = TSetRtcTimeReq_from_obj

TSetRtcTimeReq.proto_property = {'TimeStamp'}

TSetRtcTimeReq.default = {0}

TSetRtcTimeReq.struct = {{name = 'TimeStamp', is_array = false, struct = nil}}

function TSetRtcTimeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'TimeStamp', self.TimeStamp, 'uint64', false, errs, need_convert)

    TSetRtcTimeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetRtcTimeReq.proto_property, errs, need_convert)
    return self
end

function TSetRtcTimeReq:unpack(_)
    return self.TimeStamp
end

Time.SetRtcTimeReq = TSetRtcTimeReq

---@class Time.SetDateTimeRsp
local TSetDateTimeRsp = {}
TSetDateTimeRsp.__index = TSetDateTimeRsp
TSetDateTimeRsp.group = {}

local function TSetDateTimeRsp_from_obj(obj)
    return setmetatable(obj, TSetDateTimeRsp)
end

function TSetDateTimeRsp.new()
    return TSetDateTimeRsp_from_obj({})
end
---@param obj Time.SetDateTimeRsp
function TSetDateTimeRsp:init_from_obj(obj)

end

function TSetDateTimeRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDateTimeRsp.group)
end

TSetDateTimeRsp.from_obj = TSetDateTimeRsp_from_obj

TSetDateTimeRsp.proto_property = {}

TSetDateTimeRsp.default = {}

TSetDateTimeRsp.struct = {}

function TSetDateTimeRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetDateTimeRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDateTimeRsp.proto_property, errs, need_convert)
    return self
end

function TSetDateTimeRsp:unpack(_)
end

Time.SetDateTimeRsp = TSetDateTimeRsp

---@class Time.SetDateTimeReq
---@field TimeParams Time.KeyValueTable
local TSetDateTimeReq = {}
TSetDateTimeReq.__index = TSetDateTimeReq
TSetDateTimeReq.group = {}

local function TSetDateTimeReq_from_obj(obj)
    return setmetatable(obj, TSetDateTimeReq)
end

function TSetDateTimeReq.new(TimeParams)
    return TSetDateTimeReq_from_obj({TimeParams = TimeParams})
end
---@param obj Time.SetDateTimeReq
function TSetDateTimeReq:init_from_obj(obj)
    self.TimeParams = obj.TimeParams
end

function TSetDateTimeReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetDateTimeReq.group)
end

TSetDateTimeReq.from_obj = TSetDateTimeReq_from_obj

TSetDateTimeReq.proto_property = {'TimeParams'}

TSetDateTimeReq.default = {Time.KeyValueTable.default}

TSetDateTimeReq.struct = {{name = 'TimeParams', is_array = false, struct = Time.KeyValueTable.struct}}

function TSetDateTimeReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    Time.KeyValueTable.new(self.TimeParams):validate(prefix, errs, need_convert)

    TSetDateTimeReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetDateTimeReq.proto_property, errs, need_convert)
    return self
end

function TSetDateTimeReq:unpack(_)
    return self.TimeParams
end

Time.SetDateTimeReq = TSetDateTimeReq

Time.interface = mdb.register_interface('bmc.kepler.Managers.Time', {
    DateTime = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    TimeZoneConfigurable = {'b', nil, true, nil},
    DateTimeLocalOffset = {'s', nil, true, nil},
    TimeZoneName = {'s', nil, false, nil},
    SyncStatus = {'b', {['emitsChangedSignal'] = 'false'}, true, nil},
    DSTEnabled = {'b', {['emitsChangedSignal'] = 'false'}, true, nil}
}, {
    SetDateTime = {'a{ss}a{ss}', '', TSetDateTimeReq, TSetDateTimeRsp},
    SetRtcTime = {'a{ss}t', '', TSetRtcTimeReq, TSetRtcTimeRsp}
}, {})

return Time
