-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local SystemsFruCtrl = {}

---@class SystemsFruCtrl.FruPowerCtrlRsp
---@field CmdResult integer
local TFruPowerCtrlRsp = {}
TFruPowerCtrlRsp.__index = TFruPowerCtrlRsp
TFruPowerCtrlRsp.group = {}

local function TFruPowerCtrlRsp_from_obj(obj)
    return setmetatable(obj, TFruPowerCtrlRsp)
end

function TFruPowerCtrlRsp.new(CmdResult)
    return TFruPowerCtrlRsp_from_obj({CmdResult = CmdResult})
end
---@param obj SystemsFruCtrl.FruPowerCtrlRsp
function TFruPowerCtrlRsp:init_from_obj(obj)
    self.CmdResult = obj.CmdResult
end

function TFruPowerCtrlRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruPowerCtrlRsp.group)
end

TFruPowerCtrlRsp.from_obj = TFruPowerCtrlRsp_from_obj

TFruPowerCtrlRsp.proto_property = {'CmdResult'}

TFruPowerCtrlRsp.default = {0}

TFruPowerCtrlRsp.struct = {{name = 'CmdResult', is_array = false, struct = nil}}

function TFruPowerCtrlRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CmdResult', self.CmdResult, 'int32', false, errs, need_convert)

    TFruPowerCtrlRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruPowerCtrlRsp.proto_property, errs, need_convert)
    return self
end

function TFruPowerCtrlRsp:unpack(_)
    return self.CmdResult
end

SystemsFruCtrl.FruPowerCtrlRsp = TFruPowerCtrlRsp

---@class SystemsFruCtrl.FruPowerCtrlReq
---@field PowerCtrlType string
---@field RestartCause string
---@field FruID integer
local TFruPowerCtrlReq = {}
TFruPowerCtrlReq.__index = TFruPowerCtrlReq
TFruPowerCtrlReq.group = {}

local function TFruPowerCtrlReq_from_obj(obj)
    return setmetatable(obj, TFruPowerCtrlReq)
end

function TFruPowerCtrlReq.new(PowerCtrlType, RestartCause, FruID)
    return TFruPowerCtrlReq_from_obj({PowerCtrlType = PowerCtrlType, RestartCause = RestartCause, FruID = FruID})
end
---@param obj SystemsFruCtrl.FruPowerCtrlReq
function TFruPowerCtrlReq:init_from_obj(obj)
    self.PowerCtrlType = obj.PowerCtrlType
    self.RestartCause = obj.RestartCause
    self.FruID = obj.FruID
end

function TFruPowerCtrlReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFruPowerCtrlReq.group)
end

TFruPowerCtrlReq.from_obj = TFruPowerCtrlReq_from_obj

TFruPowerCtrlReq.proto_property = {'PowerCtrlType', 'RestartCause', 'FruID'}

TFruPowerCtrlReq.default = {'', '', 0}

TFruPowerCtrlReq.struct = {
    {name = 'PowerCtrlType', is_array = false, struct = nil}, {name = 'RestartCause', is_array = false, struct = nil},
    {name = 'FruID', is_array = false, struct = nil}
}

function TFruPowerCtrlReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerCtrlType', self.PowerCtrlType, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'RestartCause', self.RestartCause, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'FruID', self.FruID, 'uint8', false, errs, need_convert)

    TFruPowerCtrlReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TFruPowerCtrlReq.proto_property, errs, need_convert)
    return self
end

function TFruPowerCtrlReq:unpack(_)
    return self.PowerCtrlType, self.RestartCause, self.FruID
end

SystemsFruCtrl.FruPowerCtrlReq = TFruPowerCtrlReq

---@class SystemsFruCtrl.SetACLostRsp
---@field CmdResult integer
local TSetACLostRsp = {}
TSetACLostRsp.__index = TSetACLostRsp
TSetACLostRsp.group = {}

local function TSetACLostRsp_from_obj(obj)
    return setmetatable(obj, TSetACLostRsp)
end

function TSetACLostRsp.new(CmdResult)
    return TSetACLostRsp_from_obj({CmdResult = CmdResult})
end
---@param obj SystemsFruCtrl.SetACLostRsp
function TSetACLostRsp:init_from_obj(obj)
    self.CmdResult = obj.CmdResult
end

function TSetACLostRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetACLostRsp.group)
end

TSetACLostRsp.from_obj = TSetACLostRsp_from_obj

TSetACLostRsp.proto_property = {'CmdResult'}

TSetACLostRsp.default = {0}

TSetACLostRsp.struct = {{name = 'CmdResult', is_array = false, struct = nil}}

function TSetACLostRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CmdResult', self.CmdResult, 'uint32', false, errs, need_convert)

    TSetACLostRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetACLostRsp.proto_property, errs, need_convert)
    return self
end

function TSetACLostRsp:unpack(_)
    return self.CmdResult
end

SystemsFruCtrl.SetACLostRsp = TSetACLostRsp

---@class SystemsFruCtrl.SetACLostReq
---@field Type integer
local TSetACLostReq = {}
TSetACLostReq.__index = TSetACLostReq
TSetACLostReq.group = {}

local function TSetACLostReq_from_obj(obj)
    return setmetatable(obj, TSetACLostReq)
end

function TSetACLostReq.new(Type)
    return TSetACLostReq_from_obj({Type = Type})
end
---@param obj SystemsFruCtrl.SetACLostReq
function TSetACLostReq:init_from_obj(obj)
    self.Type = obj.Type
end

function TSetACLostReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetACLostReq.group)
end

TSetACLostReq.from_obj = TSetACLostReq_from_obj

TSetACLostReq.proto_property = {'Type'}

TSetACLostReq.default = {0}

TSetACLostReq.struct = {{name = 'Type', is_array = false, struct = nil}}

function TSetACLostReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Type', self.Type, 'uint8', false, errs, need_convert)

    if self.Type ~= nil then
        validate.Enum(prefix .. 'Type', self.Type, '', {1}, errs, need_convert)
    end

    TSetACLostReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetACLostReq.proto_property, errs, need_convert)
    return self
end

function TSetACLostReq:unpack(_)
    return self.Type
end

SystemsFruCtrl.SetACLostReq = TSetACLostReq

---@class SystemsFruCtrl.SetPowerOnStrategyExceptionsRsp
---@field CmdResult integer
local TSetPowerOnStrategyExceptionsRsp = {}
TSetPowerOnStrategyExceptionsRsp.__index = TSetPowerOnStrategyExceptionsRsp
TSetPowerOnStrategyExceptionsRsp.group = {}

local function TSetPowerOnStrategyExceptionsRsp_from_obj(obj)
    return setmetatable(obj, TSetPowerOnStrategyExceptionsRsp)
end

function TSetPowerOnStrategyExceptionsRsp.new(CmdResult)
    return TSetPowerOnStrategyExceptionsRsp_from_obj({CmdResult = CmdResult})
end
---@param obj SystemsFruCtrl.SetPowerOnStrategyExceptionsRsp
function TSetPowerOnStrategyExceptionsRsp:init_from_obj(obj)
    self.CmdResult = obj.CmdResult
end

function TSetPowerOnStrategyExceptionsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerOnStrategyExceptionsRsp.group)
end

TSetPowerOnStrategyExceptionsRsp.from_obj = TSetPowerOnStrategyExceptionsRsp_from_obj

TSetPowerOnStrategyExceptionsRsp.proto_property = {'CmdResult'}

TSetPowerOnStrategyExceptionsRsp.default = {0}

TSetPowerOnStrategyExceptionsRsp.struct = {{name = 'CmdResult', is_array = false, struct = nil}}

function TSetPowerOnStrategyExceptionsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CmdResult', self.CmdResult, 'uint32', false, errs, need_convert)

    TSetPowerOnStrategyExceptionsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerOnStrategyExceptionsRsp.proto_property, errs, need_convert)
    return self
end

function TSetPowerOnStrategyExceptionsRsp:unpack(_)
    return self.CmdResult
end

SystemsFruCtrl.SetPowerOnStrategyExceptionsRsp = TSetPowerOnStrategyExceptionsRsp

---@class SystemsFruCtrl.SetPowerOnStrategyExceptionsReq
---@field Reason string
---@field Execute string
---@field EffectivePeriod string
---@field Priority integer
local TSetPowerOnStrategyExceptionsReq = {}
TSetPowerOnStrategyExceptionsReq.__index = TSetPowerOnStrategyExceptionsReq
TSetPowerOnStrategyExceptionsReq.group = {}

local function TSetPowerOnStrategyExceptionsReq_from_obj(obj)
    return setmetatable(obj, TSetPowerOnStrategyExceptionsReq)
end

function TSetPowerOnStrategyExceptionsReq.new(Reason, Execute, EffectivePeriod, Priority)
    return TSetPowerOnStrategyExceptionsReq_from_obj({
        Reason = Reason,
        Execute = Execute,
        EffectivePeriod = EffectivePeriod,
        Priority = Priority
    })
end
---@param obj SystemsFruCtrl.SetPowerOnStrategyExceptionsReq
function TSetPowerOnStrategyExceptionsReq:init_from_obj(obj)
    self.Reason = obj.Reason
    self.Execute = obj.Execute
    self.EffectivePeriod = obj.EffectivePeriod
    self.Priority = obj.Priority
end

function TSetPowerOnStrategyExceptionsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetPowerOnStrategyExceptionsReq.group)
end

TSetPowerOnStrategyExceptionsReq.from_obj = TSetPowerOnStrategyExceptionsReq_from_obj

TSetPowerOnStrategyExceptionsReq.proto_property = {'Reason', 'Execute', 'EffectivePeriod', 'Priority'}

TSetPowerOnStrategyExceptionsReq.default = {'', '', '', 0}

TSetPowerOnStrategyExceptionsReq.struct = {
    {name = 'Reason', is_array = false, struct = nil}, {name = 'Execute', is_array = false, struct = nil},
    {name = 'EffectivePeriod', is_array = false, struct = nil}, {name = 'Priority', is_array = false, struct = nil}
}

function TSetPowerOnStrategyExceptionsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Reason', self.Reason, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Execute', self.Execute, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'EffectivePeriod', self.EffectivePeriod, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'Priority', self.Priority, 'uint8', false, errs, need_convert)

    TSetPowerOnStrategyExceptionsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetPowerOnStrategyExceptionsReq.proto_property, errs, need_convert)
    return self
end

function TSetPowerOnStrategyExceptionsReq:unpack(_)
    return self.Reason, self.Execute, self.EffectivePeriod, self.Priority
end

SystemsFruCtrl.SetPowerOnStrategyExceptionsReq = TSetPowerOnStrategyExceptionsReq

---@class SystemsFruCtrl.PowerCtrlRsp
---@field CmdResult integer
local TPowerCtrlRsp = {}
TPowerCtrlRsp.__index = TPowerCtrlRsp
TPowerCtrlRsp.group = {}

local function TPowerCtrlRsp_from_obj(obj)
    return setmetatable(obj, TPowerCtrlRsp)
end

function TPowerCtrlRsp.new(CmdResult)
    return TPowerCtrlRsp_from_obj({CmdResult = CmdResult})
end
---@param obj SystemsFruCtrl.PowerCtrlRsp
function TPowerCtrlRsp:init_from_obj(obj)
    self.CmdResult = obj.CmdResult
end

function TPowerCtrlRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerCtrlRsp.group)
end

TPowerCtrlRsp.from_obj = TPowerCtrlRsp_from_obj

TPowerCtrlRsp.proto_property = {'CmdResult'}

TPowerCtrlRsp.default = {0}

TPowerCtrlRsp.struct = {{name = 'CmdResult', is_array = false, struct = nil}}

function TPowerCtrlRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'CmdResult', self.CmdResult, 'int32', false, errs, need_convert)

    TPowerCtrlRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerCtrlRsp.proto_property, errs, need_convert)
    return self
end

function TPowerCtrlRsp:unpack(_)
    return self.CmdResult
end

SystemsFruCtrl.PowerCtrlRsp = TPowerCtrlRsp

---@class SystemsFruCtrl.PowerCtrlReq
---@field PowerCtrlType string
---@field RestartCause string
local TPowerCtrlReq = {}
TPowerCtrlReq.__index = TPowerCtrlReq
TPowerCtrlReq.group = {}

local function TPowerCtrlReq_from_obj(obj)
    return setmetatable(obj, TPowerCtrlReq)
end

function TPowerCtrlReq.new(PowerCtrlType, RestartCause)
    return TPowerCtrlReq_from_obj({PowerCtrlType = PowerCtrlType, RestartCause = RestartCause})
end
---@param obj SystemsFruCtrl.PowerCtrlReq
function TPowerCtrlReq:init_from_obj(obj)
    self.PowerCtrlType = obj.PowerCtrlType
    self.RestartCause = obj.RestartCause
end

function TPowerCtrlReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerCtrlReq.group)
end

TPowerCtrlReq.from_obj = TPowerCtrlReq_from_obj

TPowerCtrlReq.proto_property = {'PowerCtrlType', 'RestartCause'}

TPowerCtrlReq.default = {'', ''}

TPowerCtrlReq.struct = {
    {name = 'PowerCtrlType', is_array = false, struct = nil}, {name = 'RestartCause', is_array = false, struct = nil}
}

function TPowerCtrlReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerCtrlType', self.PowerCtrlType, 'string', false, errs, need_convert)
    validate.Optional(prefix .. 'RestartCause', self.RestartCause, 'string', false, errs, need_convert)

    TPowerCtrlReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerCtrlReq.proto_property, errs, need_convert)
    return self
end

function TPowerCtrlReq:unpack(_)
    return self.PowerCtrlType, self.RestartCause
end

SystemsFruCtrl.PowerCtrlReq = TPowerCtrlReq

SystemsFruCtrl.interface = mdb.register_interface('bmc.kepler.Systems.FruCtrl', {
    PowerState = {'s', nil, true, nil},
    SysResetDetected = {'y', nil, true, nil},
    FruType = {'s', nil, true, nil},
    CurrentRestartCause = {'s', nil, true, nil},
    CurrentRestartCauseId = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    CurrentRestartType = {'y', nil, true, nil},
    RestartCauseRecords = {'as', {['emitsChangedSignal'] = 'false'}, true, nil},
    RestartCount = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    PowerOnStrategy = {'s', nil, false, nil},
    PowerOnStrategyExceptions = {'u', nil, false, nil},
    PanelPowerButtonEnabled = {'b', nil, false, nil},
    GracefulShutdownTimeoutEnabled = {'u', nil, false, nil},
    GracefulShutdownTimeoutSeconds = {'u', nil, false, nil},
    GracefulShutdownDefaultTimeoutSeconds = {'u', nil, true, nil},
    GracefulShutdownMaxTimeoutSeconds = {'u', {['emitsChangedSignal'] = 'const'}, true, nil},
    GracefulShutdownMinTimeoutSeconds = {'u', {['emitsChangedSignal'] = 'const'}, true, nil},
    HotswapState = {'s', nil, true, nil},
    LastPowerEvent = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    PowerCtrlFault = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    PowerCycleType = {'y', {['emitsChangedSignal'] = 'false'}, true, nil},
    PreviousPowerState = {'s', {['emitsChangedSignal'] = 'false'}, true, nil},
    ACCycleEnabled = {'b', {['emitsChangedSignal'] = 'false'}, false, nil}
}, {
    PowerCtrl = {'a{ss}ss', 'i', TPowerCtrlReq, TPowerCtrlRsp},
    SetPowerOnStrategyExceptions = {
        'a{ss}sssy', 'u', TSetPowerOnStrategyExceptionsReq, TSetPowerOnStrategyExceptionsRsp
    },
    SetACLost = {'a{ss}y', 'u', TSetACLostReq, TSetACLostRsp},
    FruPowerCtrl = {'a{ss}ssy', 'i', TFruPowerCtrlReq, TFruPowerCtrlRsp}
}, {BeforePowerOnSignal = 'a{ss}y'})

return SystemsFruCtrl
