-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local SmcFirmwareStatus = {}

---@class SmcFirmwareStatus.GetFirmwareObjectDetailsReq
---@field FirmwareType string
local TGetFirmwareObjectDetailsReq = {}
TGetFirmwareObjectDetailsReq.__index = TGetFirmwareObjectDetailsReq
TGetFirmwareObjectDetailsReq.group = {}

local function TGetFirmwareObjectDetailsReq_from_obj(obj)
    return setmetatable(obj, TGetFirmwareObjectDetailsReq)
end

function TGetFirmwareObjectDetailsReq.new(FirmwareType)
    return TGetFirmwareObjectDetailsReq_from_obj({FirmwareType = FirmwareType})
end
---@param obj SmcFirmwareStatus.GetFirmwareObjectDetailsReq
function TGetFirmwareObjectDetailsReq:init_from_obj(obj)
    self.FirmwareType = obj.FirmwareType
end

function TGetFirmwareObjectDetailsReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFirmwareObjectDetailsReq.group)
end

TGetFirmwareObjectDetailsReq.from_obj = TGetFirmwareObjectDetailsReq_from_obj

TGetFirmwareObjectDetailsReq.proto_property = {'FirmwareType'}

TGetFirmwareObjectDetailsReq.default = {''}

TGetFirmwareObjectDetailsReq.struct = {{name = 'FirmwareType', is_array = false, struct = nil}}

function TGetFirmwareObjectDetailsReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'FirmwareType', self.FirmwareType, 'string', false, errs, need_convert)

    if self.FirmwareType ~= nil then
        validate.Enum(prefix .. 'FirmwareType', self.FirmwareType, '', {'MCU', 'VRD'}, errs, need_convert)
    end

    TGetFirmwareObjectDetailsReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFirmwareObjectDetailsReq.proto_property, errs, need_convert)
    return self
end

function TGetFirmwareObjectDetailsReq:unpack(_)
    return self.FirmwareType
end

SmcFirmwareStatus.GetFirmwareObjectDetailsReq = TGetFirmwareObjectDetailsReq

---@class SmcFirmwareStatus.FirmwareObjectDetails
---@field key string
---@field value string
local TFirmwareObjectDetails = {}
TFirmwareObjectDetails.__index = TFirmwareObjectDetails
TFirmwareObjectDetails.group = {}

local function TFirmwareObjectDetails_from_obj(obj)
    return setmetatable(obj, TFirmwareObjectDetails)
end

function TFirmwareObjectDetails.new(dict)
    return TFirmwareObjectDetails_from_obj(dict)
end

---@param obj SmcFirmwareStatus.FirmwareObjectDetails
function TFirmwareObjectDetails:init_from_obj(obj)
    self = obj
end

function TFirmwareObjectDetails:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TFirmwareObjectDetails.group)
end

TFirmwareObjectDetails.from_obj = TFirmwareObjectDetails_from_obj

TFirmwareObjectDetails.proto_property = {}

TFirmwareObjectDetails.default = {}

TFirmwareObjectDetails.struct = {}

function TFirmwareObjectDetails:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for k, v in pairs(self) do

        validate.Optional(prefix .. 'key', k, 'string', false, errs, need_convert)

        validate.Optional(prefix .. 'value', v, 'string', false, errs, need_convert)

    end

    TFirmwareObjectDetails:remove_error_props(errs, self)
    return self
end

function TFirmwareObjectDetails:unpack(_)
    return self
end

SmcFirmwareStatus.FirmwareObjectDetails = TFirmwareObjectDetails

---@class SmcFirmwareStatus.GetFirmwareObjectDetailsRsp
---@field FirmwareObjectDetails SmcFirmwareStatus.FirmwareObjectDetails[]
local TGetFirmwareObjectDetailsRsp = {}
TGetFirmwareObjectDetailsRsp.__index = TGetFirmwareObjectDetailsRsp
TGetFirmwareObjectDetailsRsp.group = {}

local function TGetFirmwareObjectDetailsRsp_from_obj(obj)
    return setmetatable(obj, TGetFirmwareObjectDetailsRsp)
end

function TGetFirmwareObjectDetailsRsp.new(FirmwareObjectDetails)
    return TGetFirmwareObjectDetailsRsp_from_obj({FirmwareObjectDetails = FirmwareObjectDetails})
end
---@param obj SmcFirmwareStatus.GetFirmwareObjectDetailsRsp
function TGetFirmwareObjectDetailsRsp:init_from_obj(obj)
    self.FirmwareObjectDetails = obj.FirmwareObjectDetails
end

function TGetFirmwareObjectDetailsRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetFirmwareObjectDetailsRsp.group)
end

TGetFirmwareObjectDetailsRsp.from_obj = TGetFirmwareObjectDetailsRsp_from_obj

TGetFirmwareObjectDetailsRsp.proto_property = {'FirmwareObjectDetails'}

TGetFirmwareObjectDetailsRsp.default = {{}}

TGetFirmwareObjectDetailsRsp.struct = {
    {name = 'FirmwareObjectDetails', is_array = true, struct = SmcFirmwareStatus.FirmwareObjectDetails.struct}
}

function TGetFirmwareObjectDetailsRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    for _, v in pairs(self.FirmwareObjectDetails) do
        SmcFirmwareStatus.FirmwareObjectDetails.new(v):validate(prefix, errs, need_convert)
    end

    TGetFirmwareObjectDetailsRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetFirmwareObjectDetailsRsp.proto_property, errs, need_convert)
    return self
end

function TGetFirmwareObjectDetailsRsp:unpack(_)
    return self.FirmwareObjectDetails
end

SmcFirmwareStatus.GetFirmwareObjectDetailsRsp = TGetFirmwareObjectDetailsRsp

SmcFirmwareStatus.interface = mdb.register_interface('bmc.kepler.Release.Systems.SmcFirmwareStatus', {}, {
    GetFirmwareObjectDetails = {
        'a{ss}s', 'aa{ss}', TGetFirmwareObjectDetailsReq, TGetFirmwareObjectDetailsRsp,
        [=[Get firmware details by firmware type.]=]
    }
}, {})

return SmcFirmwareStatus
