-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Simulate = {}

---@class Simulate.VrdUpgradeSimulated
---@field VrdUpgradeSimulated integer
local TVrdUpgradeSimulated = {}
TVrdUpgradeSimulated.__index = TVrdUpgradeSimulated
TVrdUpgradeSimulated.group = {}

local function TVrdUpgradeSimulated_from_obj(obj)
    return setmetatable(obj, TVrdUpgradeSimulated)
end

function TVrdUpgradeSimulated.new(VrdUpgradeSimulated)
    return TVrdUpgradeSimulated_from_obj({VrdUpgradeSimulated = VrdUpgradeSimulated or 0})
end
---@param obj Simulate.VrdUpgradeSimulated
function TVrdUpgradeSimulated:init_from_obj(obj)
    self.VrdUpgradeSimulated = obj.VrdUpgradeSimulated or 0
end

function TVrdUpgradeSimulated:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TVrdUpgradeSimulated.group)
end

TVrdUpgradeSimulated.from_obj = TVrdUpgradeSimulated_from_obj

TVrdUpgradeSimulated.proto_property = {'VrdUpgradeSimulated'}

TVrdUpgradeSimulated.default = {0}

TVrdUpgradeSimulated.struct = {{name = 'VrdUpgradeSimulated', is_array = false, struct = nil}}

function TVrdUpgradeSimulated:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'VrdUpgradeSimulated', self.VrdUpgradeSimulated, 'uint8', false, errs, need_convert)

    TVrdUpgradeSimulated:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TVrdUpgradeSimulated.proto_property, errs, need_convert)
    return self
end

function TVrdUpgradeSimulated:unpack(_)
    return self.VrdUpgradeSimulated
end

Simulate.VrdUpgradeSimulated = TVrdUpgradeSimulated

Simulate.interface = mdb.register_interface('bmc.kepler.Manufacture.Simulate',
    {VrdUpgradeSimulated = {'y', nil, false, 0}}, {}, {})

return Simulate
