-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local SOL = {}

---@class SOL.SerialDirection
---@field SerialDirection integer
local TSerialDirection = {}
TSerialDirection.__index = TSerialDirection
TSerialDirection.group = {}

local function TSerialDirection_from_obj(obj)
    return setmetatable(obj, TSerialDirection)
end

function TSerialDirection.new(SerialDirection)
    return TSerialDirection_from_obj({SerialDirection = SerialDirection or 0})
end
---@param obj SOL.SerialDirection
function TSerialDirection:init_from_obj(obj)
    self.SerialDirection = obj.SerialDirection or 0
end

function TSerialDirection:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSerialDirection.group)
end

TSerialDirection.from_obj = TSerialDirection_from_obj

TSerialDirection.proto_property = {'SerialDirection'}

TSerialDirection.default = {0}

TSerialDirection.struct = {{name = 'SerialDirection', is_array = false, struct = nil}}

function TSerialDirection:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SerialDirection', self.SerialDirection, 'uint8', true, errs, need_convert)

    if self.SerialDirection ~= nil then
        validate.Enum(prefix .. 'SerialDirection', self.SerialDirection, '', {0, 1, 2, 3}, errs, need_convert)
    end

    TSerialDirection:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSerialDirection.proto_property, errs, need_convert)
    return self
end

function TSerialDirection:unpack(_)
    return self.SerialDirection
end

SOL.SerialDirection = TSerialDirection

---@class SOL.Enabled
---@field Enabled boolean
local TEnabled = {}
TEnabled.__index = TEnabled
TEnabled.group = {}

local function TEnabled_from_obj(obj)
    return setmetatable(obj, TEnabled)
end

function TEnabled.new(Enabled)
    return TEnabled_from_obj({Enabled = Enabled == nil and true or Enabled})
end
---@param obj SOL.Enabled
function TEnabled:init_from_obj(obj)
    self.Enabled = obj.Enabled == nil and true or obj.Enabled
end

function TEnabled:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TEnabled.group)
end

TEnabled.from_obj = TEnabled_from_obj

TEnabled.proto_property = {'Enabled'}

TEnabled.default = {false}

TEnabled.struct = {{name = 'Enabled', is_array = false, struct = nil}}

function TEnabled:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Enabled', self.Enabled, 'bool', true, errs, need_convert)

    TEnabled:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TEnabled.proto_property, errs, need_convert)
    return self
end

function TEnabled:unpack(_)
    return self.Enabled
end

SOL.Enabled = TEnabled

---@class SOL.SetSerialDirectionRsp
local TSetSerialDirectionRsp = {}
TSetSerialDirectionRsp.__index = TSetSerialDirectionRsp
TSetSerialDirectionRsp.group = {}

local function TSetSerialDirectionRsp_from_obj(obj)
    return setmetatable(obj, TSetSerialDirectionRsp)
end

function TSetSerialDirectionRsp.new()
    return TSetSerialDirectionRsp_from_obj({})
end
---@param obj SOL.SetSerialDirectionRsp
function TSetSerialDirectionRsp:init_from_obj(obj)

end

function TSetSerialDirectionRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSerialDirectionRsp.group)
end

TSetSerialDirectionRsp.from_obj = TSetSerialDirectionRsp_from_obj

TSetSerialDirectionRsp.proto_property = {}

TSetSerialDirectionRsp.default = {}

TSetSerialDirectionRsp.struct = {}

function TSetSerialDirectionRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TSetSerialDirectionRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSerialDirectionRsp.proto_property, errs, need_convert)
    return self
end

function TSetSerialDirectionRsp:unpack(_)
end

SOL.SetSerialDirectionRsp = TSetSerialDirectionRsp

---@class SOL.SetSerialDirectionReq
---@field SerialDirection integer
local TSetSerialDirectionReq = {}
TSetSerialDirectionReq.__index = TSetSerialDirectionReq
TSetSerialDirectionReq.group = {}

local function TSetSerialDirectionReq_from_obj(obj)
    return setmetatable(obj, TSetSerialDirectionReq)
end

function TSetSerialDirectionReq.new(SerialDirection)
    return TSetSerialDirectionReq_from_obj({SerialDirection = SerialDirection})
end
---@param obj SOL.SetSerialDirectionReq
function TSetSerialDirectionReq:init_from_obj(obj)
    self.SerialDirection = obj.SerialDirection
end

function TSetSerialDirectionReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetSerialDirectionReq.group)
end

TSetSerialDirectionReq.from_obj = TSetSerialDirectionReq_from_obj

TSetSerialDirectionReq.proto_property = {'SerialDirection'}

TSetSerialDirectionReq.default = {0}

TSetSerialDirectionReq.struct = {{name = 'SerialDirection', is_array = false, struct = nil}}

function TSetSerialDirectionReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'SerialDirection', self.SerialDirection, 'uint8', false, errs, need_convert)

    if self.SerialDirection ~= nil then
        validate.Enum(prefix .. 'SerialDirection', self.SerialDirection, '', {0, 1, 2, 3}, errs, need_convert)
    end

    TSetSerialDirectionReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetSerialDirectionReq.proto_property, errs, need_convert)
    return self
end

function TSetSerialDirectionReq:unpack(_)
    return self.SerialDirection
end

SOL.SetSerialDirectionReq = TSetSerialDirectionReq

SOL.interface = mdb.register_interface('bmc.kepler.Systems.DPUCard.Manager.SOL',
    {Enabled = {'b', {}, true, true}, SerialDirection = {'y', {}, true, 0}}, {
        SetSerialDirection = {'a{ss}y', '', TSetSerialDirectionReq, TSetSerialDirectionRsp}
    }, {})

return SOL
