-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local ProcessorMetrics = {}

---@class ProcessorMetrics.BandwidthThresholdPercent
---@field BandwidthThresholdPercent integer
local TBandwidthThresholdPercent = {}
TBandwidthThresholdPercent.__index = TBandwidthThresholdPercent
TBandwidthThresholdPercent.group = {}

local function TBandwidthThresholdPercent_from_obj(obj)
    return setmetatable(obj, TBandwidthThresholdPercent)
end

function TBandwidthThresholdPercent.new(BandwidthThresholdPercent)
    return TBandwidthThresholdPercent_from_obj({BandwidthThresholdPercent = BandwidthThresholdPercent})
end
---@param obj ProcessorMetrics.BandwidthThresholdPercent
function TBandwidthThresholdPercent:init_from_obj(obj)
    self.BandwidthThresholdPercent = obj.BandwidthThresholdPercent
end

function TBandwidthThresholdPercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBandwidthThresholdPercent.group)
end

TBandwidthThresholdPercent.from_obj = TBandwidthThresholdPercent_from_obj

TBandwidthThresholdPercent.proto_property = {'BandwidthThresholdPercent'}

TBandwidthThresholdPercent.default = {0}

TBandwidthThresholdPercent.struct = {{name = 'BandwidthThresholdPercent', is_array = false, struct = nil}}

function TBandwidthThresholdPercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BandwidthThresholdPercent', self.BandwidthThresholdPercent, 'uint8', true, errs,
        need_convert)

    TBandwidthThresholdPercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBandwidthThresholdPercent.proto_property, errs, need_convert)
    return self
end

function TBandwidthThresholdPercent:unpack(_)
    return self.BandwidthThresholdPercent
end

ProcessorMetrics.BandwidthThresholdPercent = TBandwidthThresholdPercent

---@class ProcessorMetrics.BandwidthPercent
---@field BandwidthPercent integer
local TBandwidthPercent = {}
TBandwidthPercent.__index = TBandwidthPercent
TBandwidthPercent.group = {}

local function TBandwidthPercent_from_obj(obj)
    return setmetatable(obj, TBandwidthPercent)
end

function TBandwidthPercent.new(BandwidthPercent)
    return TBandwidthPercent_from_obj({BandwidthPercent = BandwidthPercent})
end
---@param obj ProcessorMetrics.BandwidthPercent
function TBandwidthPercent:init_from_obj(obj)
    self.BandwidthPercent = obj.BandwidthPercent
end

function TBandwidthPercent:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TBandwidthPercent.group)
end

TBandwidthPercent.from_obj = TBandwidthPercent_from_obj

TBandwidthPercent.proto_property = {'BandwidthPercent'}

TBandwidthPercent.default = {0}

TBandwidthPercent.struct = {{name = 'BandwidthPercent', is_array = false, struct = nil}}

function TBandwidthPercent:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BandwidthPercent', self.BandwidthPercent, 'uint8', true, errs, need_convert)

    TBandwidthPercent:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TBandwidthPercent.proto_property, errs, need_convert)
    return self
end

function TBandwidthPercent:unpack(_)
    return self.BandwidthPercent
end

ProcessorMetrics.BandwidthPercent = TBandwidthPercent

---@class ProcessorMetrics.ConsumedPowerWatt
---@field ConsumedPowerWatt integer
local TConsumedPowerWatt = {}
TConsumedPowerWatt.__index = TConsumedPowerWatt
TConsumedPowerWatt.group = {}

local function TConsumedPowerWatt_from_obj(obj)
    return setmetatable(obj, TConsumedPowerWatt)
end

function TConsumedPowerWatt.new(ConsumedPowerWatt)
    return TConsumedPowerWatt_from_obj({ConsumedPowerWatt = ConsumedPowerWatt or 0})
end
---@param obj ProcessorMetrics.ConsumedPowerWatt
function TConsumedPowerWatt:init_from_obj(obj)
    self.ConsumedPowerWatt = obj.ConsumedPowerWatt or 0
end

function TConsumedPowerWatt:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TConsumedPowerWatt.group)
end

TConsumedPowerWatt.from_obj = TConsumedPowerWatt_from_obj

TConsumedPowerWatt.proto_property = {'ConsumedPowerWatt'}

TConsumedPowerWatt.default = {0}

TConsumedPowerWatt.struct = {{name = 'ConsumedPowerWatt', is_array = false, struct = nil}}

function TConsumedPowerWatt:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ConsumedPowerWatt', self.ConsumedPowerWatt, 'uint32', true, errs, need_convert)

    TConsumedPowerWatt:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TConsumedPowerWatt.proto_property, errs, need_convert)
    return self
end

function TConsumedPowerWatt:unpack(_)
    return self.ConsumedPowerWatt
end

ProcessorMetrics.ConsumedPowerWatt = TConsumedPowerWatt

---@class ProcessorMetrics.ClearBandwidthHistoryRsp
local TClearBandwidthHistoryRsp = {}
TClearBandwidthHistoryRsp.__index = TClearBandwidthHistoryRsp
TClearBandwidthHistoryRsp.group = {}

local function TClearBandwidthHistoryRsp_from_obj(obj)
    return setmetatable(obj, TClearBandwidthHistoryRsp)
end

function TClearBandwidthHistoryRsp.new()
    return TClearBandwidthHistoryRsp_from_obj({})
end
---@param obj ProcessorMetrics.ClearBandwidthHistoryRsp
function TClearBandwidthHistoryRsp:init_from_obj(obj)

end

function TClearBandwidthHistoryRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClearBandwidthHistoryRsp.group)
end

TClearBandwidthHistoryRsp.from_obj = TClearBandwidthHistoryRsp_from_obj

TClearBandwidthHistoryRsp.proto_property = {}

TClearBandwidthHistoryRsp.default = {}

TClearBandwidthHistoryRsp.struct = {}

function TClearBandwidthHistoryRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TClearBandwidthHistoryRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClearBandwidthHistoryRsp.proto_property, errs, need_convert)
    return self
end

function TClearBandwidthHistoryRsp:unpack(_)
end

ProcessorMetrics.ClearBandwidthHistoryRsp = TClearBandwidthHistoryRsp

---@class ProcessorMetrics.ClearBandwidthHistoryReq
local TClearBandwidthHistoryReq = {}
TClearBandwidthHistoryReq.__index = TClearBandwidthHistoryReq
TClearBandwidthHistoryReq.group = {}

local function TClearBandwidthHistoryReq_from_obj(obj)
    return setmetatable(obj, TClearBandwidthHistoryReq)
end

function TClearBandwidthHistoryReq.new()
    return TClearBandwidthHistoryReq_from_obj({})
end
---@param obj ProcessorMetrics.ClearBandwidthHistoryReq
function TClearBandwidthHistoryReq:init_from_obj(obj)

end

function TClearBandwidthHistoryReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TClearBandwidthHistoryReq.group)
end

TClearBandwidthHistoryReq.from_obj = TClearBandwidthHistoryReq_from_obj

TClearBandwidthHistoryReq.proto_property = {}

TClearBandwidthHistoryReq.default = {}

TClearBandwidthHistoryReq.struct = {}

function TClearBandwidthHistoryReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TClearBandwidthHistoryReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TClearBandwidthHistoryReq.proto_property, errs, need_convert)
    return self
end

function TClearBandwidthHistoryReq:unpack(_)
end

ProcessorMetrics.ClearBandwidthHistoryReq = TClearBandwidthHistoryReq

---@class ProcessorMetrics.GetBandwidthHistoryRsp
---@field History string
local TGetBandwidthHistoryRsp = {}
TGetBandwidthHistoryRsp.__index = TGetBandwidthHistoryRsp
TGetBandwidthHistoryRsp.group = {}

local function TGetBandwidthHistoryRsp_from_obj(obj)
    return setmetatable(obj, TGetBandwidthHistoryRsp)
end

function TGetBandwidthHistoryRsp.new(History)
    return TGetBandwidthHistoryRsp_from_obj({History = History})
end
---@param obj ProcessorMetrics.GetBandwidthHistoryRsp
function TGetBandwidthHistoryRsp:init_from_obj(obj)
    self.History = obj.History
end

function TGetBandwidthHistoryRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBandwidthHistoryRsp.group)
end

TGetBandwidthHistoryRsp.from_obj = TGetBandwidthHistoryRsp_from_obj

TGetBandwidthHistoryRsp.proto_property = {'History'}

TGetBandwidthHistoryRsp.default = {''}

TGetBandwidthHistoryRsp.struct = {{name = 'History', is_array = false, struct = nil}}

function TGetBandwidthHistoryRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'History', self.History, 'string', false, errs, need_convert)

    TGetBandwidthHistoryRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBandwidthHistoryRsp.proto_property, errs, need_convert)
    return self
end

function TGetBandwidthHistoryRsp:unpack(_)
    return self.History
end

ProcessorMetrics.GetBandwidthHistoryRsp = TGetBandwidthHistoryRsp

---@class ProcessorMetrics.GetBandwidthHistoryReq
local TGetBandwidthHistoryReq = {}
TGetBandwidthHistoryReq.__index = TGetBandwidthHistoryReq
TGetBandwidthHistoryReq.group = {}

local function TGetBandwidthHistoryReq_from_obj(obj)
    return setmetatable(obj, TGetBandwidthHistoryReq)
end

function TGetBandwidthHistoryReq.new()
    return TGetBandwidthHistoryReq_from_obj({})
end
---@param obj ProcessorMetrics.GetBandwidthHistoryReq
function TGetBandwidthHistoryReq:init_from_obj(obj)

end

function TGetBandwidthHistoryReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TGetBandwidthHistoryReq.group)
end

TGetBandwidthHistoryReq.from_obj = TGetBandwidthHistoryReq_from_obj

TGetBandwidthHistoryReq.proto_property = {}

TGetBandwidthHistoryReq.default = {}

TGetBandwidthHistoryReq.struct = {}

function TGetBandwidthHistoryReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    TGetBandwidthHistoryReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TGetBandwidthHistoryReq.proto_property, errs, need_convert)
    return self
end

function TGetBandwidthHistoryReq:unpack(_)
end

ProcessorMetrics.GetBandwidthHistoryReq = TGetBandwidthHistoryReq

---@class ProcessorMetrics.SetBandwidthThresholdRsp
---@field Result integer
local TSetBandwidthThresholdRsp = {}
TSetBandwidthThresholdRsp.__index = TSetBandwidthThresholdRsp
TSetBandwidthThresholdRsp.group = {}

local function TSetBandwidthThresholdRsp_from_obj(obj)
    return setmetatable(obj, TSetBandwidthThresholdRsp)
end

function TSetBandwidthThresholdRsp.new(Result)
    return TSetBandwidthThresholdRsp_from_obj({Result = Result})
end
---@param obj ProcessorMetrics.SetBandwidthThresholdRsp
function TSetBandwidthThresholdRsp:init_from_obj(obj)
    self.Result = obj.Result
end

function TSetBandwidthThresholdRsp:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBandwidthThresholdRsp.group)
end

TSetBandwidthThresholdRsp.from_obj = TSetBandwidthThresholdRsp_from_obj

TSetBandwidthThresholdRsp.proto_property = {'Result'}

TSetBandwidthThresholdRsp.default = {0}

TSetBandwidthThresholdRsp.struct = {{name = 'Result', is_array = false, struct = nil}}

function TSetBandwidthThresholdRsp:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'Result', self.Result, 'int32', false, errs, need_convert)

    TSetBandwidthThresholdRsp:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBandwidthThresholdRsp.proto_property, errs, need_convert)
    return self
end

function TSetBandwidthThresholdRsp:unpack(_)
    return self.Result
end

ProcessorMetrics.SetBandwidthThresholdRsp = TSetBandwidthThresholdRsp

---@class ProcessorMetrics.SetBandwidthThresholdReq
---@field BandwidthThresholdPercent integer
local TSetBandwidthThresholdReq = {}
TSetBandwidthThresholdReq.__index = TSetBandwidthThresholdReq
TSetBandwidthThresholdReq.group = {}

local function TSetBandwidthThresholdReq_from_obj(obj)
    return setmetatable(obj, TSetBandwidthThresholdReq)
end

function TSetBandwidthThresholdReq.new(BandwidthThresholdPercent)
    return TSetBandwidthThresholdReq_from_obj({BandwidthThresholdPercent = BandwidthThresholdPercent})
end
---@param obj ProcessorMetrics.SetBandwidthThresholdReq
function TSetBandwidthThresholdReq:init_from_obj(obj)
    self.BandwidthThresholdPercent = obj.BandwidthThresholdPercent
end

function TSetBandwidthThresholdReq:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TSetBandwidthThresholdReq.group)
end

TSetBandwidthThresholdReq.from_obj = TSetBandwidthThresholdReq_from_obj

TSetBandwidthThresholdReq.proto_property = {'BandwidthThresholdPercent'}

TSetBandwidthThresholdReq.default = {0}

TSetBandwidthThresholdReq.struct = {{name = 'BandwidthThresholdPercent', is_array = false, struct = nil}}

function TSetBandwidthThresholdReq:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'BandwidthThresholdPercent', self.BandwidthThresholdPercent, 'uint8', false, errs,
        need_convert)

    TSetBandwidthThresholdReq:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TSetBandwidthThresholdReq.proto_property, errs, need_convert)
    return self
end

function TSetBandwidthThresholdReq:unpack(_)
    return self.BandwidthThresholdPercent
end

ProcessorMetrics.SetBandwidthThresholdReq = TSetBandwidthThresholdReq

ProcessorMetrics.interface = mdb.register_interface('bmc.kepler.Systems.Processor.ProcessorMetrics', {
    ConsumedPowerWatt = {'u', {'EMIT_CHANGE', 'VOLATILE'}, true, 0},
    BandwidthPercent = {'y', {'EMIT_CHANGE'}, true, nil},
    BandwidthThresholdPercent = {'y', nil, true, nil}
}, {
    SetBandwidthThreshold = {'a{ss}y', 'i', TSetBandwidthThresholdReq, TSetBandwidthThresholdRsp},
    GetBandwidthHistory = {'a{ss}', 's', TGetBandwidthHistoryReq, TGetBandwidthHistoryRsp},
    ClearBandwidthHistory = {'a{ss}', '', TClearBandwidthHistoryReq, TClearBandwidthHistoryRsp}
}, {})

return ProcessorMetrics
