-- Copyright (c) 2024 Huawei Technologies Co., Ltd.
-- openUBMC is licensed under Mulan PSL v2.
-- You can use this software according to the terms and conditions of the Mulan PSL v2.
-- You may obtain a copy of Mulan PSL v2 at:
--          http://license.coscl.org.cn/MulanPSL2
-- THIS SOFTWARE IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OF ANY KIND,
-- EITHER EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO NON-INFRINGEMENT,
-- MERCHANTABILITY OR FIT FOR A PARTICULAR PURPOSE.
-- See the Mulan PSL v2 for more details.
local validate = require 'mc.validate'
local utils = require 'mc.utils'
local mdb = require 'mc.mdb'

local Power = {}

---@class Power.ExternalPowerSufficient
---@field ExternalPowerSufficient integer
local TExternalPowerSufficient = {}
TExternalPowerSufficient.__index = TExternalPowerSufficient
TExternalPowerSufficient.group = {}

local function TExternalPowerSufficient_from_obj(obj)
    return setmetatable(obj, TExternalPowerSufficient)
end

function TExternalPowerSufficient.new(ExternalPowerSufficient)
    return TExternalPowerSufficient_from_obj({ExternalPowerSufficient = ExternalPowerSufficient or 255})
end
---@param obj Power.ExternalPowerSufficient
function TExternalPowerSufficient:init_from_obj(obj)
    self.ExternalPowerSufficient = obj.ExternalPowerSufficient or 255
end

function TExternalPowerSufficient:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TExternalPowerSufficient.group)
end

TExternalPowerSufficient.from_obj = TExternalPowerSufficient_from_obj

TExternalPowerSufficient.proto_property = {'ExternalPowerSufficient'}

TExternalPowerSufficient.default = {0}

TExternalPowerSufficient.struct = {{name = 'ExternalPowerSufficient', is_array = false, struct = nil}}

function TExternalPowerSufficient:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'ExternalPowerSufficient', self.ExternalPowerSufficient, 'uint8', true, errs,
        need_convert)

    TExternalPowerSufficient:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TExternalPowerSufficient.proto_property, errs, need_convert)
    return self
end

function TExternalPowerSufficient:unpack(_)
    return self.ExternalPowerSufficient
end

Power.ExternalPowerSufficient = TExternalPowerSufficient

---@class Power.PowerBrakeSet
---@field PowerBrakeSet integer
local TPowerBrakeSet = {}
TPowerBrakeSet.__index = TPowerBrakeSet
TPowerBrakeSet.group = {}

local function TPowerBrakeSet_from_obj(obj)
    return setmetatable(obj, TPowerBrakeSet)
end

function TPowerBrakeSet.new(PowerBrakeSet)
    return TPowerBrakeSet_from_obj({PowerBrakeSet = PowerBrakeSet or 255})
end
---@param obj Power.PowerBrakeSet
function TPowerBrakeSet:init_from_obj(obj)
    self.PowerBrakeSet = obj.PowerBrakeSet or 255
end

function TPowerBrakeSet:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerBrakeSet.group)
end

TPowerBrakeSet.from_obj = TPowerBrakeSet_from_obj

TPowerBrakeSet.proto_property = {'PowerBrakeSet'}

TPowerBrakeSet.default = {0}

TPowerBrakeSet.struct = {{name = 'PowerBrakeSet', is_array = false, struct = nil}}

function TPowerBrakeSet:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerBrakeSet', self.PowerBrakeSet, 'uint8', true, errs, need_convert)

    TPowerBrakeSet:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerBrakeSet.proto_property, errs, need_convert)
    return self
end

function TPowerBrakeSet:unpack(_)
    return self.PowerBrakeSet
end

Power.PowerBrakeSet = TPowerBrakeSet

---@class Power.PowerWatts
---@field PowerWatts integer
local TPowerWatts = {}
TPowerWatts.__index = TPowerWatts
TPowerWatts.group = {}

local function TPowerWatts_from_obj(obj)
    return setmetatable(obj, TPowerWatts)
end

function TPowerWatts.new(PowerWatts)
    return TPowerWatts_from_obj({PowerWatts = PowerWatts})
end
---@param obj Power.PowerWatts
function TPowerWatts:init_from_obj(obj)
    self.PowerWatts = obj.PowerWatts
end

function TPowerWatts:remove_error_props(errs, obj)
    utils.remove_obj_error_property(obj, errs, TPowerWatts.group)
end

TPowerWatts.from_obj = TPowerWatts_from_obj

TPowerWatts.proto_property = {'PowerWatts'}

TPowerWatts.default = {0}

TPowerWatts.struct = {{name = 'PowerWatts', is_array = false, struct = nil}}

function TPowerWatts:validate(prefix, errs, need_convert)
    prefix = prefix or ''

    validate.Optional(prefix .. 'PowerWatts', self.PowerWatts, 'uint16', true, errs, need_convert)

    TPowerWatts:remove_error_props(errs, self)
    validate.CheckUnknowProperty(self, TPowerWatts.proto_property, errs, need_convert)
    return self
end

function TPowerWatts:unpack(_)
    return self.PowerWatts
end

Power.PowerWatts = TPowerWatts

Power.interface = mdb.register_interface('bmc.kepler.Systems.Processor.GPU.Power', {
    PowerWatts = {'q', {'EMIT_CHANGE', 'VOLATILE'}, true, nil},
    PowerBrakeSet = {'y', {'EMIT_CHANGE'}, true, 255},
    ExternalPowerSufficient = {'y', {'EMIT_CHANGE'}, true, 255}
}, {}, {})

return Power
